/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt.eis;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;

public abstract class CachingSessionDAO
extends AbstractSessionDAO
implements CacheManagerAware {
    public static final String ACTIVE_SESSION_CACHE_NAME = "shiro-activeSessionCache";
    private CacheManager cacheManager;
    private Cache<Serializable, Session> activeSessions;
    private String activeSessionsCacheName = "shiro-activeSessionCache";

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getActiveSessionsCacheName() {
        return this.activeSessionsCacheName;
    }

    public void setActiveSessionsCacheName(String activeSessionsCacheName) {
        this.activeSessionsCacheName = activeSessionsCacheName;
    }

    public Cache<Serializable, Session> getActiveSessionsCache() {
        return this.activeSessions;
    }

    public void setActiveSessionsCache(Cache<Serializable, Session> cache) {
        this.activeSessions = cache;
    }

    private Cache<Serializable, Session> getActiveSessionsCacheLazy() {
        if (this.activeSessions == null) {
            this.activeSessions = this.createActiveSessionsCache();
        }
        return this.activeSessions;
    }

    protected Cache<Serializable, Session> createActiveSessionsCache() {
        Cache cache = null;
        CacheManager mgr = this.getCacheManager();
        if (mgr != null) {
            String name = this.getActiveSessionsCacheName();
            cache = mgr.getCache(name);
        }
        return cache;
    }

    @Override
    public Serializable create(Session session) {
        Serializable sessionId = super.create(session);
        this.cache(session, sessionId);
        return sessionId;
    }

    protected Session getCachedSession(Serializable sessionId) {
        Cache<Serializable, Session> cache;
        Session cached = null;
        if (sessionId != null && (cache = this.getActiveSessionsCacheLazy()) != null) {
            cached = this.getCachedSession(sessionId, cache);
        }
        return cached;
    }

    protected Session getCachedSession(Serializable sessionId, Cache<Serializable, Session> cache) {
        return cache.get(sessionId);
    }

    protected void cache(Session session, Serializable sessionId) {
        if (session == null || sessionId == null) {
            return;
        }
        Cache<Serializable, Session> cache = this.getActiveSessionsCacheLazy();
        if (cache == null) {
            return;
        }
        this.cache(session, sessionId, cache);
    }

    protected void cache(Session session, Serializable sessionId, Cache<Serializable, Session> cache) {
        cache.put(sessionId, session);
    }

    @Override
    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        Session s = this.getCachedSession(sessionId);
        if (s == null) {
            s = super.readSession(sessionId);
        }
        return s;
    }

    @Override
    public void update(Session session) throws UnknownSessionException {
        this.doUpdate(session);
        if (session instanceof ValidatingSession) {
            if (((ValidatingSession)session).isValid()) {
                this.cache(session, session.getId());
            } else {
                this.uncache(session);
            }
        } else {
            this.cache(session, session.getId());
        }
    }

    protected abstract void doUpdate(Session var1);

    @Override
    public void delete(Session session) {
        this.uncache(session);
        this.doDelete(session);
    }

    protected abstract void doDelete(Session var1);

    protected void uncache(Session session) {
        if (session == null) {
            return;
        }
        Serializable id = session.getId();
        if (id == null) {
            return;
        }
        Cache<Serializable, Session> cache = this.getActiveSessionsCacheLazy();
        if (cache != null) {
            cache.remove(id);
        }
    }

    @Override
    public Collection<Session> getActiveSessions() {
        Cache<Serializable, Session> cache = this.getActiveSessionsCacheLazy();
        if (cache != null) {
            return cache.values();
        }
        return Collections.emptySet();
    }
}

