/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config;

import org.ehcache.config.ResourcePool;
import org.ehcache.config.SizedResourcePool;

public interface ResourceType<T extends ResourcePool> {
    public Class<T> getResourcePoolClass();

    public boolean isPersistable();

    public boolean requiresSerialization();

    public int getTierHeight();

    public static enum Core implements ResourceType<SizedResourcePool>
    {
        HEAP(false, false, 10000),
        OFFHEAP(false, true, 1000),
        DISK(true, true, 100);

        private final boolean persistable;
        private final boolean requiresSerialization;
        private final int tierHeight;

        private Core(boolean persistable, boolean requiresSerialization, int tierHeight) {
            this.persistable = persistable;
            this.requiresSerialization = requiresSerialization;
            this.tierHeight = tierHeight;
        }

        @Override
        public Class<SizedResourcePool> getResourcePoolClass() {
            return SizedResourcePool.class;
        }

        @Override
        public boolean isPersistable() {
            return this.persistable;
        }

        @Override
        public boolean requiresSerialization() {
            return this.requiresSerialization;
        }

        @Override
        public int getTierHeight() {
            return this.tierHeight;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

