/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.annotations.ContextAttribute;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.StatisticMapper;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.observer.ChainedOperationObserver;

@ContextAttribute(value="this")
public class MappedOperationStatistic<S extends Enum<S>, D extends Enum<D>>
implements OperationStatistic<D> {
    @ContextAttribute(value="name")
    public final String name;
    @ContextAttribute(value="tags")
    public final Set<String> tags;
    @ContextAttribute(value="properties")
    public final Map<String, Object> properties;
    @ContextAttribute(value="type")
    public final Class<D> outcomeType;
    private final StatisticMapper<S, D> mapper;

    public MappedOperationStatistic(Object tier, Map<D, Set<S>> translation, String statisticName, int tierHeight, String targetName, String discriminator) {
        this.name = statisticName;
        this.tags = Collections.singleton("tier");
        this.properties = new HashMap<String, Object>();
        this.properties.put("tierHeight", tierHeight);
        this.properties.put("discriminator", discriminator);
        Map.Entry<D, Set<S>> first = translation.entrySet().iterator().next();
        Class outcomeType = ((Enum)first.getValue().iterator().next()).getDeclaringClass();
        this.outcomeType = ((Enum)first.getKey()).getDeclaringClass();
        this.mapper = new StatisticMapper<S, D>(translation, MappedOperationStatistic.findOperationStat(tier, outcomeType, targetName));
    }

    @Override
    public Class<D> type() {
        return this.outcomeType;
    }

    @Override
    public ValueStatistic<Long> statistic(D result) {
        return this.mapper.statistic(result);
    }

    @Override
    public ValueStatistic<Long> statistic(Set<D> results) {
        return this.mapper.statistic(results);
    }

    @Override
    public long count(D type) {
        return this.mapper.count(type);
    }

    @Override
    public long sum(Set<D> types) {
        return this.mapper.sum(types);
    }

    @Override
    public long sum() {
        return this.mapper.sum();
    }

    @Override
    public void addDerivedStatistic(ChainedOperationObserver<? super D> derived) {
        this.mapper.addDerivedStatistic(derived);
    }

    @Override
    public void removeDerivedStatistic(ChainedOperationObserver<? super D> derived) {
        this.mapper.removeDerivedStatistic(derived);
    }

    @Override
    public void begin() {
        this.mapper.begin();
    }

    @Override
    public void end(D result) {
        this.mapper.end(result);
    }

    @Override
    public void end(D result, long ... parameters) {
        this.mapper.end(result, parameters);
    }

    private static <S extends Enum<S>> OperationStatistic<S> findOperationStat(Object rootNode, final Class<S> statisticType, String statName) {
        Query q = QueryBuilder.queryBuilder().descendants().filter(Matchers.context(Matchers.identifier(Matchers.subclassOf(OperationStatistic.class)))).filter(Matchers.context(Matchers.attributes(Matchers.allOf(Matchers.hasAttribute("name", statName), Matchers.hasAttribute("this", (Matcher<? extends Object>)new Matcher<OperationStatistic>(){

            @Override
            protected boolean matchesSafely(OperationStatistic object) {
                return object.type().equals(statisticType);
            }
        }))))).build();
        Set<TreeNode> result = q.execute(Collections.singleton(ContextManager.nodeFor(rootNode)));
        if (result.size() != 1) {
            throw new RuntimeException("a single stat was expected; found " + result.size());
        }
        TreeNode node = result.iterator().next();
        return (OperationStatistic)node.getContext().attributes().get("this");
    }
}

