/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiRollingUpgradeClusterArgs;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for the CDH Upgrade command.")
public class ApiCdhUpgradeArgs {
    @SerializedName(value="cdhParcelVersion")
    private String cdhParcelVersion = null;
    @SerializedName(value="cdhPackageVersion")
    private String cdhPackageVersion = null;
    @SerializedName(value="rollingRestartArgs")
    private ApiRollingUpgradeClusterArgs rollingRestartArgs = null;
    @SerializedName(value="deployClientConfig")
    private Boolean deployClientConfig = null;
    @SerializedName(value="startAllServices")
    private Boolean startAllServices = null;

    public ApiCdhUpgradeArgs cdhParcelVersion(String cdhParcelVersion) {
        this.cdhParcelVersion = cdhParcelVersion;
        return this;
    }

    @Schema(description="If using parcels, the full version of an already distributed parcel for the next major CDH version. Default is null, which indicates this is a package upgrade. Example versions are: '5.0.0-1.cdh5.0.0.p0.11' or '5.0.2-1.cdh5.0.2.p0.32'")
    public String getCdhParcelVersion() {
        return this.cdhParcelVersion;
    }

    public void setCdhParcelVersion(String cdhParcelVersion) {
        this.cdhParcelVersion = cdhParcelVersion;
    }

    public ApiCdhUpgradeArgs cdhPackageVersion(String cdhPackageVersion) {
        this.cdhPackageVersion = cdhPackageVersion;
        return this;
    }

    @Schema(description="If using packages, the full version of the CDH packages being upgraded to, such as \"5.1.2\". These packages must already be installed on the cluster before running the upgrade command. For backwards compatibility, if \"5.0.0\" is specified here, then the upgrade command will relax validation of installed packages to match v6 behavior, only checking major version. <p> Introduced in v9. Has no effect in older API versions, which assume \"5.0.0\"")
    public String getCdhPackageVersion() {
        return this.cdhPackageVersion;
    }

    public void setCdhPackageVersion(String cdhPackageVersion) {
        this.cdhPackageVersion = cdhPackageVersion;
    }

    public ApiCdhUpgradeArgs rollingRestartArgs(ApiRollingUpgradeClusterArgs rollingRestartArgs) {
        this.rollingRestartArgs = rollingRestartArgs;
        return this;
    }

    @Schema(description="")
    public ApiRollingUpgradeClusterArgs getRollingRestartArgs() {
        return this.rollingRestartArgs;
    }

    public void setRollingRestartArgs(ApiRollingUpgradeClusterArgs rollingRestartArgs) {
        this.rollingRestartArgs = rollingRestartArgs;
    }

    public ApiCdhUpgradeArgs deployClientConfig(Boolean deployClientConfig) {
        this.deployClientConfig = deployClientConfig;
        return this;
    }

    @Schema(description="Not used starting in v9 - Client config is always deployed as part of upgrade. For older versions, determines whether client configuration should be deployed as part of upgrade. Default is true.")
    public Boolean isDeployClientConfig() {
        return this.deployClientConfig;
    }

    public void setDeployClientConfig(Boolean deployClientConfig) {
        this.deployClientConfig = deployClientConfig;
    }

    public ApiCdhUpgradeArgs startAllServices(Boolean startAllServices) {
        this.startAllServices = startAllServices;
        return this;
    }

    @Schema(description="Not used starting in v9 - All servies are always started as part of upgrade. For older versions, determines whether all services should be started should be deployed as part of upgrade. Default is true.")
    public Boolean isStartAllServices() {
        return this.startAllServices;
    }

    public void setStartAllServices(Boolean startAllServices) {
        this.startAllServices = startAllServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCdhUpgradeArgs apiCdhUpgradeArgs = (ApiCdhUpgradeArgs)o;
        return Objects.equals(this.cdhParcelVersion, apiCdhUpgradeArgs.cdhParcelVersion) && Objects.equals(this.cdhPackageVersion, apiCdhUpgradeArgs.cdhPackageVersion) && Objects.equals(this.rollingRestartArgs, apiCdhUpgradeArgs.rollingRestartArgs) && Objects.equals(this.deployClientConfig, apiCdhUpgradeArgs.deployClientConfig) && Objects.equals(this.startAllServices, apiCdhUpgradeArgs.startAllServices);
    }

    public int hashCode() {
        return Objects.hash(this.cdhParcelVersion, this.cdhPackageVersion, this.rollingRestartArgs, this.deployClientConfig, this.startAllServices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCdhUpgradeArgs {\n");
        sb.append("    cdhParcelVersion: ").append(this.toIndentedString(this.cdhParcelVersion)).append("\n");
        sb.append("    cdhPackageVersion: ").append(this.toIndentedString(this.cdhPackageVersion)).append("\n");
        sb.append("    rollingRestartArgs: ").append(this.toIndentedString(this.rollingRestartArgs)).append("\n");
        sb.append("    deployClientConfig: ").append(this.toIndentedString(this.deployClientConfig)).append("\n");
        sb.append("    startAllServices: ").append(this.toIndentedString(this.startAllServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

