/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationCounter;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Detailed information about an HDFS replication job.")
public class ApiHdfsReplicationResult {
    @SerializedName(value="progress")
    private BigDecimal progress = null;
    @SerializedName(value="throughput")
    private BigDecimal throughput = null;
    @SerializedName(value="remainingTime")
    private BigDecimal remainingTime = null;
    @SerializedName(value="estimatedCompletionTime")
    private String estimatedCompletionTime = null;
    @SerializedName(value="counters")
    private List<ApiHdfsReplicationCounter> counters = null;
    @SerializedName(value="numFilesDryRun")
    private BigDecimal numFilesDryRun = null;
    @SerializedName(value="numBytesDryRun")
    private BigDecimal numBytesDryRun = null;
    @SerializedName(value="numFilesExpected")
    private BigDecimal numFilesExpected = null;
    @SerializedName(value="numBytesExpected")
    private BigDecimal numBytesExpected = null;
    @SerializedName(value="numFilesCopied")
    private BigDecimal numFilesCopied = null;
    @SerializedName(value="numBytesCopied")
    private BigDecimal numBytesCopied = null;
    @SerializedName(value="numFilesSkipped")
    private BigDecimal numFilesSkipped = null;
    @SerializedName(value="numBytesSkipped")
    private BigDecimal numBytesSkipped = null;
    @SerializedName(value="numFilesDeleted")
    private BigDecimal numFilesDeleted = null;
    @SerializedName(value="numFilesCopyFailed")
    private BigDecimal numFilesCopyFailed = null;
    @SerializedName(value="numBytesCopyFailed")
    private BigDecimal numBytesCopyFailed = null;
    @SerializedName(value="setupError")
    private String setupError = null;
    @SerializedName(value="jobId")
    private String jobId = null;
    @SerializedName(value="jobDetailsUri")
    private String jobDetailsUri = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="snapshottedDirs")
    private List<String> snapshottedDirs = null;
    @SerializedName(value="runAsUser")
    private String runAsUser = null;
    @SerializedName(value="runOnSourceAsUser")
    private String runOnSourceAsUser = null;
    @SerializedName(value="logPath")
    private String logPath = null;
    @SerializedName(value="failedFiles")
    private List<String> failedFiles = null;

    public ApiHdfsReplicationResult progress(BigDecimal progress) {
        this.progress = progress;
        return this;
    }

    @Schema(description="The file copy progress percentage.")
    public BigDecimal getProgress() {
        return this.progress;
    }

    public void setProgress(BigDecimal progress) {
        this.progress = progress;
    }

    public ApiHdfsReplicationResult throughput(BigDecimal throughput) {
        this.throughput = throughput;
        return this;
    }

    @Schema(description="The data throughput in KB/s.")
    public BigDecimal getThroughput() {
        return this.throughput;
    }

    public void setThroughput(BigDecimal throughput) {
        this.throughput = throughput;
    }

    public ApiHdfsReplicationResult remainingTime(BigDecimal remainingTime) {
        this.remainingTime = remainingTime;
        return this;
    }

    @Schema(description="The time remaining for mapper phase (seconds).")
    public BigDecimal getRemainingTime() {
        return this.remainingTime;
    }

    public void setRemainingTime(BigDecimal remainingTime) {
        this.remainingTime = remainingTime;
    }

    public ApiHdfsReplicationResult estimatedCompletionTime(String estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
        return this;
    }

    @Schema(description="The estimated completion time for the mapper phase.")
    public String getEstimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public void setEstimatedCompletionTime(String estimatedCompletionTime) {
        this.estimatedCompletionTime = estimatedCompletionTime;
    }

    public ApiHdfsReplicationResult counters(List<ApiHdfsReplicationCounter> counters) {
        this.counters = counters;
        return this;
    }

    public ApiHdfsReplicationResult addCountersItem(ApiHdfsReplicationCounter countersItem) {
        if (this.counters == null) {
            this.counters = new ArrayList<ApiHdfsReplicationCounter>();
        }
        this.counters.add(countersItem);
        return this;
    }

    @Schema(description="The counters collected from the replication job. <p/> Starting with API v4, the full list of counters is only available in the full view.")
    public List<ApiHdfsReplicationCounter> getCounters() {
        return this.counters;
    }

    public void setCounters(List<ApiHdfsReplicationCounter> counters) {
        this.counters = counters;
    }

    public ApiHdfsReplicationResult numFilesDryRun(BigDecimal numFilesDryRun) {
        this.numFilesDryRun = numFilesDryRun;
        return this;
    }

    @Schema(description="The number of files found to copy.")
    public BigDecimal getNumFilesDryRun() {
        return this.numFilesDryRun;
    }

    public void setNumFilesDryRun(BigDecimal numFilesDryRun) {
        this.numFilesDryRun = numFilesDryRun;
    }

    public ApiHdfsReplicationResult numBytesDryRun(BigDecimal numBytesDryRun) {
        this.numBytesDryRun = numBytesDryRun;
        return this;
    }

    @Schema(description="The number of bytes found to copy.")
    public BigDecimal getNumBytesDryRun() {
        return this.numBytesDryRun;
    }

    public void setNumBytesDryRun(BigDecimal numBytesDryRun) {
        this.numBytesDryRun = numBytesDryRun;
    }

    public ApiHdfsReplicationResult numFilesExpected(BigDecimal numFilesExpected) {
        this.numFilesExpected = numFilesExpected;
        return this;
    }

    @Schema(description="The number of files expected to be copied.")
    public BigDecimal getNumFilesExpected() {
        return this.numFilesExpected;
    }

    public void setNumFilesExpected(BigDecimal numFilesExpected) {
        this.numFilesExpected = numFilesExpected;
    }

    public ApiHdfsReplicationResult numBytesExpected(BigDecimal numBytesExpected) {
        this.numBytesExpected = numBytesExpected;
        return this;
    }

    @Schema(description="The number of bytes expected to be copied.")
    public BigDecimal getNumBytesExpected() {
        return this.numBytesExpected;
    }

    public void setNumBytesExpected(BigDecimal numBytesExpected) {
        this.numBytesExpected = numBytesExpected;
    }

    public ApiHdfsReplicationResult numFilesCopied(BigDecimal numFilesCopied) {
        this.numFilesCopied = numFilesCopied;
        return this;
    }

    @Schema(description="The number of files actually copied.")
    public BigDecimal getNumFilesCopied() {
        return this.numFilesCopied;
    }

    public void setNumFilesCopied(BigDecimal numFilesCopied) {
        this.numFilesCopied = numFilesCopied;
    }

    public ApiHdfsReplicationResult numBytesCopied(BigDecimal numBytesCopied) {
        this.numBytesCopied = numBytesCopied;
        return this;
    }

    @Schema(description="The number of bytes actually copied.")
    public BigDecimal getNumBytesCopied() {
        return this.numBytesCopied;
    }

    public void setNumBytesCopied(BigDecimal numBytesCopied) {
        this.numBytesCopied = numBytesCopied;
    }

    public ApiHdfsReplicationResult numFilesSkipped(BigDecimal numFilesSkipped) {
        this.numFilesSkipped = numFilesSkipped;
        return this;
    }

    @Schema(description="The number of files that were unchanged and thus skipped during copying.")
    public BigDecimal getNumFilesSkipped() {
        return this.numFilesSkipped;
    }

    public void setNumFilesSkipped(BigDecimal numFilesSkipped) {
        this.numFilesSkipped = numFilesSkipped;
    }

    public ApiHdfsReplicationResult numBytesSkipped(BigDecimal numBytesSkipped) {
        this.numBytesSkipped = numBytesSkipped;
        return this;
    }

    @Schema(description="The aggregate number of bytes in the skipped files.")
    public BigDecimal getNumBytesSkipped() {
        return this.numBytesSkipped;
    }

    public void setNumBytesSkipped(BigDecimal numBytesSkipped) {
        this.numBytesSkipped = numBytesSkipped;
    }

    public ApiHdfsReplicationResult numFilesDeleted(BigDecimal numFilesDeleted) {
        this.numFilesDeleted = numFilesDeleted;
        return this;
    }

    @Schema(description="The number of files deleted since they were present at destination, but missing from source.")
    public BigDecimal getNumFilesDeleted() {
        return this.numFilesDeleted;
    }

    public void setNumFilesDeleted(BigDecimal numFilesDeleted) {
        this.numFilesDeleted = numFilesDeleted;
    }

    public ApiHdfsReplicationResult numFilesCopyFailed(BigDecimal numFilesCopyFailed) {
        this.numFilesCopyFailed = numFilesCopyFailed;
        return this;
    }

    @Schema(description="The number of files for which copy failed.")
    public BigDecimal getNumFilesCopyFailed() {
        return this.numFilesCopyFailed;
    }

    public void setNumFilesCopyFailed(BigDecimal numFilesCopyFailed) {
        this.numFilesCopyFailed = numFilesCopyFailed;
    }

    public ApiHdfsReplicationResult numBytesCopyFailed(BigDecimal numBytesCopyFailed) {
        this.numBytesCopyFailed = numBytesCopyFailed;
        return this;
    }

    @Schema(description="The aggregate number of bytes in the files for which copy failed.")
    public BigDecimal getNumBytesCopyFailed() {
        return this.numBytesCopyFailed;
    }

    public void setNumBytesCopyFailed(BigDecimal numBytesCopyFailed) {
        this.numBytesCopyFailed = numBytesCopyFailed;
    }

    public ApiHdfsReplicationResult setupError(String setupError) {
        this.setupError = setupError;
        return this;
    }

    @Schema(description="The error that happened during job setup, if any.")
    public String getSetupError() {
        return this.setupError;
    }

    public void setSetupError(String setupError) {
        this.setupError = setupError;
    }

    public ApiHdfsReplicationResult jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Schema(description="Read-only. The MapReduce job ID for the replication job. Available since API v4. <p/> This can be used to query information about the replication job from the MapReduce server where it was executed. Refer to the \"/activities\" resource for services for further details.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public ApiHdfsReplicationResult jobDetailsUri(String jobDetailsUri) {
        this.jobDetailsUri = jobDetailsUri;
        return this;
    }

    @Schema(description="Read-only. The URI (relative to the CM server's root) where to find the Activity Monitor page for the job. Available since API v4.")
    public String getJobDetailsUri() {
        return this.jobDetailsUri;
    }

    public void setJobDetailsUri(String jobDetailsUri) {
        this.jobDetailsUri = jobDetailsUri;
    }

    public ApiHdfsReplicationResult dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Schema(description="Whether this was a dry run.")
    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHdfsReplicationResult snapshottedDirs(List<String> snapshottedDirs) {
        this.snapshottedDirs = snapshottedDirs;
        return this;
    }

    public ApiHdfsReplicationResult addSnapshottedDirsItem(String snapshottedDirsItem) {
        if (this.snapshottedDirs == null) {
            this.snapshottedDirs = new ArrayList<String>();
        }
        this.snapshottedDirs.add(snapshottedDirsItem);
        return this;
    }

    @Schema(description="The list of directories for which snapshots were taken and used as part of this replication.")
    public List<String> getSnapshottedDirs() {
        return this.snapshottedDirs;
    }

    public void setSnapshottedDirs(List<String> snapshottedDirs) {
        this.snapshottedDirs = snapshottedDirs;
    }

    public ApiHdfsReplicationResult runAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Schema(description="Returns run-as user name. Available since API v11.")
    public String getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    public ApiHdfsReplicationResult runOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
        return this;
    }

    @Schema(description="Returns run-as user name for source cluster. Available since API v18.")
    public String getRunOnSourceAsUser() {
        return this.runOnSourceAsUser;
    }

    public void setRunOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
    }

    public ApiHdfsReplicationResult logPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @Schema(description="Returns HDFS path of DistCp execution log files. Available since API v33.")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public ApiHdfsReplicationResult failedFiles(List<String> failedFiles) {
        this.failedFiles = failedFiles;
        return this;
    }

    public ApiHdfsReplicationResult addFailedFilesItem(String failedFilesItem) {
        if (this.failedFiles == null) {
            this.failedFiles = new ArrayList<String>();
        }
        this.failedFiles.add(failedFilesItem);
        return this;
    }

    @Schema(description="The list of files that failed during replication. Available since API v11.")
    public List<String> getFailedFiles() {
        return this.failedFiles;
    }

    public void setFailedFiles(List<String> failedFiles) {
        this.failedFiles = failedFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsReplicationResult apiHdfsReplicationResult = (ApiHdfsReplicationResult)o;
        return Objects.equals(this.progress, apiHdfsReplicationResult.progress) && Objects.equals(this.throughput, apiHdfsReplicationResult.throughput) && Objects.equals(this.remainingTime, apiHdfsReplicationResult.remainingTime) && Objects.equals(this.estimatedCompletionTime, apiHdfsReplicationResult.estimatedCompletionTime) && Objects.equals(this.counters, apiHdfsReplicationResult.counters) && Objects.equals(this.numFilesDryRun, apiHdfsReplicationResult.numFilesDryRun) && Objects.equals(this.numBytesDryRun, apiHdfsReplicationResult.numBytesDryRun) && Objects.equals(this.numFilesExpected, apiHdfsReplicationResult.numFilesExpected) && Objects.equals(this.numBytesExpected, apiHdfsReplicationResult.numBytesExpected) && Objects.equals(this.numFilesCopied, apiHdfsReplicationResult.numFilesCopied) && Objects.equals(this.numBytesCopied, apiHdfsReplicationResult.numBytesCopied) && Objects.equals(this.numFilesSkipped, apiHdfsReplicationResult.numFilesSkipped) && Objects.equals(this.numBytesSkipped, apiHdfsReplicationResult.numBytesSkipped) && Objects.equals(this.numFilesDeleted, apiHdfsReplicationResult.numFilesDeleted) && Objects.equals(this.numFilesCopyFailed, apiHdfsReplicationResult.numFilesCopyFailed) && Objects.equals(this.numBytesCopyFailed, apiHdfsReplicationResult.numBytesCopyFailed) && Objects.equals(this.setupError, apiHdfsReplicationResult.setupError) && Objects.equals(this.jobId, apiHdfsReplicationResult.jobId) && Objects.equals(this.jobDetailsUri, apiHdfsReplicationResult.jobDetailsUri) && Objects.equals(this.dryRun, apiHdfsReplicationResult.dryRun) && Objects.equals(this.snapshottedDirs, apiHdfsReplicationResult.snapshottedDirs) && Objects.equals(this.runAsUser, apiHdfsReplicationResult.runAsUser) && Objects.equals(this.runOnSourceAsUser, apiHdfsReplicationResult.runOnSourceAsUser) && Objects.equals(this.logPath, apiHdfsReplicationResult.logPath) && Objects.equals(this.failedFiles, apiHdfsReplicationResult.failedFiles);
    }

    public int hashCode() {
        return Objects.hash(this.progress, this.throughput, this.remainingTime, this.estimatedCompletionTime, this.counters, this.numFilesDryRun, this.numBytesDryRun, this.numFilesExpected, this.numBytesExpected, this.numFilesCopied, this.numBytesCopied, this.numFilesSkipped, this.numBytesSkipped, this.numFilesDeleted, this.numFilesCopyFailed, this.numBytesCopyFailed, this.setupError, this.jobId, this.jobDetailsUri, this.dryRun, this.snapshottedDirs, this.runAsUser, this.runOnSourceAsUser, this.logPath, this.failedFiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsReplicationResult {\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    throughput: ").append(this.toIndentedString(this.throughput)).append("\n");
        sb.append("    remainingTime: ").append(this.toIndentedString(this.remainingTime)).append("\n");
        sb.append("    estimatedCompletionTime: ").append(this.toIndentedString(this.estimatedCompletionTime)).append("\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("    numFilesDryRun: ").append(this.toIndentedString(this.numFilesDryRun)).append("\n");
        sb.append("    numBytesDryRun: ").append(this.toIndentedString(this.numBytesDryRun)).append("\n");
        sb.append("    numFilesExpected: ").append(this.toIndentedString(this.numFilesExpected)).append("\n");
        sb.append("    numBytesExpected: ").append(this.toIndentedString(this.numBytesExpected)).append("\n");
        sb.append("    numFilesCopied: ").append(this.toIndentedString(this.numFilesCopied)).append("\n");
        sb.append("    numBytesCopied: ").append(this.toIndentedString(this.numBytesCopied)).append("\n");
        sb.append("    numFilesSkipped: ").append(this.toIndentedString(this.numFilesSkipped)).append("\n");
        sb.append("    numBytesSkipped: ").append(this.toIndentedString(this.numBytesSkipped)).append("\n");
        sb.append("    numFilesDeleted: ").append(this.toIndentedString(this.numFilesDeleted)).append("\n");
        sb.append("    numFilesCopyFailed: ").append(this.toIndentedString(this.numFilesCopyFailed)).append("\n");
        sb.append("    numBytesCopyFailed: ").append(this.toIndentedString(this.numBytesCopyFailed)).append("\n");
        sb.append("    setupError: ").append(this.toIndentedString(this.setupError)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    jobDetailsUri: ").append(this.toIndentedString(this.jobDetailsUri)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    snapshottedDirs: ").append(this.toIndentedString(this.snapshottedDirs)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    runOnSourceAsUser: ").append(this.toIndentedString(this.runOnSourceAsUser)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    failedFiles: ").append(this.toIndentedString(this.failedFiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

