/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiParcelUsageParcel;
import com.cloudera.api.swagger.model.ApiParcelUsageRack;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This object provides a complete view of the usage of parcels in a given cluster - particularly which parcels are in use for which roles.")
public class ApiParcelUsage {
    @SerializedName(value="racks")
    private List<ApiParcelUsageRack> racks = null;
    @SerializedName(value="parcels")
    private List<ApiParcelUsageParcel> parcels = null;

    public ApiParcelUsage racks(List<ApiParcelUsageRack> racks) {
        this.racks = racks;
        return this;
    }

    public ApiParcelUsage addRacksItem(ApiParcelUsageRack racksItem) {
        if (this.racks == null) {
            this.racks = new ArrayList<ApiParcelUsageRack>();
        }
        this.racks.add(racksItem);
        return this;
    }

    @Schema(description="The racks that contain hosts that are part of this cluster.")
    public List<ApiParcelUsageRack> getRacks() {
        return this.racks;
    }

    public void setRacks(List<ApiParcelUsageRack> racks) {
        this.racks = racks;
    }

    public ApiParcelUsage parcels(List<ApiParcelUsageParcel> parcels) {
        this.parcels = parcels;
        return this;
    }

    public ApiParcelUsage addParcelsItem(ApiParcelUsageParcel parcelsItem) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<ApiParcelUsageParcel>();
        }
        this.parcels.add(parcelsItem);
        return this;
    }

    @Schema(description="The parcel's that are activated and/or in-use on this cluster.")
    public List<ApiParcelUsageParcel> getParcels() {
        return this.parcels;
    }

    public void setParcels(List<ApiParcelUsageParcel> parcels) {
        this.parcels = parcels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiParcelUsage apiParcelUsage = (ApiParcelUsage)o;
        return Objects.equals(this.racks, apiParcelUsage.racks) && Objects.equals(this.parcels, apiParcelUsage.parcels);
    }

    public int hashCode() {
        return Objects.hash(this.racks, this.parcels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiParcelUsage {\n");
        sb.append("    racks: ").append(this.toIndentedString(this.racks)).append("\n");
        sb.append("    parcels: ").append(this.toIndentedString(this.parcels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

