/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableFileUtils;

class KnoxShellTableRenderer {
    private static int CELL_PAD_SIZE = 2;
    private static char CELL_CORNER_CHAR = (char)43;
    private static char CELL_WALL_CHAR = (char)124;
    private static char CELL_DASH_CHAR = (char)45;
    private final KnoxShellTable tableToRender;

    KnoxShellTableRenderer(KnoxShellTable tableToRender) {
        this.tableToRender = tableToRender;
    }

    String toCSV() {
        return this.toCSV(null);
    }

    String toCSV(String filePath) {
        StringBuilder csv = new StringBuilder();
        for (int i = 0; i < this.tableToRender.headers.size(); ++i) {
            String header = this.tableToRender.headers.get(i);
            csv.append(header);
            if (i < this.tableToRender.headers.size() - 1) {
                csv.append(',');
                continue;
            }
            csv.append('\n');
        }
        for (List<Comparable<? extends Object>> row : this.tableToRender.rows) {
            for (int ii = 0; ii < row.size(); ++ii) {
                csv.append(row.get(ii));
                if (ii < row.size() - 1) {
                    csv.append(',');
                    continue;
                }
                csv.append('\n');
            }
        }
        String content = csv.toString();
        if (filePath != null) {
            try {
                KnoxShellTableFileUtils.persistToFile(filePath, content);
            }
            catch (IOException e) {
                System.out.println("Persistence of CSV file has failed. " + e.getMessage());
                e.printStackTrace();
            }
        }
        return content;
    }

    public String toString() {
        if (!this.tableToRender.headers.isEmpty() && !this.tableToRender.rows.isEmpty() && this.tableToRender.headers.size() != this.tableToRender.rows.get(0).size()) {
            throw new IllegalStateException("Number of columns and headers must be the same.");
        }
        StringBuilder sb = new StringBuilder();
        Map<Integer, Integer> widthMap = this.getWidthMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.tableToRender.title})) {
            sb.append(this.tableToRender.title);
            this.newLine(sb, 1);
        }
        int colCount = 0;
        if (!this.tableToRender.rows.isEmpty()) {
            colCount = this.tableToRender.rows.get(0).size();
        }
        if (!this.tableToRender.headers.isEmpty()) {
            colCount = this.tableToRender.headers.size();
            this.createBorder(sb, colCount, widthMap);
            this.newLine(sb, 1);
            sb.append(CELL_WALL_CHAR);
            for (int i = 0; i < colCount; ++i) {
                sb.append(this.centerString(widthMap.get(i) + 4, this.tableToRender.headers.get(i))).append(CELL_WALL_CHAR);
            }
            this.newLine(sb, 1);
        }
        this.createBorder(sb, colCount, widthMap);
        for (List<Comparable<? extends Object>> row : this.tableToRender.rows) {
            this.newLine(sb, 1);
            sb.append(CELL_WALL_CHAR);
            for (int i = 0; i < row.size(); ++i) {
                sb.append(this.centerString(widthMap.get(i) + 4, row.get(i).toString())).append(CELL_WALL_CHAR);
            }
        }
        this.newLine(sb, 1);
        this.createBorder(sb, colCount, widthMap);
        this.newLine(sb, 1);
        return sb.toString();
    }

    private void newLine(StringBuilder sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append('\n');
        }
    }

    private String centerString(int width, String s) {
        s = this.ensureEvenLength(s);
        return String.format(Locale.ROOT, "%-" + width + "s", String.format(Locale.ROOT, "%" + (s.length() + (width - s.length()) / 2) + "s", s));
    }

    private String ensureEvenLength(String s) {
        if (s.length() % 2 != 0) {
            s = s + " ";
        }
        return s;
    }

    private void createBorder(StringBuilder sb, int headerCount, Map<Integer, Integer> widthMap) {
        for (int i = 0; i < headerCount; ++i) {
            if (i == 0) {
                sb.append(CELL_CORNER_CHAR);
            }
            for (int j = 0; j < widthMap.get(i) + CELL_PAD_SIZE * 2; ++j) {
                sb.append(CELL_DASH_CHAR);
            }
            sb.append(CELL_CORNER_CHAR);
        }
    }

    private Map<Integer, Integer> getWidthMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String cellValue = null;
        String headerValue = null;
        for (int i = 0; i < this.tableToRender.headers.size(); ++i) {
            headerValue = this.ensureEvenLength(this.tableToRender.headers.get(i));
            map.put(i, headerValue.length());
        }
        for (List<Comparable<? extends Object>> row : this.tableToRender.rows) {
            for (int i = 0; i < row.size(); ++i) {
                Comparable<? extends Object> o = row.get(i);
                if (o == null) {
                    o = "NULL";
                    row.set(i, (Comparable<? extends Object>)((Object)((String)((Object)o))));
                }
                cellValue = this.ensureEvenLength(o.toString());
                if (map.get(i) != null && cellValue.length() <= (Integer)map.get(i)) continue;
                map.put(i, cellValue.length());
            }
        }
        return map;
    }
}

