/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.SqlException;

class CloseFilterInputStream
extends FilterInputStream {
    private static final String ALREADY_CLOSED_ERR_MESSAGE = SqlException.getMessageUtil().getTextMessage("J104", new Object[0]);
    private boolean closed = false;

    public CloseFilterInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.skip(l);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

