/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation.json;

import java.util.Collections;
import java.util.List;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas30ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.json.JsonValidationResponseParser;
import org.jasig.cas.client.validation.json.TicketValidationJsonResponse;

public class Cas30JsonProxyTicketValidator
extends Cas30ProxyTicketValidator {
    public Cas30JsonProxyTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        this.setCustomParameters(Collections.singletonMap("format", "JSON"));
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        try {
            TicketValidationJsonResponse json = new JsonValidationResponseParser().parse(response);
            return json.getAssertion(this.getProxyGrantingTicketStorage(), this.getProxyRetriever());
        }
        catch (Exception e) {
            this.logger.warn("Unable parse the JSON response");
            return super.parseResponseFromServer(response);
        }
    }

    @Override
    protected List<String> parseProxiesFromResponse(String response) {
        try {
            TicketValidationJsonResponse json = new JsonValidationResponseParser().parse(response);
            return json.getServiceResponse().getAuthenticationSuccess().getProxies();
        }
        catch (Exception e) {
            this.logger.warn("Unable to locate proxies from the JSON response", (Throwable)e);
            return super.parseProxiesFromResponse(response);
        }
    }
}

