/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.AbstractExtendedResponse;
import org.apache.directory.api.util.Strings;

public class OpaqueExtendedResponse
extends AbstractExtendedResponse {
    static final long serialVersionUID = 7916990159044177480L;
    private byte[] responseValue;

    public OpaqueExtendedResponse() {
        super(-1);
    }

    public OpaqueExtendedResponse(int messageId) {
        super(messageId);
    }

    public OpaqueExtendedResponse(String responseName) {
        super(-1, responseName);
    }

    public OpaqueExtendedResponse(int messageId, String responseName) {
        super(messageId, responseName);
    }

    public byte[] getResponseValue() {
        return this.responseValue;
    }

    public void setResponseValue(byte[] responseValue) {
        this.responseValue = responseValue;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + super.hashCode();
        if (this.responseName != null) {
            hash = hash * 17 + this.responseName.hashCode();
        }
        if (this.responseValue != null) {
            for (byte b : this.responseValue) {
                hash = hash * 17 + b;
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OpaqueExtendedResponse)) {
            return false;
        }
        OpaqueExtendedResponse extendedRequest = (OpaqueExtendedResponse)obj;
        if (this.responseName != null && !this.responseName.equals(extendedRequest.responseName) || this.responseName == null && extendedRequest.responseName != null) {
            return false;
        }
        return Arrays.equals(this.responseValue, extendedRequest.responseValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Extended response\n");
        sb.append("        Response name :  '").append(this.responseName).append("'\n");
        sb.append("        Response value : '").append(Strings.dumpBytes((byte[])this.responseValue)).append("'\n");
        return super.toString(sb.toString());
    }
}

