/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.ConfigurableDispatch;

public class HeaderPreAuthFederationDispatch
extends ConfigurableDispatch {
    String headerName = "SM_USER";

    @Override
    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        Principal principal;
        GatewayConfig config = (GatewayConfig)inboundRequest.getServletContext().getAttribute("org.apache.knox.gateway.config");
        if (config != null && config.getFederationHeaderName() != null) {
            this.headerName = config.getFederationHeaderName();
        }
        if ((principal = inboundRequest.getUserPrincipal()) != null) {
            outboundRequest.addHeader(this.headerName, principal.getName());
        }
        HttpResponse inboundResponse = this.executeOutboundRequest(outboundRequest);
        this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }
}

