/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ImpersonationProvider;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.AuthorizationException;
import org.apache.knox.gateway.util.KnoxImpersonationProvider;

public class AuthFilterUtils {
    public static final String DEFAULT_AUTH_UNAUTHENTICATED_PATHS_PARAM = "/knoxtoken/api/v1/jwks.json";
    public static final String PROXYUSER_PREFIX = "hadoop.proxyuser";
    public static final String QUERY_PARAMETER_DOAS = "doAs";
    public static final String REAL_USER_NAME_ATTRIBUTE = "real.user.name";
    public static final String DO_GLOBAL_LOGOUT_ATTRIBUTE = "do.global.logout";
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final Map<String, Map<String, ImpersonationProvider>> TOPOLOGY_IMPERSONATION_PROVIDERS = new ConcurrentHashMap<String, Map<String, ImpersonationProvider>>();
    private static final Lock refreshSuperUserGroupsLock = new ReentrantLock();
    public static final String PROXYGROUP_PREFIX = "hadoop.proxygroup";

    public static boolean doesRequestContainUnauthPath(Set<String> unAuthenticatedPaths, ServletRequest request) {
        return unAuthenticatedPaths.contains(((HttpServletRequest)request).getPathInfo());
    }

    public static void parseStringThenAdd(Set<String> unAuthenticatedPaths, String list) {
        StringTokenizer tokenizer = new StringTokenizer(list, ";,");
        while (tokenizer.hasMoreTokens()) {
            unAuthenticatedPaths.add(tokenizer.nextToken());
        }
    }

    public static void addUnauthPaths(Set<String> unAuthenticatedPaths, String list, String defaultList) {
        AuthFilterUtils.parseStringThenAdd(unAuthenticatedPaths, defaultList);
        if (!StringUtils.isBlank((CharSequence)list)) {
            AuthFilterUtils.parseStringThenAdd(unAuthenticatedPaths, list);
        }
    }

    public static void refreshSuperUserGroupsConfiguration(ServletContext context, List<String> initParameterNames, String topologyName, String role) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot get proxyuser configuration from NULL context");
        }
        AuthFilterUtils.refreshSuperUserGroupsConfiguration(context, null, initParameterNames, topologyName, role);
    }

    public static void refreshSuperUserGroupsConfiguration(FilterConfig filterConfig, List<String> initParameterNames, String topologyName, String role) {
        if (filterConfig == null) {
            throw new IllegalArgumentException("Cannot get proxyuser configuration from NULL filter config");
        }
        AuthFilterUtils.refreshSuperUserGroupsConfiguration(null, filterConfig, initParameterNames, topologyName, role);
    }

    private static void refreshSuperUserGroupsConfiguration(ServletContext context, FilterConfig filterConfig, List<String> initParameterNames, String topologyName, String role) {
        Configuration conf = new Configuration(false);
        boolean hasProxyGroupParams = false;
        if (initParameterNames != null) {
            initParameterNames.stream().filter(name -> name.startsWith("hadoop.proxyuser.")).forEach(name -> {
                String value = context == null ? filterConfig.getInitParameter(name) : context.getInitParameter(name);
                conf.set(name, value);
            });
            hasProxyGroupParams = initParameterNames.stream().anyMatch(name -> name.startsWith("hadoop.proxygroup."));
            if (hasProxyGroupParams) {
                initParameterNames.stream().filter(name -> name.startsWith("hadoop.proxygroup.")).forEach(name -> {
                    String value = context == null ? filterConfig.getInitParameter(name) : context.getInitParameter(name);
                    conf.set(name, value);
                });
            }
        }
        AuthFilterUtils.saveImpersonationProvider(topologyName, role, conf, (ImpersonationProvider)new KnoxImpersonationProvider(), PROXYUSER_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveImpersonationProvider(String topologyName, String role, Configuration conf, ImpersonationProvider impersonationProvider, String prefix) {
        refreshSuperUserGroupsLock.lock();
        try {
            impersonationProvider.setConf(conf);
            impersonationProvider.init(prefix);
            LOG.createImpersonationProvider(topologyName, role, prefix, conf.getPropsWithPrefix(prefix + ".").toString());
            TOPOLOGY_IMPERSONATION_PROVIDERS.putIfAbsent(topologyName, new ConcurrentHashMap());
            TOPOLOGY_IMPERSONATION_PROVIDERS.get(topologyName).put(role, impersonationProvider);
        }
        finally {
            refreshSuperUserGroupsLock.unlock();
        }
    }

    public static HttpServletRequest getProxyRequest(HttpServletRequest request, String doAsUser, String topologyName, String role) throws AuthorizationException {
        return AuthFilterUtils.getProxyRequest(request, request.getUserPrincipal().getName(), doAsUser, topologyName, role);
    }

    public static HttpServletRequest getProxyRequest(HttpServletRequest request, String remoteUser, String doAsUser, String topologyName, String role) throws AuthorizationException {
        final UserGroupInformation remoteRequestUgi = AuthFilterUtils.getRemoteRequestUgi(remoteUser, doAsUser);
        if (remoteRequestUgi != null) {
            AuthFilterUtils.authorizeImpersonationRequest(request, remoteRequestUgi, topologyName, role);
            return new HttpServletRequestWrapper(request){

                public String getRemoteUser() {
                    return remoteRequestUgi.getShortUserName();
                }

                public Principal getUserPrincipal() {
                    return () -> ((UserGroupInformation)remoteRequestUgi).getUserName();
                }

                public Object getAttribute(String name) {
                    if (name != null && name.equals(AuthFilterUtils.REAL_USER_NAME_ATTRIBUTE)) {
                        return remoteRequestUgi.getRealUser().getShortUserName();
                    }
                    return super.getAttribute(name);
                }
            };
        }
        return null;
    }

    private static void authorizeImpersonationRequest(HttpServletRequest request, UserGroupInformation remoteRequestUgi, String topologyName, String role) throws AuthorizationException {
        AuthFilterUtils.authorizeImpersonationRequest(request, remoteRequestUgi, topologyName, role, Collections.emptyList());
    }

    public static void authorizeImpersonationRequest(HttpServletRequest request, String remoteUser, String doAsUser, String topologyName, String role) throws AuthorizationException {
        UserGroupInformation remoteRequestUgi = AuthFilterUtils.getRemoteRequestUgi(remoteUser, doAsUser);
        if (remoteRequestUgi != null) {
            AuthFilterUtils.authorizeImpersonationRequest(request, remoteRequestUgi, topologyName, role, Collections.emptyList());
        }
    }

    public static void authorizeImpersonationRequest(HttpServletRequest request, String remoteUser, String doAsUser, String topologyName, String role, List<String> groups) throws AuthorizationException {
        UserGroupInformation remoteRequestUgi = AuthFilterUtils.getRemoteRequestUgi(remoteUser, doAsUser);
        if (remoteRequestUgi != null) {
            AuthFilterUtils.authorizeImpersonationRequest(request, remoteRequestUgi, topologyName, role, groups);
        }
    }

    private static void authorizeImpersonationRequest(HttpServletRequest request, UserGroupInformation remoteRequestUgi, String topologyName, String role, List<String> groups) throws AuthorizationException {
        ImpersonationProvider impersonationProvider = AuthFilterUtils.getImpersonationProvider(topologyName, role);
        if (impersonationProvider != null) {
            try {
                if (impersonationProvider instanceof KnoxImpersonationProvider) {
                    ((KnoxImpersonationProvider)impersonationProvider).authorize(remoteRequestUgi, InetAddress.getByName(request.getRemoteAddr()), groups);
                }
                impersonationProvider.authorize(remoteRequestUgi, request.getRemoteAddr());
            }
            catch (UnknownHostException | org.apache.hadoop.security.authorize.AuthorizationException e) {
                throw new AuthorizationException(e);
            }
        } else {
            throw new AuthorizationException("ImpersonationProvider for " + topologyName + " / " + role + " not found!");
        }
    }

    private static ImpersonationProvider getImpersonationProvider(String topologyName, String role) {
        ImpersonationProvider impersonationProvider;
        refreshSuperUserGroupsLock.lock();
        try {
            impersonationProvider = (ImpersonationProvider)TOPOLOGY_IMPERSONATION_PROVIDERS.getOrDefault(topologyName, Collections.emptyMap()).get(role);
        }
        finally {
            refreshSuperUserGroupsLock.unlock();
        }
        return impersonationProvider;
    }

    private static UserGroupInformation getRemoteRequestUgi(String remoteUser, String doAsUser) {
        if (remoteUser != null) {
            UserGroupInformation remoteUserUgi = UserGroupInformation.createRemoteUser((String)remoteUser);
            return UserGroupInformation.createProxyUser((String)doAsUser, (UserGroupInformation)remoteUserUgi);
        }
        return null;
    }

    public static boolean hasProxyConfig(String topologyName, String role) {
        return AuthFilterUtils.getImpersonationProvider(topologyName, role) != null;
    }

    public static void removeProxyUserConfig(String topologyName, String role) {
        if (AuthFilterUtils.hasProxyConfig(topologyName, role)) {
            refreshSuperUserGroupsLock.lock();
            try {
                TOPOLOGY_IMPERSONATION_PROVIDERS.get(topologyName).remove(role);
            }
            finally {
                refreshSuperUserGroupsLock.unlock();
            }
        }
    }

    public static List<String> getInitParameterNamesAsList(FilterConfig filterConfig) {
        return filterConfig.getInitParameterNames() == null ? Collections.emptyList() : Collections.list(filterConfig.getInitParameterNames());
    }

    public static void markDoGlobalLogoutInRequest(HttpServletRequest request) {
        request.setAttribute(DO_GLOBAL_LOGOUT_ATTRIBUTE, (Object)"true");
    }

    public static boolean shouldDoGlobalLogout(HttpServletRequest request) {
        return request.getAttribute(DO_GLOBAL_LOGOUT_ATTRIBUTE) == null ? false : Boolean.parseBoolean((String)request.getAttribute(DO_GLOBAL_LOGOUT_ATTRIBUTE));
    }
}

