// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: src/java/org/apache/lucene/analysis/standard/StandardTokenizerImpl.jflex

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.analysis.standard;

import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

/**
 * This class implements Word Break rules from the Unicode Text Segmentation 
 * algorithm, as specified in 
 * <a href="http://unicode.org/reports/tr29/">Unicode Standard Annex #29</a>. 
 * <p>
 * Tokens produced are of the following types:
 * <ul>
 *   <li>&lt;ALPHANUM&gt;: A sequence of alphabetic and numeric characters</li>
 *   <li>&lt;NUM&gt;: A number</li>
 *   <li>&lt;SOUTHEAST_ASIAN&gt;: A sequence of characters from South and Southeast
 *       Asian languages, including Thai, Lao, Myanmar, and Khmer</li>
 *   <li>&lt;IDEOGRAPHIC&gt;: A single CJKV ideographic character</li>
 *   <li>&lt;HIRAGANA&gt;: A single hiragana character</li>
 *   <li>&lt;KATAKANA&gt;: A sequence of katakana characters</li>
 *   <li>&lt;HANGUL&gt;: A sequence of Hangul characters</li>
 *   <li>&lt;EMOJI&gt;: A sequence of Emoji characters</li>
 * </ul>
 */

// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings({"fallthrough","unused"})
public final class StandardTokenizerImpl {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private int ZZ_BUFFERSIZE = 255;

  /** Lexical States. */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u1100\1\u1200\1\u1300\1\u1400\1\u0100\1\u1500\1\u1600"+
    "\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u1c00\1\u0100\1\u1d00"+
    "\1\u1e00\1\u1f00\1\u2000\1\u2100\1\u2200\1\u2300\1\u2400\1\u2500"+
    "\1\u2000\1\u2600\1\u2000\1\u2700\1\u2800\1\u2900\1\u2a00\1\u2b00"+
    "\1\u2c00\1\u2d00\1\u2e00\1\u2f00\31\u3000\1\u3100\121\u3000\1\u3200"+
    "\4\u0100\1\u3300\1\u0100\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800"+
    "\1\u3900\53\u1100\1\u3a00\41\u2000\1\u3000\1\u3b00\1\u3c00\1\u0100"+
    "\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u4100\1\u4200\1\u4300\1\u4400"+
    "\1\u4500\1\u0100\1\u4600\1\u4700\1\u4800\1\u4900\1\u4a00\1\u4b00"+
    "\1\u4c00\1\u2000\1\u4d00\1\u4e00\1\u4f00\1\u5000\1\u5100\1\u5200"+
    "\1\u5300\1\u5400\1\u5500\1\u5600\1\u5700\1\u5800\1\u2000\1\u5900"+
    "\1\u5a00\1\u5b00\1\u2000\3\u0100\1\u5c00\1\u5d00\1\u5e00\12\u2000"+
    "\4\u0100\1\u5f00\17\u2000\2\u0100\1\u6000\41\u2000\2\u0100\1\u6100"+
    "\1\u6200\2\u2000\1\u6300\1\u6400\100\u2000\1\u6500\1\u6600\12\u2000"+
    "\1\u6700\24\u2000\1\u6800\1\u6900\1\u2000\1\u6a00\1\u6b00\1\u6c00"+
    "\1\u6d00\2\u2000\1\u6e00\5\u2000\1\u6f00\1\u7000\1\u7100\5\u2000"+
    "\1\u7200\1\u7300\4\u2000\1\u7400\1\u2000\1\u7500\1\u7600\1\u7700"+
    "\1\u7800\1\u7900\1\u7a00\1\u7b00\1\u7c00\1\u7d00\1\u7e00\1\u7f00"+
    "\4\u8000\1\u8100\246\u3000\1\u8200\20\u3000\1\u8300\1\u8400\25\u3000"+
    "\1\u8500\34\u3000\1\u8600\14\u2000\2\u3000\1\u8700\u0b05\u2000\1\u8800"+
    "\1\u8900\u02fe\u2000";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\42\0\1\1\1\2\3\0\1\3\2\0\1\2\1\0"+
    "\1\4\1\0\1\5\1\0\12\6\1\7\1\4\5\0"+
    "\32\10\4\0\1\11\1\0\32\10\56\0\1\12\1\10"+
    "\2\0\1\13\1\12\6\0\1\10\1\0\1\7\2\0"+
    "\1\10\5\0\27\10\1\0\37\10\1\0\u01e0\10\6\0"+
    "\7\10\7\0\24\10\160\13\5\10\1\0\2\10\2\0"+
    "\4\10\1\4\1\10\6\0\1\10\1\7\3\10\1\0"+
    "\1\10\1\0\24\10\1\0\123\10\1\0\213\10\1\0"+
    "\7\13\246\10\1\0\46\10\2\0\1\10\1\0\2\10"+
    "\1\0\1\10\1\0\51\10\1\4\7\0\55\13\1\0"+
    "\1\13\1\0\2\13\1\0\2\13\1\0\1\13\10\0"+
    "\33\14\4\0\4\14\1\10\1\7\13\0\6\13\6\0"+
    "\2\4\2\0\13\13\1\0\1\13\3\0\53\10\25\13"+
    "\12\15\1\0\1\15\1\4\1\0\2\10\1\13\143\10"+
    "\1\0\1\10\10\13\1\0\6\13\2\10\2\13\1\0"+
    "\4\13\2\10\12\15\3\10\2\0\1\10\17\0\1\13"+
    "\1\10\1\13\36\10\33\13\2\0\131\10\13\13\1\10"+
    "\16\0\12\15\41\10\11\13\2\10\2\0\1\4\1\0"+
    "\1\10\2\0\1\13\2\0\26\10\4\13\1\10\11\13"+
    "\1\10\3\13\1\10\5\13\22\0\31\10\3\13\4\0"+
    "\13\10\65\0\25\10\1\0\10\10\25\0\61\13\66\10"+
    "\3\13\1\10\22\13\1\10\7\13\12\10\2\13\2\0"+
    "\12\15\1\0\20\10\3\13\1\0\10\10\2\0\2\10"+
    "\2\0\26\10\1\0\7\10\1\0\1\10\3\0\4\10"+
    "\2\0\1\13\1\10\7\13\2\0\2\13\2\0\3\13"+
    "\1\10\10\0\1\13\4\0\2\10\1\0\3\10\2\13"+
    "\2\0\12\15\2\10\12\0\1\10\1\0\1\13\2\0"+
    "\3\13\1\0\6\10\4\0\2\10\2\0\26\10\1\0"+
    "\7\10\1\0\2\10\1\0\2\10\1\0\2\10\2\0"+
    "\1\13\1\0\5\13\4\0\2\13\2\0\3\13\3\0"+
    "\1\13\7\0\4\10\1\0\1\10\7\0\12\15\2\13"+
    "\3\10\1\13\13\0\3\13\1\0\11\10\1\0\3\10"+
    "\1\0\26\10\1\0\7\10\1\0\2\10\1\0\5\10"+
    "\2\0\1\13\1\10\10\13\1\0\3\13\1\0\3\13"+
    "\2\0\1\10\17\0\2\10\2\13\2\0\12\15\11\0"+
    "\1\10\6\13\1\0\3\13\1\0\10\10\2\0\2\10"+
    "\2\0\26\10\1\0\7\10\1\0\2\10\1\0\5\10"+
    "\2\0\1\13\1\10\7\13\2\0\2\13\2\0\3\13"+
    "\10\0\2\13\4\0\2\10\1\0\3\10\2\13\2\0"+
    "\12\15\1\0\1\10\20\0\1\13\1\10\1\0\6\10"+
    "\3\0\3\10\1\0\4\10\3\0\2\10\1\0\1\10"+
    "\1\0\2\10\3\0\2\10\3\0\3\10\3\0\14\10"+
    "\4\0\5\13\3\0\3\13\1\0\4\13\2\0\1\10"+
    "\6\0\1\13\16\0\12\15\20\0\5\13\10\10\1\0"+
    "\3\10\1\0\27\10\1\0\20\10\3\0\1\10\7\13"+
    "\1\0\3\13\1\0\4\13\7\0\2\13\1\0\3\10"+
    "\5\0\2\10\2\13\2\0\12\15\20\0\1\10\3\13"+
    "\1\0\10\10\1\0\3\10\1\0\27\10\1\0\12\10"+
    "\1\0\5\10\2\0\1\13\1\10\7\13\1\0\3\13"+
    "\1\0\4\13\7\0\2\13\7\0\1\10\1\0\2\10"+
    "\2\13\2\0\12\15\1\0\2\10\15\0\4\13\1\0"+
    "\10\10\1\0\3\10\1\0\51\10\2\13\1\10\7\13"+
    "\1\0\3\13\1\0\4\13\1\10\5\0\3\10\1\13"+
    "\7\0\3\10\2\13\2\0\12\15\12\0\6\10\2\0"+
    "\2\13\1\0\22\10\3\0\30\10\1\0\11\10\1\0"+
    "\1\10\2\0\7\10\3\0\1\13\4\0\6\13\1\0"+
    "\1\13\1\0\10\13\6\0\12\15\2\0\2\13\15\0"+
    "\60\16\1\17\2\16\7\17\5\0\7\16\10\17\1\0"+
    "\12\15\47\0\2\16\1\0\1\16\1\0\5\16\1\0"+
    "\30\16\1\0\1\16\1\0\12\16\1\17\2\16\11\17"+
    "\1\16\2\0\5\16\1\0\1\16\1\0\6\17\2\0"+
    "\12\15\2\0\4\16\40\0\1\10\27\0\2\13\6\0"+
    "\12\15\13\0\1\13\1\0\1\13\1\0\1\13\4\0"+
    "\2\13\10\10\1\0\44\10\4\0\24\13\1\0\2\13"+
    "\5\10\13\13\1\0\44\13\11\0\1\13\71\0\53\16"+
    "\24\17\1\16\12\15\6\0\6\16\4\17\4\16\3\17"+
    "\1\16\3\17\2\16\7\17\3\16\4\17\15\16\14\17"+
    "\1\16\1\17\12\15\4\17\2\16\46\10\1\0\1\10"+
    "\5\0\1\10\2\0\53\10\1\0\4\10\u0100\20\111\10"+
    "\1\0\4\10\2\0\7\10\1\0\1\10\1\0\4\10"+
    "\2\0\51\10\1\0\4\10\2\0\41\10\1\0\4\10"+
    "\2\0\7\10\1\0\1\10\1\0\4\10\2\0\17\10"+
    "\1\0\71\10\1\0\4\10\2\0\103\10\2\0\3\13"+
    "\40\0\20\10\20\0\126\10\2\0\6\10\3\0\u016c\10"+
    "\2\0\21\10\1\0\32\10\5\0\113\10\3\0\13\10"+
    "\7\0\15\10\1\0\4\10\3\13\13\0\22\10\3\13"+
    "\13\0\22\10\2\13\14\0\15\10\1\0\3\10\1\0"+
    "\2\13\14\0\64\16\40\17\3\0\1\16\4\0\1\16"+
    "\1\17\2\0\12\15\41\0\4\13\1\0\12\15\6\0"+
    "\131\10\7\0\5\10\2\13\42\10\1\13\1\10\5\0"+
    "\106\10\12\0\37\10\1\0\14\13\4\0\14\13\12\0"+
    "\12\15\36\16\2\0\5\16\13\0\54\16\4\0\32\16"+
    "\6\0\12\15\1\16\3\0\2\16\40\0\27\10\5\13"+
    "\4\0\65\16\12\17\1\0\35\17\2\0\1\13\12\15"+
    "\6\0\12\15\6\0\16\16\2\0\17\13\101\0\5\13"+
    "\57\10\21\13\7\10\4\0\12\15\21\0\11\13\14\0"+
    "\3\13\36\10\15\13\2\10\12\15\54\10\16\13\14\0"+
    "\44\10\24\13\10\0\12\15\3\0\3\10\12\15\44\10"+
    "\2\0\11\10\7\0\53\10\2\0\3\10\20\0\3\13"+
    "\1\0\25\13\4\10\1\13\6\10\1\13\2\10\3\13"+
    "\1\10\5\0\300\10\72\13\1\0\5\13\26\10\2\0"+
    "\6\10\2\0\46\10\2\0\6\10\2\0\10\10\1\0"+
    "\1\10\1\0\1\10\1\0\1\10\1\0\37\10\2\0"+
    "\65\10\1\0\7\10\1\0\1\10\3\0\3\10\1\0"+
    "\7\10\3\0\4\10\2\0\6\10\4\0\15\10\5\0"+
    "\3\10\1\0\7\10\17\0\1\13\1\21\2\13\10\0"+
    "\2\5\12\0\1\5\2\0\1\7\2\0\5\13\1\11"+
    "\14\0\1\12\2\0\2\11\3\0\1\4\4\0\1\12"+
    "\12\0\1\11\13\0\5\13\1\0\12\13\1\0\1\10"+
    "\15\0\1\10\20\0\15\10\63\0\23\13\1\22\15\13"+
    "\21\0\1\10\4\0\1\10\2\0\12\10\1\0\1\10"+
    "\3\0\5\10\4\0\1\12\1\0\1\10\1\0\1\10"+
    "\1\0\1\10\1\0\4\10\1\0\12\10\1\23\2\0"+
    "\4\10\5\0\5\10\4\0\1\10\21\0\51\10\13\0"+
    "\6\12\17\0\2\12\u016f\0\2\12\14\0\1\12\137\0"+
    "\1\12\106\0\1\12\31\0\13\12\4\0\3\12\273\0"+
    "\14\10\1\23\47\10\300\0\2\12\12\0\1\12\11\0"+
    "\1\12\72\0\4\12\1\0\6\12\1\0\14\12\1\0"+
    "\162\12\12\0\166\12\2\0\13\12\1\0\1\12\1\0"+
    "\1\12\6\0\1\12\3\0\1\12\6\0\1\12\12\0"+
    "\2\12\17\0\1\12\2\0\1\12\4\0\1\12\1\0"+
    "\1\12\4\0\3\12\1\0\1\12\13\0\5\12\55\0"+
    "\3\12\11\0\1\12\16\0\1\12\16\0\1\12\164\0"+
    "\2\12\317\0\3\12\23\0\2\12\63\0\1\12\4\0"+
    "\1\12\252\0\57\10\1\0\57\10\1\0\205\10\6\0"+
    "\4\10\3\13\2\10\14\0\46\10\1\0\1\10\5\0"+
    "\1\10\2\0\70\10\7\0\1\10\17\0\1\13\27\10"+
    "\11\0\7\10\1\0\7\10\1\0\7\10\1\0\7\10"+
    "\1\0\7\10\1\0\7\10\1\0\7\10\1\0\7\10"+
    "\1\0\40\13\57\0\1\10\120\0\32\24\1\0\131\24"+
    "\14\0\326\24\57\0\1\10\1\0\1\24\31\0\11\24"+
    "\6\13\1\12\5\25\2\0\3\24\2\10\1\12\3\0"+
    "\126\26\2\0\2\13\2\25\3\26\133\25\1\0\4\25"+
    "\5\0\53\10\1\0\136\20\21\0\33\10\65\0\20\25"+
    "\227\0\1\12\1\0\1\12\66\0\57\25\1\0\130\25"+
    "\250\0\u01b6\24\112\0\360\24\20\0\215\10\103\0\56\10"+
    "\2\0\15\10\3\0\20\10\12\15\2\10\24\0\57\10"+
    "\4\13\1\0\12\13\1\0\37\10\2\13\120\10\2\13"+
    "\45\0\251\10\2\0\5\10\60\0\13\10\1\13\3\10"+
    "\1\13\4\10\1\13\27\10\5\13\30\0\64\10\14\0"+
    "\2\13\62\10\22\13\12\0\12\15\6\0\22\13\6\10"+
    "\3\0\1\10\1\0\2\10\1\13\12\15\34\10\10\13"+
    "\2\0\27\10\15\13\14\0\35\20\3\0\4\13\57\10"+
    "\16\13\16\0\1\10\12\15\6\0\5\16\1\17\12\16"+
    "\12\15\5\16\1\0\51\10\16\13\11\0\3\10\1\13"+
    "\10\10\2\13\2\0\12\15\6\0\33\16\3\17\62\16"+
    "\1\17\1\16\3\17\2\16\2\17\5\16\2\17\1\16"+
    "\1\17\1\16\30\0\5\16\13\10\5\13\2\0\3\10"+
    "\2\13\12\0\6\10\2\0\6\10\2\0\6\10\11\0"+
    "\7\10\1\0\7\10\1\0\70\10\10\0\163\10\10\13"+
    "\1\0\2\13\2\0\12\15\6\0\244\20\14\0\27\20"+
    "\4\0\61\20\4\0\156\24\2\0\152\24\46\0\7\10"+
    "\14\0\5\10\5\0\1\14\1\13\12\14\1\0\15\14"+
    "\1\0\5\14\1\0\1\14\1\0\2\14\1\0\2\14"+
    "\1\0\12\14\142\10\41\0\153\10\22\0\100\10\2\0"+
    "\66\10\50\0\14\10\4\0\16\13\1\27\1\30\1\4"+
    "\2\0\1\7\1\4\13\0\20\13\3\0\2\11\30\0"+
    "\3\11\1\4\1\0\1\5\1\0\1\4\1\7\32\0"+
    "\5\10\1\0\207\10\2\0\1\13\7\0\1\5\4\0"+
    "\1\4\1\0\1\5\1\0\12\15\1\7\1\4\5\0"+
    "\32\10\4\0\1\11\1\0\32\10\13\0\70\25\2\13"+
    "\37\20\3\0\6\20\2\0\6\20\2\0\6\20\2\0"+
    "\3\20\34\0\3\13\4\0\14\10\1\0\32\10\1\0"+
    "\23\10\1\0\2\10\1\0\17\10\2\0\16\10\42\0"+
    "\173\10\105\0\65\10\210\0\1\13\202\0\35\10\3\0"+
    "\61\10\17\0\1\13\37\0\40\10\15\0\36\10\5\0"+
    "\46\10\5\13\5\0\36\10\2\0\44\10\4\0\10\10"+
    "\1\0\5\10\52\0\236\10\2\0\12\15\6\0\44\10"+
    "\4\0\44\10\4\0\50\10\10\0\64\10\234\0\67\10"+
    "\11\0\26\10\12\0\10\10\230\0\6\10\2\0\1\10"+
    "\1\0\54\10\1\0\2\10\3\0\1\10\2\0\27\10"+
    "\12\0\27\10\11\0\37\10\101\0\23\10\1\0\2\10"+
    "\12\0\26\10\12\0\32\10\106\0\70\10\6\0\2\10"+
    "\100\0\1\10\3\13\1\0\2\13\5\0\4\13\4\10"+
    "\1\0\3\10\1\0\35\10\2\0\3\13\4\0\1\13"+
    "\40\0\35\10\3\0\35\10\43\0\10\10\1\0\34\10"+
    "\2\13\31\0\66\10\12\0\26\10\12\0\23\10\15\0"+
    "\22\10\156\0\111\10\67\0\63\10\15\0\63\10\15\0"+
    "\44\10\4\13\10\0\12\15\306\0\35\10\12\0\1\10"+
    "\10\0\26\10\13\13\217\0\27\10\11\0\3\13\65\10"+
    "\17\13\37\0\12\15\17\0\4\13\55\10\13\13\2\0"+
    "\1\13\17\0\1\13\2\0\31\10\7\0\12\15\6\0"+
    "\3\13\44\10\16\13\1\0\12\15\4\0\1\10\2\13"+
    "\11\0\43\10\1\13\2\0\1\10\11\0\3\13\60\10"+
    "\16\13\4\10\4\0\4\13\3\0\12\15\1\10\1\0"+
    "\1\10\43\0\22\10\1\0\31\10\14\13\6\0\1\13"+
    "\101\0\7\10\1\0\1\10\1\0\4\10\1\0\17\10"+
    "\1\0\12\10\7\0\57\10\14\13\5\0\12\15\6\0"+
    "\4\13\1\0\10\10\2\0\2\10\2\0\26\10\1\0"+
    "\7\10\1\0\2\10\1\0\5\10\1\0\2\13\1\10"+
    "\7\13\2\0\2\13\2\0\3\13\2\0\1\10\6\0"+
    "\1\13\5\0\5\10\2\13\2\0\7\13\3\0\5\13"+
    "\213\0\65\10\22\13\4\10\5\0\12\15\4\0\1\13"+
    "\1\10\40\0\60\10\24\13\2\10\1\0\1\10\10\0"+
    "\12\15\246\0\57\10\7\13\2\0\11\13\27\0\4\10"+
    "\2\13\42\0\60\10\21\13\3\0\1\10\13\0\12\15"+
    "\46\0\53\10\15\13\1\10\7\0\12\15\66\0\33\16"+
    "\2\0\17\17\4\0\12\15\2\16\3\0\1\16\300\0"+
    "\54\10\17\13\145\0\100\10\12\15\25\0\1\10\240\0"+
    "\10\10\2\0\47\10\7\13\2\0\7\13\1\10\1\0"+
    "\1\10\1\13\33\0\1\10\12\13\50\10\7\13\1\10"+
    "\4\13\10\0\1\13\10\0\1\10\13\13\56\10\20\13"+
    "\3\0\1\10\42\0\71\10\7\0\11\10\1\0\45\10"+
    "\10\13\1\0\10\13\1\10\17\0\12\15\30\0\36\10"+
    "\2\0\26\13\1\0\16\13\111\0\7\10\1\0\2\10"+
    "\1\0\46\10\6\13\3\0\1\13\1\0\2\13\1\0"+
    "\7\13\1\10\1\13\10\0\12\15\6\0\6\10\1\0"+
    "\2\10\1\0\40\10\5\13\1\0\2\13\1\0\5\13"+
    "\1\10\7\0\12\15\u0136\0\23\10\4\13\11\0\232\10"+
    "\146\0\157\10\21\0\304\10\274\0\57\10\1\0\11\13"+
    "\307\0\107\10\271\0\71\10\7\0\37\10\1\0\12\15"+
    "\146\0\36\10\2\0\5\13\13\0\60\10\7\13\11\0"+
    "\4\10\14\0\12\15\11\0\25\10\5\0\23\10\260\0"+
    "\100\10\200\0\113\10\4\0\1\13\1\10\67\13\7\0"+
    "\4\13\15\10\100\0\2\10\1\0\1\10\34\0\1\25"+
    "\u011e\26\61\0\3\26\21\0\4\25\230\0\153\10\5\0"+
    "\15\10\3\0\11\10\7\0\12\10\3\0\2\13\1\0"+
    "\4\13\301\0\5\13\3\0\26\13\2\0\7\13\36\0"+
    "\4\13\224\0\3\13\273\0\125\10\1\0\107\10\1\0"+
    "\2\10\2\0\1\10\2\0\2\10\2\0\4\10\1\0"+
    "\14\10\1\0\1\10\1\0\7\10\1\0\101\10\1\0"+
    "\4\10\2\0\10\10\1\0\7\10\1\0\34\10\1\0"+
    "\4\10\1\0\5\10\1\0\1\10\3\0\7\10\1\0"+
    "\u0154\10\2\0\31\10\1\0\31\10\1\0\37\10\1\0"+
    "\31\10\1\0\37\10\1\0\31\10\1\0\37\10\1\0"+
    "\31\10\1\0\37\10\1\0\31\10\1\0\10\10\2\0"+
    "\62\15\67\13\4\0\62\13\10\0\1\13\16\0\1\13"+
    "\26\0\5\13\1\0\17\13\120\0\7\13\1\0\21\13"+
    "\2\0\7\13\1\0\2\13\1\0\5\13\325\0\55\10"+
    "\3\0\7\13\7\10\2\0\12\15\4\0\1\10\u0171\0"+
    "\54\10\4\13\12\15\6\0\305\10\13\0\7\13\51\0"+
    "\104\10\7\13\1\10\4\0\12\15\246\0\4\10\1\0"+
    "\33\10\1\0\2\10\1\0\1\10\2\0\1\10\1\0"+
    "\12\10\1\0\4\10\1\0\1\10\1\0\1\10\6\0"+
    "\1\10\4\0\1\10\1\0\1\10\1\0\1\10\1\0"+
    "\3\10\1\0\2\10\1\0\1\10\2\0\1\10\1\0"+
    "\1\10\1\0\1\10\1\0\1\10\1\0\1\10\1\0"+
    "\2\10\1\0\1\10\2\0\4\10\1\0\7\10\1\0"+
    "\4\10\1\0\4\10\1\0\1\10\1\0\12\10\1\0"+
    "\21\10\5\0\3\10\1\0\5\10\1\0\21\10\104\0"+
    "\u0100\12\15\0\3\12\37\0\1\12\32\10\6\0\32\10"+
    "\2\0\4\12\2\23\14\10\2\23\12\10\4\0\1\12"+
    "\2\0\12\12\22\0\71\12\32\31\1\26\17\12\12\0"+
    "\1\12\24\0\1\12\2\0\11\12\1\0\4\12\11\0"+
    "\u01b2\12\5\32\u013e\12\10\0\u010a\12\60\0\200\12\164\0"+
    "\14\12\125\0\53\12\14\0\4\12\70\0\10\12\12\0"+
    "\6\12\50\0\10\12\36\0\122\12\14\0\57\12\1\0"+
    "\12\12\1\0\u03b7\12\2\0\327\24\51\0\65\24\13\0"+
    "\336\24\2\0\u0182\24\16\0\u0131\24\37\0\36\24\343\0"+
    "\1\13\36\0\137\33\1\34\200\0\360\13\20\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[35328];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\2\1\1\2\1\3\1\1\1\4\1\3\1\2"+
    "\1\5\1\6\1\1\1\4\1\7\1\10\1\11\1\1"+
    "\1\4\1\0\1\4\2\0\1\2\1\4\1\2\1\0"+
    "\2\3\1\0\1\3\2\4\1\0\1\3\1\0\2\4"+
    "\1\0\4\4\1\0\1\4\2\0\1\4\2\3\2\4"+
    "\1\0\3\4\1\3\3\4";

  private static int [] zzUnpackAction() {
    int [] result = new int[59];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\35\0\72\0\127\0\164\0\221\0\256\0\313"+
    "\0\350\0\u0105\0\u0122\0\u013f\0\u015c\0\u0179\0\u0196\0\u01b3"+
    "\0\u01d0\0\u01ed\0\72\0\u020a\0\u0227\0\u0244\0\u0261\0\u027e"+
    "\0\u029b\0\u02b8\0\u02d5\0\u02f2\0\221\0\u030f\0\u032c\0\u0349"+
    "\0\u0366\0\u0383\0\u013f\0\u03a0\0\u03bd\0\u01d0\0\u03da\0\u03f7"+
    "\0\u0414\0\u0431\0\u044e\0\u046b\0\u0488\0\u04a5\0\u04c2\0\u04df"+
    "\0\u04fc\0\u0519\0\u0536\0\u0553\0\35\0\u0570\0\u058d\0\u05aa"+
    "\0\u05c7\0\164\0\u05e4";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[59];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\2\1\3\3\2\1\4\1\2\1\5\1\6\1\7"+
    "\1\2\1\10\1\11\2\12\1\13\1\14\1\2\1\15"+
    "\1\16\1\17\1\20\2\2\1\21\1\22\2\2\50\0"+
    "\1\23\3\0\1\23\1\0\1\23\1\24\5\0\1\25"+
    "\1\0\3\23\3\0\3\26\1\11\1\0\1\5\1\27"+
    "\1\0\1\4\1\10\1\11\1\0\1\4\1\5\1\4"+
    "\1\30\1\5\3\0\1\11\1\31\1\0\3\4\3\0"+
    "\1\32\1\0\1\32\1\33\1\32\1\5\1\34\1\0"+
    "\1\5\1\10\1\33\1\0\5\5\3\0\2\5\1\0"+
    "\3\5\6\0\1\11\1\0\1\5\1\35\1\0\1\35"+
    "\1\10\1\11\1\0\1\35\1\5\2\35\1\5\1\0"+
    "\1\36\1\0\2\35\1\0\3\35\13\0\1\7\3\0"+
    "\1\7\1\0\1\37\1\7\5\0\1\40\1\0\3\7"+
    "\1\0\1\41\1\0\1\42\1\0\1\32\1\33\1\32"+
    "\1\5\1\34\1\0\2\10\1\33\1\0\1\10\1\5"+
    "\2\10\1\5\3\0\2\10\1\0\3\10\3\0\3\26"+
    "\1\11\1\0\1\5\1\27\1\0\1\11\1\10\1\11"+
    "\1\0\1\11\1\5\2\11\1\5\3\0\2\11\1\0"+
    "\3\11\13\0\1\12\2\0\2\12\1\0\2\12\4\0"+
    "\2\12\1\0\3\12\3\0\1\32\1\0\1\32\1\33"+
    "\1\32\1\5\1\34\1\0\1\13\1\10\1\33\1\0"+
    "\4\13\1\5\3\0\2\13\1\0\3\13\12\0\1\7"+
    "\6\0\1\43\1\0\1\7\14\0\1\32\1\0\1\32"+
    "\1\33\1\32\1\5\1\34\1\0\1\15\1\10\1\33"+
    "\1\0\1\15\1\5\1\44\1\15\1\5\3\0\1\5"+
    "\1\45\1\0\3\15\13\0\1\16\3\0\1\16\1\0"+
    "\2\16\4\0\2\16\1\0\3\16\11\0\1\34\1\0"+
    "\1\17\3\0\1\17\1\0\2\17\2\0\1\17\1\0"+
    "\2\17\1\0\3\17\13\0\1\20\3\0\1\20\1\0"+
    "\2\20\4\0\2\20\1\0\3\20\13\0\1\46\3\0"+
    "\1\46\1\0\2\46\4\0\2\46\1\47\3\46\13\0"+
    "\1\22\3\0\1\22\1\0\1\50\1\22\7\0\3\22"+
    "\13\0\1\24\3\0\1\24\1\0\2\24\5\0\1\25"+
    "\1\0\3\24\22\0\1\51\20\0\1\11\4\0\1\26"+
    "\1\0\1\11\1\0\1\26\1\0\2\26\4\0\2\26"+
    "\1\0\3\26\6\0\1\11\1\0\1\5\1\27\1\0"+
    "\1\27\1\10\1\11\1\0\1\27\1\5\2\27\1\5"+
    "\1\0\1\36\1\0\2\27\1\0\3\27\3\0\3\26"+
    "\1\11\1\0\1\5\1\27\1\0\1\30\1\10\1\11"+
    "\1\0\1\30\1\5\2\30\1\5\3\0\1\11\1\31"+
    "\1\0\3\30\3\0\3\26\1\11\1\0\1\5\1\27"+
    "\1\0\1\11\1\10\1\11\1\0\1\11\1\5\1\11"+
    "\1\52\1\5\3\0\2\11\1\0\3\11\10\0\1\5"+
    "\2\0\1\32\1\5\2\0\1\32\1\5\2\32\1\5"+
    "\3\0\2\32\1\0\3\32\3\0\3\53\1\33\1\0"+
    "\1\5\1\34\1\0\1\33\1\10\1\33\1\0\1\33"+
    "\1\5\2\33\1\5\3\0\2\33\1\0\3\33\6\0"+
    "\1\33\1\0\1\5\1\34\1\0\1\34\1\10\1\33"+
    "\1\0\1\34\1\5\2\34\1\5\1\0\1\36\1\0"+
    "\2\34\1\0\3\34\11\0\1\34\1\0\1\36\3\0"+
    "\1\36\1\0\2\36\2\0\1\36\1\0\2\36\1\0"+
    "\3\36\12\0\1\54\1\7\3\0\1\7\1\0\1\37"+
    "\1\7\1\54\4\0\1\40\1\0\3\7\21\0\1\55"+
    "\11\0\1\56\14\0\1\41\1\42\2\0\1\41\1\0"+
    "\2\41\4\0\2\41\1\0\3\41\6\0\1\33\1\0"+
    "\1\5\1\34\1\0\1\42\1\10\1\33\1\0\1\42"+
    "\1\5\2\42\1\5\3\0\2\42\1\0\3\42\3\0"+
    "\1\32\1\0\1\32\1\33\1\32\1\5\1\34\1\54"+
    "\1\15\1\10\1\33\1\0\1\15\1\5\1\44\1\15"+
    "\1\57\3\0\1\5\1\45\1\0\3\15\3\0\1\32"+
    "\1\0\1\32\1\33\1\32\1\5\1\34\1\0\1\5"+
    "\1\10\1\33\1\0\2\5\1\60\2\5\3\0\2\5"+
    "\1\0\1\5\1\61\1\5\13\0\1\47\3\0\1\47"+
    "\1\0\2\47\4\0\2\47\1\0\3\47\12\0\1\54"+
    "\1\22\3\0\1\22\1\0\1\50\1\22\1\54\6\0"+
    "\3\22\13\0\1\51\3\0\1\51\1\0\2\51\7\0"+
    "\3\51\3\0\3\26\1\11\1\0\1\5\1\27\1\0"+
    "\1\52\1\10\1\11\1\0\1\52\1\5\2\52\1\5"+
    "\3\0\2\11\1\0\3\52\6\0\1\33\4\0\1\53"+
    "\1\0\1\33\1\0\1\53\1\0\2\53\4\0\2\53"+
    "\1\0\3\53\13\0\1\54\3\0\1\54\1\0\1\62"+
    "\1\54\5\0\1\63\1\0\3\54\12\0\1\54\6\0"+
    "\1\64\1\0\1\54\6\0\1\22\35\0\1\56\1\65"+
    "\3\0\1\32\1\0\1\32\1\33\1\32\1\5\1\34"+
    "\1\0\1\57\1\10\1\33\1\0\1\57\1\5\1\66"+
    "\1\57\1\5\3\0\1\5\1\67\1\0\3\57\3\0"+
    "\1\32\1\0\1\32\1\33\1\32\1\5\1\34\1\54"+
    "\1\5\1\10\1\33\1\0\2\5\1\70\1\5\1\57"+
    "\3\0\2\5\1\0\1\71\2\5\3\0\1\32\1\0"+
    "\1\32\1\33\1\32\1\5\1\34\1\0\1\5\1\10"+
    "\1\33\1\0\5\5\3\0\2\5\1\0\1\5\1\61"+
    "\1\72\12\0\2\54\3\0\1\54\1\0\1\62\2\54"+
    "\4\0\1\63\1\0\3\54\21\0\1\55\25\0\1\54"+
    "\6\0\1\64\1\0\1\54\14\0\1\32\1\0\1\32"+
    "\1\33\1\32\1\5\1\34\1\54\1\57\1\10\1\33"+
    "\1\0\1\57\1\5\1\66\2\57\3\0\1\5\1\67"+
    "\1\0\3\57\3\0\1\32\1\0\1\32\1\33\1\32"+
    "\1\5\1\34\1\0\1\5\1\10\1\33\1\0\2\5"+
    "\1\60\2\5\3\0\2\5\1\0\3\5\3\0\1\32"+
    "\1\0\1\32\1\33\1\32\1\5\1\34\1\54\1\5"+
    "\1\10\1\33\1\0\2\5\1\70\1\5\1\57\3\0"+
    "\2\5\1\0\3\5\3\0\1\32\1\0\1\32\1\33"+
    "\1\32\1\5\1\34\1\0\1\71\1\10\1\33\1\0"+
    "\1\71\1\5\1\73\1\71\1\5\3\0\2\5\1\0"+
    "\3\71\3\0\1\32\1\0\1\32\1\33\1\32\1\5"+
    "\1\34\1\54\1\71\1\10\1\33\1\0\1\71\1\5"+
    "\1\73\1\71\1\57\3\0\2\5\1\0\3\71";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1537];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\20\1\1\0\1\1\2\0\3\1\1\0"+
    "\2\1\1\0\3\1\1\0\1\1\1\0\2\1\1\0"+
    "\4\1\1\0\1\1\2\0\5\1\1\0\1\11\6\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[59];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  /** Alphanumeric sequences */
  public static final int WORD_TYPE = StandardTokenizer.ALPHANUM;
  
  /** Numbers */
  public static final int NUMERIC_TYPE = StandardTokenizer.NUM;
  
  /**
   * Chars in class \p{Line_Break = Complex_Context} are from South East Asian
   * scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
   * together as as a single token rather than broken up, because the logic
   * required to break them at word boundaries is too complex for UAX#29.
   * <p>
   * See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
   */
  public static final int SOUTH_EAST_ASIAN_TYPE = StandardTokenizer.SOUTHEAST_ASIAN;
  
  /** Ideographic token type */
  public static final int IDEOGRAPHIC_TYPE = StandardTokenizer.IDEOGRAPHIC;
  
  /** Hiragana token type */
  public static final int HIRAGANA_TYPE = StandardTokenizer.HIRAGANA;
  
  /** Katakana token type */
  public static final int KATAKANA_TYPE = StandardTokenizer.KATAKANA;

  /** Hangul token type */
  public static final int HANGUL_TYPE = StandardTokenizer.HANGUL;
  
  /** Emoji token type */
  public static final int EMOJI_TYPE = StandardTokenizer.EMOJI;

  /** Character count processed so far */
  public final int yychar()
  {
    // jflex supports > 2GB docs but not lucene
    return (int) yychar;
  }

  /**
   * Fills CharTermAttribute with the current token text.
   */
  public final void getText(CharTermAttribute t) {
    t.copyBuffer(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }
  
  /**
   * Sets the scanner buffer size in chars
   */
   public final void setBufferSize(int numChars) {
     ZZ_BUFFERSIZE = numChars;
     char[] newZzBuffer = new char[ZZ_BUFFERSIZE];
     System.arraycopy(zzBuffer, 0, newZzBuffer, 0, Math.min(zzBuffer.length, ZZ_BUFFERSIZE));
     zzBuffer = newZzBuffer;
   }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public StandardTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead - zzFinalHighSurrogate;
    if (requested == 0) {
      return true;
    }
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
          if (numRead == 1) {
            return true;
          }
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return YYEOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { /* Break so we don't hit fall-through warning: */ break; /* Not numeric, word, ideographic, hiragana, emoji or SE Asian -- ignore it. */
            }
            // fall through
          case 10: break;
          case 2:
            { return NUMERIC_TYPE;
            }
            // fall through
          case 11: break;
          case 3:
            { return WORD_TYPE;
            }
            // fall through
          case 12: break;
          case 4:
            { return EMOJI_TYPE;
            }
            // fall through
          case 13: break;
          case 5:
            { return SOUTH_EAST_ASIAN_TYPE;
            }
            // fall through
          case 14: break;
          case 6:
            { return HANGUL_TYPE;
            }
            // fall through
          case 15: break;
          case 7:
            { return IDEOGRAPHIC_TYPE;
            }
            // fall through
          case 16: break;
          case 8:
            { return KATAKANA_TYPE;
            }
            // fall through
          case 17: break;
          case 9:
            { return HIRAGANA_TYPE;
            }
            // fall through
          case 18: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
