/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValues;

class ExpressionFunctionValues
extends DoubleValues {
    final Expression expression;
    final DoubleValues[] functionValues;
    double currentValue;
    int currentDoc = -1;
    boolean computed;

    ExpressionFunctionValues(Expression expression, DoubleValues[] functionValues) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (functionValues == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.functionValues = functionValues;
    }

    public boolean advanceExact(int doc) {
        if (this.currentDoc == doc) {
            return true;
        }
        this.currentDoc = doc;
        this.computed = false;
        return true;
    }

    public double doubleValue() throws IOException {
        if (!this.computed) {
            for (DoubleValues v : this.functionValues) {
                v.advanceExact(this.currentDoc);
            }
            this.currentValue = this.expression.evaluate(this.functionValues);
            this.computed = true;
        }
        return this.currentValue;
    }
}

