/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.IntersectBlockReader;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STBlockLine;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public class STIntersectBlockReader
extends IntersectBlockReader {
    protected final FieldInfos fieldInfos;

    public STIntersectBlockReader(CompiledAutomaton compiled, BytesRef startTerm, IndexDictionary.BrowserSupplier dictionaryBrowserSupplier, IndexInput blockInput, PostingsReaderBase postingsReader, FieldMetadata fieldMetadata, BlockDecoder blockDecoder, FieldInfos fieldInfos) throws IOException {
        super(compiled, startTerm, dictionaryBrowserSupplier, blockInput, postingsReader, fieldMetadata, blockDecoder);
        this.fieldInfos = fieldInfos;
    }

    @Override
    public BytesRef next() throws IOException {
        BytesRef next;
        do {
            if ((next = super.next()) != null) continue;
            return null;
        } while (!this.termOccursInField());
        return next;
    }

    private boolean termOccursInField() throws IOException {
        this.readTermStateIfNotRead();
        return this.termState != null;
    }

    @Override
    protected STBlockLine.Serializer createBlockLineSerializer() {
        return new STBlockLine.Serializer();
    }

    @Override
    protected BlockTermState readTermState() throws IOException {
        this.termStatesReadBuffer.setPosition(this.blockFirstLineStart + this.blockHeader.getTermStatesBaseOffset() + this.blockLine.getTermStateRelativeOffset());
        return ((STBlockLine.Serializer)this.blockLineReader).readTermStateForField(this.fieldMetadata.getFieldInfo().number, (DataInput)this.termStatesReadBuffer, this.termStateSerializer, this.blockHeader, this.fieldInfos, this.scratchTermState);
    }
}

