/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.analysis.Analysis;

public final class TokenAttributeDialogFactory
implements DialogOpener.DialogFactory {
    private static TokenAttributeDialogFactory instance;
    private final Preferences prefs;
    private final JTable attributesTable = new JTable();
    private JDialog dialog;
    private String term;
    private List<Analysis.TokenAttribute> attributes;

    public static synchronized TokenAttributeDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new TokenAttributeDialogFactory();
        }
        return instance;
    }

    private TokenAttributeDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public void setAttributes(List<Analysis.TokenAttribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel("All token attributes for:"));
        header.add(new JLabel(this.term));
        panel.add((Component)header, "First");
        List<TokenAttValue> attrValues = this.attributes.stream().flatMap(att -> att.getAttValues().entrySet().stream().map(e -> TokenAttValue.of(att.getAttClass(), (String)e.getKey(), (String)e.getValue()))).toList();
        TableUtils.setupTable(this.attributesTable, 0, new AttributeTableModel(attrValues), null, new int[0]);
        panel.add((Component)new JScrollPane(this.attributesTable), "Center");
        JPanel footer = new JPanel(new FlowLayout(4));
        footer.setOpaque(false);
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(okBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    static final class AttributeTableModel
    extends TableModelBase<Column> {
        AttributeTableModel(List<TokenAttValue> attrValues) {
            super(attrValues.size());
            for (int i = 0; i < attrValues.size(); ++i) {
                TokenAttValue attrValue = attrValues.get(i);
                this.data[i][Column.ATTR.getIndex()] = attrValue.getAttClass();
                this.data[i][Column.NAME.getIndex()] = attrValue.getName();
                this.data[i][Column.VALUE.getIndex()] = attrValue.getValue();
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            ATTR("Attribute", 0, String.class),
            NAME("Name", 1, String.class),
            VALUE("Value", 2, String.class);

            private final String colName;
            private final int index;
            private final Class<?> type;

            private Column(String colName, int index, Class<?> type) {
                this.colName = colName;
                this.index = index;
                this.type = type;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }
        }
    }

    static final class TokenAttValue {
        private String attClass;
        private String name;
        private String value;

        public static TokenAttValue of(String attClass, String name, String value) {
            TokenAttValue attValue = new TokenAttValue();
            attValue.attClass = attClass;
            attValue.name = name;
            attValue.value = value;
            return attValue;
        }

        private TokenAttValue() {
        }

        String getAttClass() {
            return this.attClass;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }
}

