/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.tests.mockfile.FilterFileSystemProvider;

public class ExtrasFS
extends FilterFileSystemProvider {
    private static final String EXTRA_FILE_NAME = "extra0";
    final boolean active;
    final boolean createDirectory;

    public ExtrasFS(FileSystem delegate, boolean active, boolean createDirectory) {
        super("extras://", delegate);
        this.active = active;
        this.createDirectory = createDirectory;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        super.createDirectory(dir, attrs);
        if (this.active) {
            try {
                Path target = dir.resolve(EXTRA_FILE_NAME);
                if (this.createDirectory) {
                    super.createDirectory(target, new FileAttribute[0]);
                } else {
                    Files.createFile(target, new FileAttribute[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isExtra(String fileName) {
        return fileName.equals(EXTRA_FILE_NAME);
    }
}

