/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.OutputStream;
import opennlp.tools.cmdline.FineGrainedReportListener;
import opennlp.tools.doccat.DoccatEvaluationMonitor;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.log.LogPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoccatFineGrainedReportListener
extends FineGrainedReportListener
implements DoccatEvaluationMonitor {
    private static final Logger logger = LoggerFactory.getLogger(DoccatFineGrainedReportListener.class);

    public DoccatFineGrainedReportListener() {
        this((OutputStream)new LogPrintStream(logger));
    }

    public DoccatFineGrainedReportListener(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void misclassified(DocumentSample reference, DocumentSample prediction) {
        this.statsAdd(reference, prediction);
    }

    @Override
    public void correctlyClassified(DocumentSample reference, DocumentSample prediction) {
        this.statsAdd(reference, prediction);
    }

    private void statsAdd(DocumentSample reference, DocumentSample prediction) {
        this.getStats().add(reference.getText(), reference.getCategory(), prediction.getCategory());
    }

    @Override
    public void writeReport() {
        this.printGeneralStatistics();
        this.printTagsErrorRank();
        this.printGeneralConfusionTable();
    }
}

