/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADNameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

@Internal
public class ADNameSampleStreamFactory<P>
extends LanguageSampleStreamFactory<NameSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "ad", new ADNameSampleStreamFactory<Parameters>(Parameters.class));
    }

    protected ADNameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new ADNameSampleStream(lineStream, params.getSplitHyphenatedTokens());
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData", description="data to be used, usually a file name.")
        public File getData();

        @ArgumentParser.ParameterDescription(valueName="split", description="if true all hyphenated tokens will be separated (default true)")
        @ArgumentParser.OptionalParameter(defaultValue="true")
        public Boolean getSplitHyphenatedTokens();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();
    }
}

