/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import opennlp.tools.ml.AbstractMLModelWriter;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PerceptronModelWriter
extends AbstractMLModelWriter {
    private static final Logger logger = LoggerFactory.getLogger(PerceptronModelWriter.class);

    public PerceptronModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.numOutcomes = model.getNumOutcomes();
        this.PARAMS = (Context[])data[0];
        Map pmap = (Map)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.PARAMS = new Context[pmap.size()];
        this.PRED_LABELS = new String[pmap.size()];
        int i = 0;
        for (Map.Entry pred : pmap.entrySet()) {
            this.PRED_LABELS[i] = (String)pred.getKey();
            this.PARAMS[i] = (Context)pred.getValue();
            ++i;
        }
    }

    @Override
    protected ComparablePredicate[] sortValues() {
        ComparablePredicate[] tmpPreds = new ComparablePredicate[this.PARAMS.length];
        int[] tmpOutcomes = new int[this.numOutcomes];
        double[] tmpParams = new double[this.numOutcomes];
        int numPreds = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int numParams = 0;
            double[] predParams = this.PARAMS[pid].getParameters();
            int[] outcomePattern = this.PARAMS[pid].getOutcomes();
            for (int pi = 0; pi < predParams.length; ++pi) {
                if (predParams[pi] == 0.0) continue;
                tmpOutcomes[numParams] = outcomePattern[pi];
                tmpParams[numParams] = predParams[pi];
                ++numParams;
            }
            int[] activeOutcomes = new int[numParams];
            double[] activeParams = new double[numParams];
            for (int pi = 0; pi < numParams; ++pi) {
                activeOutcomes[pi] = tmpOutcomes[pi];
                activeParams[pi] = tmpParams[pi];
            }
            if (numParams == 0) continue;
            tmpPreds[numPreds] = new ComparablePredicate(this.PRED_LABELS[pid], activeOutcomes, activeParams);
            ++numPreds;
        }
        logger.info("Compressed {} parameters to {}", (Object)this.PARAMS.length, (Object)numPreds);
        Object[] sortPreds = new ComparablePredicate[numPreds];
        System.arraycopy(tmpPreds, 0, sortPreds, 0, numPreds);
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    @Override
    public void persist() throws IOException {
        this.writeUTF("Perceptron");
        super.persist();
    }
}

