/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.lucene103.blocktree.CompressionAlgorithm;
import org.apache.lucene.codecs.lucene103.blocktree.SegmentTermsEnum;
import org.apache.lucene.codecs.lucene103.blocktree.TrieReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

final class SegmentTermsEnumFrame {
    final int ord;
    boolean hasTerms;
    boolean hasTermsOrig;
    boolean isFloor;
    TrieReader.Node node;
    long fp;
    long fpOrig;
    long fpEnd;
    long totalSuffixBytes;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] suffixLengthBytes;
    final ByteArrayDataInput suffixLengthsReader;
    byte[] statBytes = new byte[64];
    int statsSingletonRunLength = 0;
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    long rewindPos;
    long floorDataPos;
    IndexInput floorDataReader;
    int prefixLength;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    boolean allEqual;
    long lastSubFP;
    int nextFloorLabel;
    int numFollowFloorBlocks;
    int metaDataUpto;
    final BlockTermState state;
    byte[] bytes = new byte[32];
    final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    private final SegmentTermsEnum ste;
    private int startBytePos;
    private int suffixLength;
    private long subCode;
    CompressionAlgorithm compressionAlg = CompressionAlgorithm.NO_COMPRESSION;

    public SegmentTermsEnumFrame(SegmentTermsEnum ste, int ord) throws IOException {
        this.ste = ste;
        this.ord = ord;
        this.state = ste.fr.parent.postingsReader.newTermState();
        this.state.totalTermFreq = -1L;
        this.suffixLengthBytes = new byte[32];
        this.suffixLengthsReader = new ByteArrayDataInput();
    }

    public void setFloorData(IndexInput in) throws IOException {
        this.floorDataReader = in;
        this.rewindPos = in.getFilePointer();
        this.numFollowFloorBlocks = in.readVInt();
        this.nextFloorLabel = in.readByte() & 0xFF;
        this.floorDataPos = in.getFilePointer();
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.state.termBlockOrd;
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.node == null || this.isFloor) : "node=" + String.valueOf(this.node) + " isFloor=" + this.isFloor;
        this.fp = this.fpEnd;
        this.nextEnt = -1;
        this.loadBlock();
    }

    void prefetchBlock() throws IOException {
        if (this.nextEnt != -1) {
            return;
        }
        this.ste.initIndexInput();
        this.ste.in.prefetch(this.fp, 1L);
    }

    void loadBlock() throws IOException {
        this.ste.initIndexInput();
        if (this.nextEnt != -1) {
            return;
        }
        this.ste.in.seek(this.fp);
        int code = this.ste.in.readVInt();
        this.entCount = code >>> 1;
        assert (this.entCount > 0);
        boolean bl = this.isLastInFloor = (code & 1) != 0;
        assert (this.node == null || this.isLastInFloor || this.isFloor) : "fp=" + this.fp + " node=" + String.valueOf(this.node) + " isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
        long startSuffixFP = this.ste.in.getFilePointer();
        long codeL = this.ste.in.readVLong();
        this.isLeafBlock = (codeL & 4L) != 0L;
        int numSuffixBytes = (int)(codeL >>> 3);
        if (this.suffixBytes.length < numSuffixBytes) {
            this.suffixBytes = new byte[ArrayUtil.oversize(numSuffixBytes, 1)];
        }
        try {
            this.compressionAlg = CompressionAlgorithm.byCode((int)codeL & 3);
        }
        catch (IllegalArgumentException e) {
            throw new CorruptIndexException(e.getMessage(), this.ste.in, (Throwable)e);
        }
        this.compressionAlg.read(this.ste.in, this.suffixBytes, numSuffixBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numSuffixBytes);
        int numSuffixLengthBytes = this.ste.in.readVInt();
        boolean bl2 = this.allEqual = (numSuffixLengthBytes & 1) != 0;
        if (this.suffixLengthBytes.length < (numSuffixLengthBytes >>>= 1)) {
            this.suffixLengthBytes = new byte[ArrayUtil.oversize(numSuffixLengthBytes, 1)];
        }
        if (this.allEqual) {
            Arrays.fill(this.suffixLengthBytes, 0, numSuffixLengthBytes, this.ste.in.readByte());
        } else {
            this.ste.in.readBytes(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        }
        this.suffixLengthsReader.reset(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        this.totalSuffixBytes = this.ste.in.getFilePointer() - startSuffixFP;
        int numBytes = this.ste.in.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ste.in.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.statsSingletonRunLength = 0;
        this.metaDataUpto = 0;
        this.state.termBlockOrd = 0;
        this.nextEnt = 0;
        this.lastSubFP = -1L;
        numBytes = this.ste.in.readVInt();
        if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ste.in.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        this.fpEnd = this.ste.in.getFilePointer();
    }

    void rewind() throws IOException {
        this.fp = this.fpOrig;
        this.nextEnt = -1;
        this.hasTerms = this.hasTermsOrig;
        if (this.isFloor) {
            this.floorDataReader.seek(this.rewindPos);
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            assert (this.numFollowFloorBlocks > 0);
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
            this.floorDataPos = this.floorDataReader.getFilePointer();
        }
    }

    public boolean next() throws IOException {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffixLength = this.suffixLengthsReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.term.setLength(this.prefixLength + this.suffixLength);
        this.ste.term.grow(this.ste.term.length());
        this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefixLength, this.suffixLength);
        this.ste.termExists = true;
    }

    public boolean nextNonLeaf() throws IOException {
        while (this.nextEnt == this.entCount) {
            assert (this.node == null || this.isFloor && !this.isLastInFloor) : "isFloor=" + this.isFloor + " isLastInFloor=" + this.isLastInFloor;
            this.loadNextFloorBlock();
            if (!this.isLeafBlock) continue;
            this.nextLeaf();
            return false;
        }
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int code = this.suffixLengthsReader.readVInt();
        this.suffixLength = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.term.setLength(this.prefixLength + this.suffixLength);
        this.ste.term.grow(this.ste.term.length());
        this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefixLength, this.suffixLength);
        if ((code & 1) == 0) {
            this.ste.termExists = true;
            this.subCode = 0L;
            ++this.state.termBlockOrd;
            return false;
        }
        this.ste.termExists = false;
        this.subCode = this.suffixLengthsReader.readVLong();
        this.lastSubFP = this.fp - this.subCode;
        return true;
    }

    public void scanToFloorFrame(BytesRef target) throws IOException {
        if (!this.isFloor || target.length <= this.prefixLength) {
            return;
        }
        int targetLabel = target.bytes[target.offset + this.prefixLength] & 0xFF;
        if (targetLabel < this.nextFloorLabel) {
            return;
        }
        assert (this.numFollowFloorBlocks != 0);
        long newFP = this.fpOrig;
        this.floorDataReader.seek(this.floorDataPos);
        do {
            long code = this.floorDataReader.readVLong();
            newFP = this.fpOrig + (code >>> 1);
            this.hasTerms = (code & 1L) != 0L;
            this.isLastInFloor = this.numFollowFloorBlocks == 1;
            --this.numFollowFloorBlocks;
            if (this.isLastInFloor) {
                this.nextFloorLabel = 256;
                break;
            }
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
        } while (targetLabel >= this.nextFloorLabel);
        this.floorDataPos = this.floorDataReader.getFilePointer();
        if (newFP != this.fp) {
            this.nextEnt = -1;
            this.fp = newFP;
        }
    }

    public void decodeMetaData() throws IOException {
        boolean absolute;
        int limit = this.getTermBlockOrd();
        boolean bl = absolute = this.metaDataUpto == 0;
        assert (limit > 0);
        while (this.metaDataUpto < limit) {
            if (this.statsSingletonRunLength > 0) {
                this.state.docFreq = 1;
                this.state.totalTermFreq = 1L;
                --this.statsSingletonRunLength;
            } else {
                int token = this.statsReader.readVInt();
                if ((token & 1) == 1) {
                    this.state.docFreq = 1;
                    this.state.totalTermFreq = 1L;
                    this.statsSingletonRunLength = token >>> 1;
                } else {
                    this.state.docFreq = token >>> 1;
                    this.state.totalTermFreq = this.ste.fr.fieldInfo.getIndexOptions() == IndexOptions.DOCS ? (long)this.state.docFreq : (long)this.state.docFreq + this.statsReader.readVLong();
                }
            }
            this.ste.fr.parent.postingsReader.decodeTerm(this.bytesReader, this.ste.fr.fieldInfo, this.state, absolute);
            ++this.metaDataUpto;
            absolute = false;
        }
        this.state.termBlockOrd = this.metaDataUpto;
    }

    private boolean prefixMatches(BytesRef target) {
        for (int bytePos = 0; bytePos < this.prefixLength; ++bytePos) {
            if (target.bytes[target.offset + bytePos] == this.ste.term.byteAt(bytePos)) continue;
            return false;
        }
        return true;
    }

    public void scanToSubBlock(long subFP) {
        assert (!this.isLeafBlock);
        if (this.lastSubFP == subFP) {
            return;
        }
        assert (subFP < this.fp) : "fp=" + this.fp + " subFP=" + subFP;
        long targetSubCode = this.fp - subFP;
        while (true) {
            assert (this.nextEnt < this.entCount);
            ++this.nextEnt;
            int code = this.suffixLengthsReader.readVInt();
            this.suffixesReader.skipBytes(code >>> 1);
            if ((code & 1) != 0) {
                long subCode = this.suffixLengthsReader.readVLong();
                if (targetSubCode != subCode) continue;
                this.lastSubFP = subFP;
                return;
            }
            ++this.state.termBlockOrd;
        }
    }

    public TermsEnum.SeekStatus scanToTerm(BytesRef target, boolean exactOnly) throws IOException {
        if (this.isLeafBlock) {
            if (this.allEqual) {
                return this.binarySearchTermLeaf(target, exactOnly);
            }
            return this.scanToTermLeaf(target, exactOnly);
        }
        return this.scanToTermNonLeaf(target, exactOnly);
    }

    public TermsEnum.SeekStatus scanToTermLeaf(BytesRef target, boolean exactOnly) throws IOException {
        assert (this.nextEnt != -1);
        this.ste.termExists = true;
        this.subCode = 0L;
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
            }
            return TermsEnum.SeekStatus.END;
        }
        assert (this.prefixMatches(target));
        do {
            ++this.nextEnt;
            this.suffixLength = this.suffixLengthsReader.readVInt();
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffixLength);
            int cmp = Arrays.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.bytes, target.offset + this.prefixLength, target.offset + target.length);
            if (cmp < 0) continue;
            if (cmp > 0) {
                this.fillTerm();
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        } while (this.nextEnt < this.entCount);
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    public TermsEnum.SeekStatus binarySearchTermLeaf(BytesRef target, boolean exactOnly) throws IOException {
        TermsEnum.SeekStatus seekStatus;
        assert (this.nextEnt != -1);
        this.ste.termExists = true;
        this.subCode = 0L;
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
            }
            return TermsEnum.SeekStatus.END;
        }
        assert (this.prefixMatches(target));
        this.suffixLength = this.suffixLengthsReader.readVInt();
        int start = this.nextEnt;
        int end = this.entCount - 1;
        int cmp = 0;
        while (start <= end) {
            int mid = start + end >>> 1;
            this.nextEnt = mid + 1;
            this.startBytePos = mid * this.suffixLength;
            cmp = Arrays.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.bytes, target.offset + this.prefixLength, target.offset + target.length);
            if (cmp < 0) {
                start = mid + 1;
                continue;
            }
            if (cmp > 0) {
                end = mid - 1;
                continue;
            }
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (end < this.entCount - 1) {
            seekStatus = TermsEnum.SeekStatus.NOT_FOUND;
            if (cmp < 0) {
                this.startBytePos += this.suffixLength;
                ++this.nextEnt;
            }
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            this.fillTerm();
        } else {
            seekStatus = TermsEnum.SeekStatus.END;
            this.suffixesReader.setPosition(this.startBytePos + this.suffixLength);
            if (exactOnly) {
                this.fillTerm();
            }
        }
        return seekStatus;
    }

    public TermsEnum.SeekStatus scanToTermNonLeaf(BytesRef target, boolean exactOnly) throws IOException {
        assert (this.nextEnt != -1);
        if (this.nextEnt == this.entCount) {
            if (exactOnly) {
                this.fillTerm();
                this.ste.termExists = this.subCode == 0L;
            }
            return TermsEnum.SeekStatus.END;
        }
        assert (this.prefixMatches(target));
        while (this.nextEnt < this.entCount) {
            int cmp;
            ++this.nextEnt;
            int code = this.suffixLengthsReader.readVInt();
            this.suffixLength = code >>> 1;
            this.startBytePos = this.suffixesReader.getPosition();
            this.suffixesReader.skipBytes(this.suffixLength);
            boolean bl = this.ste.termExists = (code & 1) == 0;
            if (this.ste.termExists) {
                ++this.state.termBlockOrd;
                this.subCode = 0L;
            } else {
                this.subCode = this.suffixLengthsReader.readVLong();
                this.lastSubFP = this.fp - this.subCode;
            }
            if ((cmp = Arrays.compareUnsigned(this.suffixBytes, this.startBytePos, this.startBytePos + this.suffixLength, target.bytes, target.offset + this.prefixLength, target.offset + target.length)) < 0) continue;
            if (cmp > 0) {
                this.fillTerm();
                if (!exactOnly && !this.ste.termExists) {
                    this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, this.prefixLength + this.suffixLength);
                    this.ste.currentFrame.loadBlock();
                    while (this.ste.currentFrame.next()) {
                        this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, this.ste.term.length());
                        this.ste.currentFrame.loadBlock();
                    }
                }
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            assert (this.ste.termExists);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    private void fillTerm() {
        int termLength = this.prefixLength + this.suffixLength;
        this.ste.term.setLength(termLength);
        this.ste.term.grow(termLength);
        System.arraycopy(this.suffixBytes, this.startBytePos, this.ste.term.bytes(), this.prefixLength, this.suffixLength);
    }
}

