/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

public final class English {
    private English() {
    }

    public static String longToEnglish(long i) {
        StringBuilder result = new StringBuilder();
        English.longToEnglish(i, result);
        return result.toString();
    }

    public static void longToEnglish(long i, StringBuilder result) {
        if (i == 0L) {
            result.append("zero");
            return;
        }
        if (i < 0L) {
            result.append("minus ");
            i = -i;
        }
        if (i >= 1000000000000000000L) {
            English.longToEnglish(i / 1000000000000000000L, result);
            result.append("quintillion, ");
            i %= 1000000000000000000L;
        }
        if (i >= 1000000000000000L) {
            English.longToEnglish(i / 1000000000000000L, result);
            result.append("quadrillion, ");
            i %= 1000000000000000L;
        }
        if (i >= 1000000000000L) {
            English.longToEnglish(i / 1000000000000L, result);
            result.append("trillion, ");
            i %= 1000000000000L;
        }
        if (i >= 1000000000L) {
            English.longToEnglish(i / 1000000000L, result);
            result.append("billion, ");
            i %= 1000000000L;
        }
        if (i >= 1000000L) {
            English.longToEnglish(i / 1000000L, result);
            result.append("million, ");
            i %= 1000000L;
        }
        if (i >= 1000L) {
            English.longToEnglish(i / 1000L, result);
            result.append("thousand, ");
            i %= 1000L;
        }
        if (i >= 100L) {
            English.longToEnglish(i / 100L, result);
            result.append("hundred ");
            i %= 100L;
        }
        if (i >= 20L) {
            switch ((int)i / 10) {
                case 9: {
                    result.append("ninety");
                    break;
                }
                case 8: {
                    result.append("eighty");
                    break;
                }
                case 7: {
                    result.append("seventy");
                    break;
                }
                case 6: {
                    result.append("sixty");
                    break;
                }
                case 5: {
                    result.append("fifty");
                    break;
                }
                case 4: {
                    result.append("forty");
                    break;
                }
                case 3: {
                    result.append("thirty");
                    break;
                }
                case 2: {
                    result.append("twenty");
                }
            }
            if ((i %= 10L) == 0L) {
                result.append(" ");
            } else {
                result.append("-");
            }
        }
        switch ((int)i) {
            case 19: {
                result.append("nineteen ");
                break;
            }
            case 18: {
                result.append("eighteen ");
                break;
            }
            case 17: {
                result.append("seventeen ");
                break;
            }
            case 16: {
                result.append("sixteen ");
                break;
            }
            case 15: {
                result.append("fifteen ");
                break;
            }
            case 14: {
                result.append("fourteen ");
                break;
            }
            case 13: {
                result.append("thirteen ");
                break;
            }
            case 12: {
                result.append("twelve ");
                break;
            }
            case 11: {
                result.append("eleven ");
                break;
            }
            case 10: {
                result.append("ten ");
                break;
            }
            case 9: {
                result.append("nine ");
                break;
            }
            case 8: {
                result.append("eight ");
                break;
            }
            case 7: {
                result.append("seven ");
                break;
            }
            case 6: {
                result.append("six ");
                break;
            }
            case 5: {
                result.append("five ");
                break;
            }
            case 4: {
                result.append("four ");
                break;
            }
            case 3: {
                result.append("three ");
                break;
            }
            case 2: {
                result.append("two ");
                break;
            }
            case 1: {
                result.append("one ");
                break;
            }
        }
    }

    public static String intToEnglish(int i) {
        StringBuilder result = new StringBuilder();
        English.longToEnglish(i, result);
        return result.toString();
    }

    public static void intToEnglish(int i, StringBuilder result) {
        English.longToEnglish(i, result);
    }
}

