/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.IOException;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorEvaluator;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;

public class LanguageDetectorCrossValidator {
    private final TrainingParameters params;
    private final Mean documentAccuracy = new Mean();
    private final LanguageDetectorEvaluationMonitor[] listeners;
    private final LanguageDetectorFactory factory;

    public LanguageDetectorCrossValidator(TrainingParameters mlParams, LanguageDetectorFactory factory, LanguageDetectorEvaluationMonitor ... listeners) {
        this.params = mlParams;
        this.listeners = listeners;
        this.factory = factory;
    }

    public void evaluate(ObjectStream<LanguageSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<LanguageSample> partitioner = new CrossValidationPartitioner<LanguageSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<LanguageSample> trainingSampleStream = partitioner.next();
            LanguageDetectorModel model = LanguageDetectorME.train(trainingSampleStream, this.params, this.factory);
            LanguageDetectorEvaluator evaluator = new LanguageDetectorEvaluator(new LanguageDetectorME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.documentAccuracy.add(evaluator.getAccuracy(), evaluator.getDocumentCount());
        }
    }

    public double getDocumentAccuracy() {
        return this.documentAccuracy.mean();
    }

    public long getDocumentCount() {
        return this.documentAccuracy.count();
    }
}

