/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;

@ThreadSafe
public class ThreadSafeLanguageDetectorME
implements LanguageDetector,
AutoCloseable {
    private final LanguageDetectorModel model;
    private final ThreadLocal<LanguageDetectorME> threadLocal = new ThreadLocal();

    public ThreadSafeLanguageDetectorME(LanguageDetectorModel model) {
        this.model = model;
    }

    private LanguageDetectorME getLanguageDetector() {
        LanguageDetectorME ld = this.threadLocal.get();
        if (ld == null) {
            ld = new LanguageDetectorME(this.model);
            this.threadLocal.set(ld);
        }
        return ld;
    }

    @Override
    public Language[] predictLanguages(CharSequence content) {
        return this.getLanguageDetector().predictLanguages(content);
    }

    @Override
    public Language predictLanguage(CharSequence content) {
        return this.getLanguageDetector().predictLanguage(content);
    }

    @Override
    public String[] getSupportedLanguages() {
        return this.getLanguageDetector().getSupportedLanguages();
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

