/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import java.util.Arrays;
import org.apache.lucene.facet.facetset.DimRange;
import org.apache.lucene.facet.facetset.FacetSetMatcher;

public class RangeFacetSetMatcher
extends FacetSetMatcher {
    private final long[] lowerRanges;
    private final long[] upperRanges;

    public RangeFacetSetMatcher(String label, DimRange ... dimRanges) {
        super(label, RangeFacetSetMatcher.getDims(dimRanges));
        this.lowerRanges = Arrays.stream(dimRanges).mapToLong(DimRange::min).toArray();
        this.upperRanges = Arrays.stream(dimRanges).mapToLong(DimRange::max).toArray();
    }

    @Override
    public boolean matches(long[] dimValues) {
        assert (dimValues.length == this.dims) : "Encoded dimensions (dims=" + dimValues.length + ") is incompatible with range dimensions (dims=" + this.dims + ")";
        for (int i = 0; i < dimValues.length; ++i) {
            if (dimValues[i] < this.lowerRanges[i]) {
                return false;
            }
            if (dimValues[i] <= this.upperRanges[i]) continue;
            return false;
        }
        return true;
    }

    private static int getDims(DimRange ... dimRanges) {
        if (dimRanges == null || dimRanges.length == 0) {
            throw new IllegalArgumentException("dimRanges cannot be null or empty");
        }
        return dimRanges.length;
    }
}

