/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.VectorUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=3, jvmArgsAppend={"-Xmx1g", "-Xms1g", "-XX:+AlwaysPreTouch", "--add-modules", "jdk.incubator.vector"})
public class AdvanceBenchmark {
    private final int[] values = new int[129];
    private final int[] startIndexes = new int[1000];
    private final int[] targets = new int[this.startIndexes.length];

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        for (int i = 0; i < 128; ++i) {
            this.values[i] = i;
        }
        this.values[128] = Integer.MAX_VALUE;
        Random r = new Random(0L);
        for (int i = 0; i < this.startIndexes.length; ++i) {
            this.startIndexes[i] = r.nextInt(64);
            this.targets[i] = this.startIndexes[i] + 1 + r.nextInt(1 << r.nextInt(7));
        }
    }

    @Benchmark
    public void binarySearch() {
        for (int i = 0; i < this.startIndexes.length; ++i) {
            AdvanceBenchmark.binarySearch(this.values, this.targets[i], this.startIndexes[i]);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private static int binarySearch(int[] values, int target, int startIndex) {
        int i = Arrays.binarySearch(values, startIndex, values.length, target);
        if (i < 0) {
            i = -1 - i;
        }
        return i;
    }

    @Benchmark
    public void inlinedBranchlessBinarySearch() {
        for (int i = 0; i < this.targets.length; ++i) {
            AdvanceBenchmark.inlinedBranchlessBinarySearch(this.values, this.targets[i]);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private static int inlinedBranchlessBinarySearch(int[] values, int target) {
        int start = 0;
        if (values[63] < target) {
            start += 64;
        }
        if (values[start + 31] < target) {
            start += 32;
        }
        if (values[start + 15] < target) {
            start += 16;
        }
        if (values[start + 7] < target) {
            start += 8;
        }
        if (values[start + 3] < target) {
            start += 4;
        }
        if (values[start + 1] < target) {
            start += 2;
        }
        if (values[start] < target) {
            ++start;
        }
        return start;
    }

    @Benchmark
    public void linearSearch() {
        for (int i = 0; i < this.startIndexes.length; ++i) {
            AdvanceBenchmark.linearSearch(this.values, this.targets[i], this.startIndexes[i]);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private static int linearSearch(int[] values, long target, int startIndex) {
        for (int i = startIndex; i < values.length; ++i) {
            if ((long)values[i] < target) continue;
            return i;
        }
        return values.length;
    }

    @Benchmark
    public void vectorUtilSearch() {
        for (int i = 0; i < this.startIndexes.length; ++i) {
            VectorUtil.findNextGEQ((int[])this.values, (int)this.targets[i], (int)this.startIndexes[i], (int)128);
        }
    }

    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    private static int vectorUtilSearch(int[] values, int target, int startIndex) {
        return VectorUtil.findNextGEQ((int[])values, (int)target, (int)startIndex, (int)128);
    }

    private static void assertEquals(int expected, int actual) {
        if (expected != actual) {
            throw new AssertionError((Object)("Expected: " + expected + ", got " + actual));
        }
    }

    public static void main(String[] args) {
        int[] values = new int[129];
        for (int i = 0; i < 128; ++i) {
            values[i] = i;
        }
        values[128] = Integer.MAX_VALUE;
        for (int start = 0; start < 128; ++start) {
            for (int targetIndex = start; targetIndex < 128; ++targetIndex) {
                int actualIndex = AdvanceBenchmark.binarySearch(values, values[targetIndex], start);
                AdvanceBenchmark.assertEquals(targetIndex, actualIndex);
                actualIndex = AdvanceBenchmark.inlinedBranchlessBinarySearch(values, values[targetIndex]);
                AdvanceBenchmark.assertEquals(targetIndex, actualIndex);
                actualIndex = AdvanceBenchmark.linearSearch(values, values[targetIndex], start);
                AdvanceBenchmark.assertEquals(targetIndex, actualIndex);
                actualIndex = AdvanceBenchmark.vectorUtilSearch(values, values[targetIndex], start);
                AdvanceBenchmark.assertEquals(targetIndex, actualIndex);
            }
        }
    }
}

