/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.lemmatizer.DictionaryLemmatizer;
import opennlp.tools.lemmatizer.LemmatizerModel;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.postag.POSModel;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.TokenizerModel;
import org.apache.lucene.analysis.opennlp.tools.NLPChunkerOp;
import org.apache.lucene.analysis.opennlp.tools.NLPLemmatizerOp;
import org.apache.lucene.analysis.opennlp.tools.NLPNERTaggerOp;
import org.apache.lucene.analysis.opennlp.tools.NLPPOSTaggerOp;
import org.apache.lucene.analysis.opennlp.tools.NLPSentenceDetectorOp;
import org.apache.lucene.analysis.opennlp.tools.NLPTokenizerOp;
import org.apache.lucene.util.ResourceLoader;

public class OpenNLPOpsFactory {
    private static final Map<String, SentenceModel> sentenceModels = new ConcurrentHashMap<String, SentenceModel>();
    private static final ConcurrentHashMap<String, TokenizerModel> tokenizerModels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, POSModel> posTaggerModels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ChunkerModel> chunkerModels = new ConcurrentHashMap();
    private static final Map<String, TokenNameFinderModel> nerModels = new ConcurrentHashMap<String, TokenNameFinderModel>();
    private static final Map<String, LemmatizerModel> lemmatizerModels = new ConcurrentHashMap<String, LemmatizerModel>();
    private static final Map<String, DictionaryLemmatizer> lemmaDictionaries = new ConcurrentHashMap<String, DictionaryLemmatizer>();

    public static NLPSentenceDetectorOp getSentenceDetector(String modelName) throws IOException {
        if (modelName != null) {
            SentenceModel model = sentenceModels.get(modelName);
            return new NLPSentenceDetectorOp(model);
        }
        return new NLPSentenceDetectorOp();
    }

    public static SentenceModel getSentenceModel(String modelName, ResourceLoader loader) throws IOException {
        SentenceModel model = sentenceModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new SentenceModel(resource);
            }
            sentenceModels.put(modelName, model);
        }
        return model;
    }

    public static NLPTokenizerOp getTokenizer(String modelName) throws IOException {
        if (modelName == null) {
            return new NLPTokenizerOp();
        }
        TokenizerModel model = tokenizerModels.get(modelName);
        return new NLPTokenizerOp(model);
    }

    public static TokenizerModel getTokenizerModel(String modelName, ResourceLoader loader) throws IOException {
        TokenizerModel model = tokenizerModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new TokenizerModel(resource);
            }
            tokenizerModels.put(modelName, model);
        }
        return model;
    }

    public static NLPPOSTaggerOp getPOSTagger(String modelName) throws IOException {
        POSModel model = posTaggerModels.get(modelName);
        return new NLPPOSTaggerOp(model);
    }

    public static POSModel getPOSTaggerModel(String modelName, ResourceLoader loader) throws IOException {
        POSModel model = posTaggerModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new POSModel(resource);
            }
            posTaggerModels.put(modelName, model);
        }
        return model;
    }

    public static NLPChunkerOp getChunker(String modelName) throws IOException {
        ChunkerModel model = chunkerModels.get(modelName);
        return new NLPChunkerOp(model);
    }

    public static ChunkerModel getChunkerModel(String modelName, ResourceLoader loader) throws IOException {
        ChunkerModel model = chunkerModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new ChunkerModel(resource);
            }
            chunkerModels.put(modelName, model);
        }
        return model;
    }

    public static NLPNERTaggerOp getNERTagger(String modelName) throws IOException {
        TokenNameFinderModel model = nerModels.get(modelName);
        return new NLPNERTaggerOp(model);
    }

    public static TokenNameFinderModel getNERTaggerModel(String modelName, ResourceLoader loader) throws IOException {
        TokenNameFinderModel model = nerModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new TokenNameFinderModel(resource);
            }
            nerModels.put(modelName, model);
        }
        return model;
    }

    public static NLPLemmatizerOp getLemmatizer(String dictionaryFile, String lemmatizerModelFile) throws IOException {
        assert (dictionaryFile != null || lemmatizerModelFile != null) : "At least one parameter must be non-null";
        DictionaryLemmatizer dictionaryLemmatizer = null;
        if (dictionaryFile != null) {
            dictionaryLemmatizer = lemmaDictionaries.get(dictionaryFile);
        }
        LemmatizerModel lemmatizerModel = lemmatizerModelFile == null ? null : lemmatizerModels.get(lemmatizerModelFile);
        return new NLPLemmatizerOp(dictionaryLemmatizer, lemmatizerModel);
    }

    public static DictionaryLemmatizer getLemmatizerDictionary(String dictionaryFile, ResourceLoader loader) throws IOException {
        DictionaryLemmatizer dictionaryLemmatizer = lemmaDictionaries.get(dictionaryFile);
        if (dictionaryLemmatizer == null) {
            dictionaryLemmatizer = new DictionaryLemmatizer(loader.openResource(dictionaryFile));
            lemmaDictionaries.put(dictionaryFile, dictionaryLemmatizer);
        }
        return dictionaryLemmatizer;
    }

    public static LemmatizerModel getLemmatizerModel(String modelName, ResourceLoader loader) throws IOException {
        LemmatizerModel model = lemmatizerModels.get(modelName);
        if (model == null) {
            try (InputStream resource = loader.openResource(modelName);){
                model = new LemmatizerModel(resource);
            }
            lemmatizerModels.put(modelName, model);
        }
        return model;
    }

    public static void clearModels() {
        sentenceModels.clear();
        tokenizerModels.clear();
        posTaggerModels.clear();
        chunkerModels.clear();
        nerModels.clear();
        lemmaDictionaries.clear();
    }
}

