/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.apache.lucene.luke.app.desktop.components.dialog.HelpDialogFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class HelpHeaderRenderer
implements TableCellRenderer {
    private JTable table;
    private final JPanel panel = new JPanel();
    private final JComponent helpContent;
    private final HelpDialogFactory helpDialogFactory;
    private final String title;
    private final String desc;
    private final JDialog parent;

    public HelpHeaderRenderer(String title, String desc, JComponent helpContent, HelpDialogFactory helpDialogFactory) {
        this(title, desc, helpContent, helpDialogFactory, null);
    }

    public HelpHeaderRenderer(String title, String desc, JComponent helpContent, HelpDialogFactory helpDialogFactory, JDialog parent) {
        this.title = title;
        this.desc = desc;
        this.helpContent = helpContent;
        this.helpDialogFactory = helpDialogFactory;
        this.parent = parent;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null && this.table != table) {
            this.table = table;
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.panel.setLayout(new FlowLayout(3));
                this.panel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                this.panel.add(new JLabel(value.toString()));
                JLabel helpLabel = new JLabel(FontUtils.elegantIconHtml("&#x74;", MessageUtils.getLocalizedMessage("label.help")));
                helpLabel.setHorizontalAlignment(2);
                helpLabel.setIconTextGap(5);
                this.panel.add(FontUtils.toLinkText(helpLabel));
                header.addMouseListener(new HelpClickListener(column));
            }
        }
        return this.panel;
    }

    class HelpClickListener
    extends MouseAdapter {
        int column;

        HelpClickListener(int column) {
            this.column = column;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.showPopupIfNeeded(e);
        }

        private void showPopupIfNeeded(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            int column = header.getTable().columnAtPoint(e.getPoint());
            if (column == this.column && e.getClickCount() == 1 && column != -1) {
                if (Objects.nonNull(HelpHeaderRenderer.this.parent)) {
                    new DialogOpener<HelpDialogFactory>(HelpHeaderRenderer.this.helpDialogFactory).open(HelpHeaderRenderer.this.parent, HelpHeaderRenderer.this.title, 600, 350, factory -> {
                        factory.setDesc(HelpHeaderRenderer.this.desc);
                        factory.setContent(HelpHeaderRenderer.this.helpContent);
                    }, new String[0]);
                } else {
                    new DialogOpener<HelpDialogFactory>(HelpHeaderRenderer.this.helpDialogFactory).open(HelpHeaderRenderer.this.title, 600, 350, factory -> {
                        factory.setDesc(HelpHeaderRenderer.this.desc);
                        factory.setContent(HelpHeaderRenderer.this.helpContent);
                    }, new String[0]);
                }
            }
        }
    }
}

