/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.opengis.util.GenericName;

public final class AssociationRoleBuilder
extends PropertyTypeBuilder {
    private final DefaultFeatureType type;
    private final GenericName typeName;
    private transient DefaultAssociationRole property;

    AssociationRoleBuilder(FeatureTypeBuilder featureTypeBuilder, DefaultFeatureType defaultFeatureType, GenericName genericName) {
        super(featureTypeBuilder);
        this.type = defaultFeatureType;
        this.typeName = genericName;
    }

    AssociationRoleBuilder(FeatureTypeBuilder featureTypeBuilder, DefaultAssociationRole defaultAssociationRole) {
        super(featureTypeBuilder);
        this.property = defaultAssociationRole;
        this.minimumOccurs = defaultAssociationRole.getMinimumOccurs();
        this.maximumOccurs = defaultAssociationRole.getMaximumOccurs();
        if (!defaultAssociationRole.isResolved()) {
            this.type = null;
            this.typeName = Features.getValueTypeName(defaultAssociationRole);
        } else {
            this.type = defaultAssociationRole.getValueType();
            this.typeName = this.type.getName();
        }
        this.initialize(defaultAssociationRole);
    }

    @Override
    final void clearCache() {
        this.property = null;
        super.clearCache();
    }

    @Override
    final void toStringInternal(StringBuilder stringBuilder) {
        stringBuilder.append(" \u2192 ").append(this.typeName);
    }

    @Override
    final String getDefaultName() {
        return this.typeName.tip().toString();
    }

    @Override
    public AssociationRoleBuilder setName(GenericName genericName) {
        super.setName(genericName);
        return this;
    }

    @Override
    public AssociationRoleBuilder setName(CharSequence charSequence) {
        super.setName(charSequence);
        return this;
    }

    @Override
    public AssociationRoleBuilder setName(CharSequence ... charSequenceArray) {
        super.setName(charSequenceArray);
        return this;
    }

    @Override
    public AssociationRoleBuilder setMinimumOccurs(int n) {
        super.setMinimumOccurs(n);
        return this;
    }

    @Override
    public AssociationRoleBuilder setMaximumOccurs(int n) {
        super.setMaximumOccurs(n);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDefinition(CharSequence charSequence) {
        super.setDefinition(charSequence);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDesignation(CharSequence charSequence) {
        super.setDesignation(charSequence);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDescription(CharSequence charSequence) {
        super.setDescription(charSequence);
        return this;
    }

    @Override
    public AssociationRoleBuilder setDeprecated(boolean bl) {
        super.setDeprecated(bl);
        return this;
    }

    @Override
    public DefaultAssociationRole build() {
        if (this.property == null) {
            this.property = this.type != null ? new DefaultAssociationRole(this.identification(), this.type, this.minimumOccurs, this.maximumOccurs) : new DefaultAssociationRole(this.identification(), this.typeName, this.minimumOccurs, this.maximumOccurs);
        }
        return this.property;
    }
}

