/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.util.function.IntSupplier;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class RepeatedVector
extends Vector
implements Serializable {
    private static final long serialVersionUID = 3607036775685492552L;
    private final Vector base;
    private final int occurrences;
    private final int cycleLength;
    private final int size;

    RepeatedVector(Vector vector, int n, int n2, int n3) {
        this.base = vector;
        this.occurrences = n;
        this.cycleLength = n2;
        this.size = n3;
        assert (n2 <= vector.size()) : n2;
    }

    RepeatedVector(Vector vector, int[] nArray, double d) {
        this.size = vector.size();
        this.occurrences = nArray[0];
        this.cycleLength = nArray.length >= 2 ? nArray[1] : this.size / this.occurrences;
        this.base = vector.subSampling(0, this.occurrences, this.cycleLength).compress(d);
    }

    private int toBase(int n) {
        ArgumentChecks.ensureValidIndex(this.size, n);
        return n / this.occurrences % this.cycleLength;
    }

    @Override
    public final Class<? extends Number> getElementType() {
        return this.base.getElementType();
    }

    @Override
    public final boolean isEmptyOrNaN() {
        return this.base.isEmptyOrNaN();
    }

    @Override
    public final boolean isSinglePrecision() {
        return this.base.isSinglePrecision();
    }

    @Override
    public final boolean isInteger() {
        return this.base.isInteger();
    }

    @Override
    public final boolean isUnsigned() {
        return this.base.isUnsigned();
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isNaN(int n) {
        return this.base.isNaN(this.toBase(n));
    }

    @Override
    public final double doubleValue(int n) {
        return this.base.doubleValue(this.toBase(n));
    }

    @Override
    public final float floatValue(int n) {
        return this.base.floatValue(this.toBase(n));
    }

    @Override
    public final long longValue(int n) {
        return this.base.longValue(this.toBase(n));
    }

    @Override
    public final int intValue(int n) {
        return this.base.intValue(this.toBase(n));
    }

    @Override
    public final short shortValue(int n) {
        return this.base.shortValue(this.toBase(n));
    }

    @Override
    public final byte byteValue(int n) {
        return this.base.byteValue(this.toBase(n));
    }

    @Override
    public final String stringValue(int n) {
        return this.base.stringValue(this.toBase(n));
    }

    @Override
    public final Number get(int n) {
        return this.base.get(this.toBase(n));
    }

    @Override
    public final NumberRange<?> range() {
        return this.cycleLength == this.base.size() ? this.base.range() : super.range();
    }

    @Override
    final NumberRange<?> range(IntSupplier intSupplier, int n) {
        return this.base.range(() -> this.toBase(intSupplier.getAsInt()), n);
    }

    @Override
    public final Number set(int n, Number number) {
        throw new UnsupportedOperationException(Errors.format((short)175, number));
    }

    @Override
    public int[] repetitions(int ... nArray) {
        if (this.cycleLength * this.occurrences >= this.size) {
            return new int[]{this.occurrences};
        }
        return new int[]{this.occurrences, this.cycleLength};
    }

    @Override
    public Vector repeat(boolean bl, int n) {
        block2: {
            int n2;
            block4: {
                block3: {
                    if (n <= 1 || this.cycleLength * this.occurrences < this.size) break block2;
                    if (!bl) break block3;
                    if (this.cycleLength < this.base.size()) break block2;
                    n2 = this.occurrences;
                    break block4;
                }
                if (this.occurrences != 1) break block2;
                n2 = this.cycleLength;
            }
            return this.base.repeat(bl, Math.multiplyExact(n2, n));
        }
        return super.repeat(bl, n);
    }

    @Override
    public final Number increment(double d) {
        return null;
    }

    @Override
    public Vector compress(double d) {
        return this;
    }

    @Override
    final Vector backingVector() {
        return this.base;
    }

    @Override
    final int[] toBacking(int[] nArray) {
        nArray = (int[])nArray.clone();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.toBase(nArray[i]);
        }
        return nArray;
    }

    @Override
    Vector createSubSampling(int n, int n2, int n3) {
        if (n2 % this.occurrences == 0) {
            int n4 = n2 / this.occurrences;
            int n5 = n / this.occurrences;
            int n6 = n5 + (n3 - 1) * n4;
            if (n5 >= 0 && n5 <= n6 && n6 < this.base.size() && n5 / this.cycleLength == n6 / this.cycleLength) {
                return this.base.subSampling(n5, n4, n3);
            }
        }
        if (n < this.occurrences && this.occurrences % n2 == 0) {
            return new RepeatedVector(this.base, this.occurrences / n2, this.cycleLength, n3);
        }
        return super.createSubSampling(n, n2, n3);
    }
}

