/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeocentricAffine;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffineBetweenGeographic
extends GeocentricAffine {
    private static final long serialVersionUID = -6202315859507526222L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> SRC_SEMI_MINOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MINOR;

    GeocentricAffineBetweenGeographic(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup, GeodeticOperation[] geodeticOperationArray) {
        super(n, n2, parameterDescriptorGroup, geodeticOperationArray);
    }

    @Override
    public final int getEllipsoidsMask() {
        return 3;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws FactoryException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        MathTransform mathTransform = super.createMathTransform(mathTransformFactory, parameters);
        MathTransform mathTransform2 = EllipsoidToCentricTransform.createGeodeticConversion(mathTransformFactory, parameters.doubleValue(SRC_SEMI_MAJOR), parameters.doubleValue(SRC_SEMI_MINOR), Units.METRE, this.getSourceDimensions() >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        MathTransform mathTransform3 = EllipsoidToCentricTransform.createGeodeticConversion(mathTransformFactory, parameters.doubleValue(TGT_SEMI_MAJOR), parameters.doubleValue(TGT_SEMI_MINOR), Units.METRE, this.getTargetDimensions() >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        try {
            mathTransform3 = mathTransform3.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new FactoryException((Throwable)noninvertibleTransformException);
        }
        return mathTransformFactory.createConcatenatedTransform(mathTransform2, mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform3));
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)GeocentricAffineBetweenGeographic.builder().setCodeSpace(Citations.OGC, "OGC");
        SRC_SEMI_MAJOR = ((ParameterBuilder)parameterBuilder.addName("src_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        SRC_SEMI_MINOR = ((ParameterBuilder)parameterBuilder.addName("src_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MAJOR = ((ParameterBuilder)parameterBuilder.addName("tgt_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MINOR = ((ParameterBuilder)parameterBuilder.addName("tgt_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        DIMENSION = ((ParameterBuilder)parameterBuilder.addName("dim")).setRequired(false).createBounded(Integer.class, Integer.valueOf(2), Integer.valueOf(3), null);
    }
}

