/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.opus;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioSetupHeader;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.opus.OpusAudioData;
import org.gagravarr.opus.OpusInfo;
import org.gagravarr.opus.OpusPacket;
import org.gagravarr.opus.OpusPacketFactory;
import org.gagravarr.opus.OpusTags;

public class OpusFile
implements OggAudioStream,
OggAudioHeaders,
Closeable {
    private OggFile ogg;
    private OggPacketReader r;
    private OggPacketWriter w;
    private int sid = -1;
    private OpusInfo info;
    private OpusTags tags;
    private List<OpusAudioData> writtenPackets;

    public OpusFile(File f) throws IOException, FileNotFoundException {
        this(new OggFile(new FileInputStream(f)));
    }

    public OpusFile(OggFile ogg) throws IOException {
        this(ogg.getPacketReader());
        this.ogg = ogg;
    }

    public OpusFile(OggPacketReader r) throws IOException {
        this.r = r;
        OggPacket p = null;
        while ((p = r.getNextPacket()) != null) {
            if (!p.isBeginningOfStream() || p.getData().length <= 10 || !OpusPacketFactory.isOpusStream(p)) continue;
            this.sid = p.getSid();
            break;
        }
        if (this.sid == -1) {
            throw new IllegalArgumentException("Supplied File is not Opus");
        }
        this.info = (OpusInfo)OpusPacketFactory.create(p);
        this.tags = (OpusTags)OpusPacketFactory.create(r.getNextPacketWithSid(this.sid));
    }

    public OpusFile(OutputStream out) {
        this(out, new OpusInfo(), new OpusTags());
    }

    public OpusFile(OutputStream out, OpusInfo info, OpusTags tags) {
        this(out, -1, info, tags);
    }

    public OpusFile(OutputStream out, int sid, OpusInfo info, OpusTags tags) {
        this.ogg = new OggFile(out);
        if (sid > 0) {
            this.w = this.ogg.getPacketWriter(sid);
            this.sid = sid;
        } else {
            this.w = this.ogg.getPacketWriter();
            this.sid = this.w.getSid();
        }
        this.writtenPackets = new ArrayList<OpusAudioData>();
        this.info = info;
        this.tags = tags;
    }

    public OpusAudioData getNextAudioPacket() throws IOException {
        OggPacket p = null;
        OpusPacket op = null;
        while ((p = this.r.getNextPacketWithSid(this.sid)) != null) {
            op = OpusPacketFactory.create(p);
            if (op instanceof OpusAudioData) {
                return (OpusAudioData)op;
            }
            System.err.println("Skipping non audio packet " + op + " mid audio stream");
        }
        return null;
    }

    public void skipToGranule(long granulePosition) throws IOException {
        this.r.skipToGranulePosition(this.sid, granulePosition);
    }

    public int getSid() {
        return this.sid;
    }

    public OggStreamIdentifier.OggStreamType getType() {
        return OggStreamIdentifier.OPUS_AUDIO;
    }

    public OpusInfo getInfo() {
        return this.info;
    }

    public OpusTags getTags() {
        return this.tags;
    }

    public OggAudioSetupHeader getSetup() {
        return null;
    }

    public void writeAudioData(OpusAudioData data) {
        this.writtenPackets.add(data);
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r = null;
            this.ogg.close();
            this.ogg = null;
        }
        if (this.w != null) {
            this.w.bufferPacket(this.info.write(), true);
            this.w.bufferPacket(this.tags.write(), false);
            long lastGranule = 0L;
            for (OpusAudioData vd : this.writtenPackets) {
                if (vd.getGranulePosition() >= 0L && lastGranule != vd.getGranulePosition()) {
                    this.w.flush();
                    lastGranule = vd.getGranulePosition();
                    this.w.setGranulePosition(lastGranule);
                }
                this.w.bufferPacket(vd.write());
                if (this.w.getSizePendingFlush() <= 16384) continue;
                this.w.flush();
            }
            this.w.close();
            this.w = null;
            this.ogg.close();
            this.ogg = null;
        }
    }

    public OggFile getOggFile() {
        return this.ogg;
    }
}

