/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.Permission;

public class InMemoryAce {
    private static final String ANONYMOUS = "anonymous";
    private static final String ANYONE = "anyone";
    private final String principalId;
    private Permission permission;
    private static final InMemoryAce DEFAULT_ACE = new InMemoryAce(InMemoryAce.getAnyoneUser(), Permission.ALL);

    public static final String getAnyoneUser() {
        return ANYONE;
    }

    public static final String getAnonymousUser() {
        return ANONYMOUS;
    }

    public static final InMemoryAce getDefaultAce() {
        return DEFAULT_ACE;
    }

    public InMemoryAce(Ace commonsAce) {
        if (null == commonsAce || null == commonsAce.getPrincipalId() || null == commonsAce.getPermissions()) {
            throw new IllegalArgumentException("Cannot create InMemoryAce with null value");
        }
        List perms = commonsAce.getPermissions();
        if (perms.size() != 1) {
            throw new IllegalArgumentException("InMemory only supports ACEs with a single permission.");
        }
        String perm = (String)perms.get(0);
        this.principalId = commonsAce.getPrincipalId();
        this.permission = Permission.fromCmisString(perm);
    }

    public InMemoryAce(String prinicpalId, Permission permission) {
        if (null == prinicpalId || null == permission) {
            throw new IllegalArgumentException("Cannot create InMemoryAce with null value");
        }
        this.principalId = prinicpalId;
        this.permission = permission;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission newPermission) {
        this.permission = newPermission;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permission == null ? 0 : this.permission.hashCode());
        result = 31 * result + (this.principalId == null ? 0 : this.principalId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemoryAce other = (InMemoryAce)obj;
        if (this.permission != other.permission) {
            return false;
        }
        return !(this.principalId == null ? other.principalId != null : !this.principalId.equals(other.principalId));
    }

    public boolean hasPermission(Permission permission2) {
        return this.permission.compareTo(permission2) >= 0;
    }

    public String toString() {
        return "InMemoryAce [principalId=" + this.principalId + ", permission=" + (Object)((Object)this.permission) + "]";
    }

    public Ace toCommonsAce() {
        return new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(this.principalId), Collections.singletonList(this.permission.toCmisString()));
    }
}

