/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cache.CacheMetadata;
import org.apache.maven.api.cache.CacheRetention;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.ModelTransformer;
import org.apache.maven.api.services.ProblemCollector;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Result;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.Sources;
import org.apache.maven.api.services.SuperPomProvider;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.api.services.model.DependencyManagementImporter;
import org.apache.maven.api.services.model.DependencyManagementInjector;
import org.apache.maven.api.services.model.InheritanceAssembler;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.ModelNormalizer;
import org.apache.maven.api.services.model.ModelPathTranslator;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.services.model.ModelResolver;
import org.apache.maven.api.services.model.ModelResolverException;
import org.apache.maven.api.services.model.ModelUrlNormalizer;
import org.apache.maven.api.services.model.ModelValidator;
import org.apache.maven.api.services.model.ModelVersionParser;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.PluginConfigurationExpander;
import org.apache.maven.api.services.model.PluginManagementInjector;
import org.apache.maven.api.services.model.ProfileInjector;
import org.apache.maven.api.services.model.ProfileSelector;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.spi.ModelParserException;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;
import org.apache.maven.impl.model.DefaultInheritanceAssembler;
import org.apache.maven.impl.model.DefaultModelBuilderResult;
import org.apache.maven.impl.model.DefaultModelProblem;
import org.apache.maven.impl.model.DefaultProfileActivationContext;
import org.apache.maven.impl.model.Graph;
import org.apache.maven.impl.model.ModelProblemUtils;
import org.apache.maven.impl.util.PhasingExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultModelBuilder
implements ModelBuilder {
    public static final String NAMESPACE_PREFIX = "http://maven.apache.org/POM/";
    private static final String RAW = "raw";
    private static final String FILE = "file";
    private static final String IMPORT = "import";
    private static final String PARENT = "parent";
    private static final String MODEL = "model";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModelProcessor modelProcessor;
    private final ModelValidator modelValidator;
    private final ModelNormalizer modelNormalizer;
    private final ModelInterpolator modelInterpolator;
    private final ModelPathTranslator modelPathTranslator;
    private final ModelUrlNormalizer modelUrlNormalizer;
    private final SuperPomProvider superPomProvider;
    private final InheritanceAssembler inheritanceAssembler;
    private final ProfileSelector profileSelector;
    private final ProfileInjector profileInjector;
    private final PluginManagementInjector pluginManagementInjector;
    private final DependencyManagementInjector dependencyManagementInjector;
    private final DependencyManagementImporter dependencyManagementImporter;
    private final PluginConfigurationExpander pluginConfigurationExpander;
    private final ModelVersionParser versionParser;
    private final List<org.apache.maven.api.spi.ModelTransformer> transformers;
    private final ModelResolver modelResolver;
    private final Interpolator interpolator;
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;

    @Inject
    public DefaultModelBuilder(ModelProcessor modelProcessor, ModelValidator modelValidator, ModelNormalizer modelNormalizer, ModelInterpolator modelInterpolator, ModelPathTranslator modelPathTranslator, ModelUrlNormalizer modelUrlNormalizer, SuperPomProvider superPomProvider, InheritanceAssembler inheritanceAssembler, ProfileSelector profileSelector, ProfileInjector profileInjector, PluginManagementInjector pluginManagementInjector, DependencyManagementInjector dependencyManagementInjector, DependencyManagementImporter dependencyManagementImporter, PluginConfigurationExpander pluginConfigurationExpander, ModelVersionParser versionParser, @Nullable List<org.apache.maven.api.spi.ModelTransformer> transformers, ModelResolver modelResolver, Interpolator interpolator, PathTranslator pathTranslator, RootLocator rootLocator) {
        this.modelProcessor = modelProcessor;
        this.modelValidator = modelValidator;
        this.modelNormalizer = modelNormalizer;
        this.modelInterpolator = modelInterpolator;
        this.modelPathTranslator = modelPathTranslator;
        this.modelUrlNormalizer = modelUrlNormalizer;
        this.superPomProvider = superPomProvider;
        this.inheritanceAssembler = inheritanceAssembler;
        this.profileSelector = profileSelector;
        this.profileInjector = profileInjector;
        this.pluginManagementInjector = pluginManagementInjector;
        this.dependencyManagementInjector = dependencyManagementInjector;
        this.dependencyManagementImporter = dependencyManagementImporter;
        this.pluginConfigurationExpander = pluginConfigurationExpander;
        this.versionParser = versionParser;
        this.transformers = transformers;
        this.modelResolver = modelResolver;
        this.interpolator = interpolator;
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
    }

    public ModelBuilder.ModelBuilderSession newSession() {
        return new ModelBuilderSessionImpl();
    }

    private static List<String> getSubprojects(Model activated) {
        List subprojects = activated.getSubprojects();
        if (subprojects.isEmpty()) {
            subprojects = activated.getModules();
        }
        return subprojects;
    }

    private static boolean hasSubprojectsDefined(Model model) {
        return model.getLocation((Object)"subprojects") != null || model.getLocation((Object)"modules") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model buildRawModel(ModelBuilderRequest request) throws ModelBuilderException {
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter((Session)request.getSession(), request);
        try {
            ModelBuilderSessionState build = new ModelBuilderSessionState(request);
            Model model = build.readRawModel();
            if (build.hasErrors()) {
                throw build.newModelBuilderException();
            }
            Model model2 = model;
            return model2;
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }

    static String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    static String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private DefaultProfileActivationContext getProfileActivationContext(ModelBuilderRequest request, Model model) {
        return new DefaultProfileActivationContext(this.pathTranslator, this.rootLocator, this.interpolator, request.getActiveProfileIds(), request.getInactiveProfileIds(), request.getSystemProperties(), request.getUserProperties(), model);
    }

    private Map<String, Activation> getProfileActivations(Model model) {
        return model.getProfiles().stream().filter(p -> p.getActivation() != null).collect(Collectors.toMap(Profile::getId, Profile::getActivation));
    }

    private Model injectProfileActivations(Model model, Map<String, Activation> activations) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        boolean modified = false;
        for (Profile profile : model.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation != null) {
                profile = profile.withActivation(activations.get(profile.getId()));
                modified = true;
            }
            profiles.add(profile);
        }
        return modified ? model.withProfiles(profiles) : model;
    }

    private Model interpolateModel(Model model, ModelBuilderRequest request, ModelProblemCollector problems) {
        Model interpolatedModel = this.modelInterpolator.interpolateModel(model, model.getProjectDirectory(), request, problems);
        if (interpolatedModel.getParent() != null) {
            Map map1 = ((Session)request.getSession()).getUserProperties();
            Map map2 = model.getProperties();
            Map map3 = ((Session)request.getSession()).getSystemProperties();
            UnaryOperator[] unaryOperatorArray = new UnaryOperator[3];
            unaryOperatorArray[0] = map1::get;
            unaryOperatorArray[1] = map2::get;
            unaryOperatorArray[2] = map3::get;
            UnaryOperator cb = Interpolator.chain((UnaryOperator[])unaryOperatorArray);
            try {
                String interpolated = this.interpolator.interpolate(interpolatedModel.getParent().getVersion(), cb);
                interpolatedModel = interpolatedModel.withParent(interpolatedModel.getParent().withVersion(interpolated));
            }
            catch (Exception e) {
                problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Failed to interpolate field: " + interpolatedModel.getParent().getVersion() + " on class: ", e);
            }
        }
        interpolatedModel = interpolatedModel.withPomFile(model.getPomFile());
        return interpolatedModel;
    }

    private boolean rawChildVersionReferencesParent(String rawChildModelVersion) {
        return rawChildModelVersion.equals("${pom.version}") || rawChildModelVersion.equals("${project.version}") || rawChildModelVersion.equals("${pom.parent.version}") || rawChildModelVersion.equals("${project.parent.version}");
    }

    private Model getSuperModel(String modelVersion) {
        return this.superPomProvider.getSuperPom(modelVersion);
    }

    private static Dependency addExclusions(Dependency candidate, List<Exclusion> exclusions) {
        return candidate.withExclusions(Stream.concat(candidate.getExclusions().stream(), exclusions.stream()).toList());
    }

    private boolean match(Exclusion exclusion, Dependency candidate) {
        return this.match(exclusion.getGroupId(), candidate.getGroupId()) && this.match(exclusion.getArtifactId(), candidate.getArtifactId());
    }

    private boolean match(String match, String text) {
        return match.equals("*") || match.equals(text);
    }

    private boolean containsCoordinates(String message, String groupId, String artifactId, String version) {
        return !(message == null || groupId != null && !message.contains(groupId) || artifactId != null && !message.contains(artifactId) || version != null && !message.contains(version));
    }

    private static <T, A> List<T> map(List<T> resources, BiFunction<T, A, T> mapper, A argument) {
        ArrayList<T> newResources = null;
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                T resource = resources.get(i);
                T newResource = mapper.apply(resource, argument);
                if (newResource == resource) continue;
                if (newResources == null) {
                    newResources = new ArrayList<T>(resources);
                }
                newResources.set(i, newResource);
            }
        }
        return newResources;
    }

    private static boolean isParentWithinRootDirectory(Path parentPath, Path rootDirectory) {
        if (parentPath == null || rootDirectory == null) {
            return true;
        }
        try {
            Path normalizedParent = parentPath.toAbsolutePath().normalize();
            Path normalizedRoot = rootDirectory.toAbsolutePath().normalize();
            return normalizedParent.startsWith(normalizedRoot);
        }
        catch (Exception e) {
            return true;
        }
    }

    protected class ModelBuilderSessionImpl
    implements ModelBuilder.ModelBuilderSession {
        ModelBuilderSessionState mainSession;

        protected ModelBuilderSessionImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModelBuilderResult build(ModelBuilderRequest request) throws ModelBuilderException {
            RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter((Session)request.getSession(), request);
            try {
                ModelBuilderSessionState session = this.mainSession == null ? (this.mainSession = new ModelBuilderSessionState(request)) : this.mainSession.derive(request, new DefaultModelBuilderResult(request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)this.mainSession.session)));
                if (request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT) {
                    session.buildBuildPom();
                } else {
                    session.buildEffectiveModel(new LinkedHashSet<String>());
                }
                DefaultModelBuilderResult defaultModelBuilderResult = session.result;
                return defaultModelBuilderResult;
            }
            finally {
                RequestTraceHelper.exit(trace);
            }
        }
    }

    protected class ModelBuilderSessionState
    implements ModelProblemCollector {
        final Session session;
        final ModelBuilderRequest request;
        final DefaultModelBuilderResult result;
        final Graph dag;
        final Map<GAKey, Set<ModelSource>> mappedSources;
        String source;
        Model sourceModel;
        Model rootModel;
        List<RemoteRepository> pomRepositories;
        List<RemoteRepository> externalRepositories;
        List<RemoteRepository> repositories;
        final Set<String> parentChain;

        ModelBuilderSessionState(ModelBuilderRequest request) {
            this((Session)request.getSession(), request, new DefaultModelBuilderResult(request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)request.getSession())), new Graph(), new ConcurrentHashMap<GAKey, Set<ModelSource>>(64), List.of(), ModelBuilderSessionState.repos(request), ModelBuilderSessionState.repos(request), new LinkedHashSet<String>());
        }

        static List<RemoteRepository> repos(ModelBuilderRequest request) {
            return List.copyOf(request.getRepositories() != null ? request.getRepositories() : ((Session)request.getSession()).getRemoteRepositories());
        }

        private ModelBuilderSessionState(Session session, ModelBuilderRequest request, DefaultModelBuilderResult result, Graph dag, Map<GAKey, Set<ModelSource>> mappedSources, List<RemoteRepository> pomRepositories, List<RemoteRepository> externalRepositories, List<RemoteRepository> repositories, Set<String> parentChain) {
            this.session = session;
            this.request = request;
            this.result = result;
            this.dag = dag;
            this.mappedSources = mappedSources;
            this.pomRepositories = pomRepositories;
            this.externalRepositories = externalRepositories;
            this.repositories = repositories;
            this.parentChain = parentChain;
            this.result.setSource(this.request.getSource());
        }

        ModelBuilderSessionState derive(ModelSource source) {
            return this.derive(source, new DefaultModelBuilderResult(this.request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)this.session)));
        }

        ModelBuilderSessionState derive(ModelSource source, DefaultModelBuilderResult result) {
            return this.derive(ModelBuilderRequest.build((ModelBuilderRequest)this.request, (ModelSource)source), result);
        }

        ModelBuilderSessionState derive(ModelBuilderRequest request) {
            return this.derive(request, new DefaultModelBuilderResult(request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)this.session)));
        }

        ModelBuilderSessionState derive(ModelBuilderRequest request, DefaultModelBuilderResult result) {
            if (this.session != request.getSession()) {
                throw new IllegalArgumentException("Session mismatch");
            }
            return new ModelBuilderSessionState(this.session, request, result, this.dag, this.mappedSources, this.pomRepositories, this.externalRepositories, this.repositories, new LinkedHashSet<String>());
        }

        public String toString() {
            return "ModelBuilderSession[session=" + String.valueOf(this.session) + ", request=" + String.valueOf(this.request) + ", result=" + String.valueOf(this.result) + "]";
        }

        PhasingExecutor createExecutor() {
            return new PhasingExecutor(Executors.newFixedThreadPool(this.getParallelism()));
        }

        private int getParallelism() {
            int parallelism = Runtime.getRuntime().availableProcessors() / 2 + 1;
            try {
                String str = (String)this.request.getUserProperties().get("maven.modelBuilder.parallelism");
                if (str != null) {
                    parallelism = Integer.parseInt(str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Math.max(1, Math.min(parallelism, Runtime.getRuntime().availableProcessors()));
        }

        public Model getRawModel(Path from, String groupId, String artifactId) {
            ModelSource source = this.getSource(groupId, artifactId);
            if (source != null) {
                if (this.addEdge(from, source.getPath())) {
                    return null;
                }
                try {
                    return this.derive(source).readRawModel();
                }
                catch (ModelBuilderException modelBuilderException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Model getRawModel(Path from, Path path) {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Not a regular file: " + String.valueOf(path));
            }
            if (this.addEdge(from, path)) {
                return null;
            }
            try {
                return this.derive(Sources.buildSource((Path)path)).readRawModel();
            }
            catch (ModelBuilderException modelBuilderException) {
                return null;
            }
        }

        private boolean addEdge(Path from, Path p) {
            try {
                this.dag.addEdge(from.toString(), p.toString());
                return false;
            }
            catch (Graph.CycleDetectedException e) {
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Cycle detected between models at " + String.valueOf(from) + " and " + String.valueOf(p), null, e);
                return true;
            }
        }

        public ModelSource getSource(String groupId, String artifactId) {
            Set<ModelSource> sources = this.mappedSources.get(new GAKey(groupId, artifactId));
            if (sources != null) {
                return sources.stream().reduce((a, b) -> {
                    throw new IllegalStateException(String.format("No unique Source for %s:%s: %s and %s", groupId, artifactId, a.getLocation(), b.getLocation()));
                }).orElse(null);
            }
            return null;
        }

        public void putSource(String groupId, String artifactId, ModelSource source) {
            this.mappedSources.computeIfAbsent(new GAKey(groupId, artifactId), k -> new HashSet()).add(source);
            if (groupId != null) {
                this.putSource(null, artifactId, source);
            }
        }

        public ProblemCollector<ModelProblem> getProblemCollector() {
            return this.result.getProblemCollector();
        }

        public void setSource(String source) {
            this.source = source;
            this.sourceModel = null;
        }

        public void setSource(Model source) {
            this.sourceModel = source;
            this.source = null;
            if (this.rootModel == null) {
                this.rootModel = source;
            }
        }

        public String getSource() {
            if (this.source == null && this.sourceModel != null) {
                this.source = ModelProblemUtils.toPath(this.sourceModel);
            }
            return this.source;
        }

        private String getModelId() {
            return ModelProblemUtils.toId(this.sourceModel);
        }

        public void setRootModel(Model rootModel) {
            this.rootModel = rootModel;
        }

        public Model getRootModel() {
            return this.rootModel;
        }

        public void add(BuilderProblem.Severity severity, ModelProblem.Version version, String message, InputLocation location, Exception exception) {
            int line = -1;
            int column = -1;
            String source = null;
            String modelId = null;
            if (location != null) {
                line = location.getLineNumber();
                column = location.getColumnNumber();
                if (location.getSource() != null) {
                    modelId = location.getSource().getModelId();
                    source = location.getSource().getLocation();
                }
            }
            if (modelId == null) {
                modelId = this.getModelId();
                source = this.getSource();
            }
            if (line <= 0 && column <= 0 && exception instanceof ModelParserException) {
                ModelParserException e = (ModelParserException)exception;
                line = e.getLineNumber();
                column = e.getColumnNumber();
            }
            DefaultModelProblem problem = new DefaultModelProblem(message, severity, version, source, line, column, modelId, exception);
            this.add(problem);
        }

        public ModelBuilderException newModelBuilderException() {
            return new ModelBuilderException((ModelBuilderResult)this.result);
        }

        public void mergeRepositories(Model model, boolean replace) {
            if (model.getRepositories().isEmpty() || InternalSession.from(this.session).getSession().isIgnoreArtifactDescriptorRepositories()) {
                return;
            }
            Model interpolatedModel = DefaultModelBuilder.this.interpolateModel(Model.newBuilder().pomFile(model.getPomFile()).properties(model.getProperties()).repositories((Collection)model.getRepositories()).build(), this.request, this);
            List<RemoteRepository> repos = interpolatedModel.getRepositories().stream().filter(repo -> repo.getUrl() != null && !repo.getUrl().contains("${")).map(arg_0 -> ((Session)this.session).createRemoteRepository(arg_0)).toList();
            if (replace) {
                ids = repos.stream().map(org.apache.maven.api.Repository::getId).collect(Collectors.toSet());
                this.repositories = this.repositories.stream().filter(r -> !ids.contains(r.getId())).toList();
                this.pomRepositories = this.pomRepositories.stream().filter(r -> !ids.contains(r.getId())).toList();
            } else {
                ids = this.pomRepositories.stream().map(org.apache.maven.api.Repository::getId).collect(Collectors.toSet());
                repos = repos.stream().filter(r -> !ids.contains(r.getId())).toList();
            }
            RepositoryFactory repositoryFactory = (RepositoryFactory)this.session.getService(RepositoryFactory.class);
            if (this.request.getRepositoryMerging() == ModelBuilderRequest.RepositoryMerging.REQUEST_DOMINANT) {
                this.repositories = repositoryFactory.aggregate(this.session, this.repositories, repos, true);
                this.pomRepositories = this.repositories;
            } else {
                this.pomRepositories = repositoryFactory.aggregate(this.session, this.pomRepositories, repos, true);
                this.repositories = repositoryFactory.aggregate(this.session, this.pomRepositories, this.externalRepositories, false);
            }
        }

        Model transformFileToRaw(Model model) {
            if (model.getDependencies().isEmpty()) {
                return model;
            }
            ArrayList<Dependency> newDeps = new ArrayList<Dependency>(model.getDependencies().size());
            boolean changed = false;
            for (Dependency dep : model.getDependencies()) {
                Dependency newDep = null;
                if (dep.getVersion() == null) {
                    newDep = this.inferDependencyVersion(model, dep);
                    if (newDep != null) {
                        changed = true;
                    }
                } else if (dep.getGroupId() == null && (newDep = this.inferDependencyGroupId(model, dep)) != null) {
                    changed = true;
                }
                newDeps.add(newDep == null ? dep : newDep);
            }
            return changed ? model.withDependencies(newDeps) : model;
        }

        private Dependency inferDependencyVersion(Model model, Dependency dep) {
            Model depModel = this.getRawModel(model.getPomFile(), dep.getGroupId(), dep.getArtifactId());
            if (depModel == null) {
                return null;
            }
            Dependency.Builder depBuilder = Dependency.newBuilder((Dependency)dep);
            String version = depModel.getVersion();
            InputLocation versionLocation = depModel.getLocation((Object)"version");
            if (version == null && depModel.getParent() != null) {
                version = depModel.getParent().getVersion();
                versionLocation = depModel.getParent().getLocation((Object)"version");
            }
            depBuilder.version(version).location((Object)"version", versionLocation);
            if (dep.getGroupId() == null) {
                String depGroupId = depModel.getGroupId();
                InputLocation groupIdLocation = depModel.getLocation((Object)"groupId");
                if (depGroupId == null && depModel.getParent() != null) {
                    depGroupId = depModel.getParent().getGroupId();
                    groupIdLocation = depModel.getParent().getLocation((Object)"groupId");
                }
                depBuilder.groupId(depGroupId).location((Object)"groupId", groupIdLocation);
            }
            return depBuilder.build();
        }

        private Dependency inferDependencyGroupId(Model model, Dependency dep) {
            Model depModel = this.getRawModel(model.getPomFile(), dep.getGroupId(), dep.getArtifactId());
            if (depModel == null) {
                return null;
            }
            Dependency.Builder depBuilder = Dependency.newBuilder((Dependency)dep);
            String depGroupId = depModel.getGroupId();
            InputLocation groupIdLocation = depModel.getLocation((Object)"groupId");
            if (depGroupId == null && depModel.getParent() != null) {
                depGroupId = depModel.getParent().getGroupId();
                groupIdLocation = depModel.getParent().getLocation((Object)"groupId");
            }
            depBuilder.groupId(depGroupId).location((Object)"groupId", groupIdLocation);
            return depBuilder.build();
        }

        String replaceCiFriendlyVersion(Map<String, String> properties, String version) {
            return version != null ? DefaultModelBuilder.this.interpolator.interpolate(version, properties::get) : null;
        }

        private Map<String, String> getEnhancedProperties(Model model, Path rootDirectory) {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (model.getProjectDirectory() != null) {
                String basedir = model.getProjectDirectory().toString();
                String basedirUri = model.getProjectDirectory().toUri().toString();
                properties.put("basedir", basedir);
                properties.put("project.basedir", basedir);
                properties.put("project.basedir.uri", basedirUri);
            }
            try {
                String root = rootDirectory.toString();
                String rootUri = rootDirectory.toUri().toString();
                properties.put("project.rootDirectory", root);
                properties.put("project.rootDirectory.uri", rootUri);
            }
            catch (IllegalStateException root) {
                // empty catch block
            }
            if (!Objects.equals(rootDirectory, model.getProjectDirectory())) {
                Path rootModelPath = DefaultModelBuilder.this.modelProcessor.locateExistingPom(rootDirectory);
                if (rootModelPath != null && DefaultModelBuilder.isParentWithinRootDirectory(rootModelPath, rootDirectory)) {
                    Model rootModel = this.derive(Sources.buildSource((Path)rootModelPath)).readFileModel();
                    properties.putAll(this.getPropertiesWithProfiles(rootModel, properties));
                }
            } else {
                properties.putAll(this.getPropertiesWithProfiles(model, properties));
            }
            return properties;
        }

        private Map<String, String> getPropertiesWithProfiles(Model model, Map<String, String> baseProperties) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(baseProperties);
            properties.putAll(model.getProperties());
            try {
                DefaultProfileActivationContext profileContext = DefaultModelBuilder.this.getProfileActivationContext(this.request, model);
                List<Profile> activeProfiles = this.getActiveProfiles(model.getProfiles(), profileContext);
                for (Profile profile : activeProfiles) {
                    properties.putAll(profile.getProperties());
                }
            }
            catch (Exception e) {
                DefaultModelBuilder.this.logger.warn("Failed to activate profiles for CI-friendly version processing: {}", (Object)e.getMessage());
                DefaultModelBuilder.this.logger.debug("Profile activation failure details", (Throwable)e);
            }
            properties.putAll(this.session.getEffectiveProperties());
            return properties;
        }

        private Map<String, String> getPropertiesWithProfiles(Model model) {
            return this.getPropertiesWithProfiles(model, new HashMap<String, String>());
        }

        private void buildBuildPom() throws ModelBuilderException {
            Path rootDirectory;
            Path top = this.request.getSource().getPath();
            if (top == null) {
                throw new IllegalStateException("Recursive build requested but source has no path");
            }
            top = top.toAbsolutePath().normalize();
            try {
                rootDirectory = this.session.getRootDirectory();
            }
            catch (IllegalStateException e) {
                rootDirectory = ((RootLocator)this.session.getService(RootLocator.class)).findMandatoryRoot(top);
            }
            Path root = DefaultModelBuilder.this.modelProcessor.locateExistingPom(rootDirectory);
            root = root != null ? root.toAbsolutePath().normalize() : top;
            this.loadFromRoot(root, top);
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
            List<DefaultModelBuilderResult> allResults = this.results(this.result).toList();
            CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
            InternalSession session = InternalSession.from(this.session);
            RequestTrace trace = session.getCurrentTrace();
            try (PhasingExecutor executor = this.createExecutor();){
                for (DefaultModelBuilderResult r : allResults) {
                    executor.execute(() -> {
                        ModelBuilderSessionState mbs = this.derive(r.getSource(), r);
                        session.setCurrentTrace(trace);
                        try {
                            mbs.buildEffectiveModel(new LinkedHashSet<String>());
                        }
                        catch (ModelBuilderException e) {
                            for (ModelProblem problem : e.getResult().getProblemCollector().problems().toList()) {
                                this.getProblemCollector().reportProblem((BuilderProblem)problem);
                            }
                        }
                        catch (RuntimeException t) {
                            exceptions.add(t);
                        }
                        finally {
                            session.setCurrentTrace(null);
                        }
                    });
                }
            }
            if (exceptions.size() == 1) {
                throw (RuntimeException)exceptions.get(0);
            }
            if (exceptions.size() > 1) {
                MavenException fatalException = new MavenException("Multiple fatal exceptions occurred");
                exceptions.forEach(arg_0 -> fatalException.addSuppressed(arg_0));
                throw fatalException;
            }
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
        }

        Stream<DefaultModelBuilderResult> results(DefaultModelBuilderResult r) {
            return Stream.concat(Stream.of(r), r.getChildren().stream().flatMap(this::results));
        }

        private void loadFromRoot(Path root, Path top) {
            try (PhasingExecutor executor = this.createExecutor();){
                DefaultModelBuilderResult r = Objects.equals(top, root) ? this.result : new DefaultModelBuilderResult(this.request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)this.session));
                this.loadFilePom(executor, top, root, Set.of(), r);
            }
            if (this.result.getFileModel() == null && !Objects.equals(top, root)) {
                DefaultModelBuilder.this.logger.warn("The top project ({}) cannot be found in the reactor from root project ({}). Make sure the root directory is correct (a missing '.mvn' directory in the root project is the most common cause) and the project is correctly included in the reactor (missing activated profiles, command line options, etc.). For this build, the top project will be used as the root project.", (Object)top, (Object)root);
                this.mappedSources.clear();
                this.loadFromRoot(top, top);
            }
        }

        private void loadFilePom(Executor executor, Path top, Path pom, Set<Path> parents, DefaultModelBuilderResult r) {
            try {
                Path pomDirectory = Files.isDirectory(pom, new LinkOption[0]) ? pom : pom.getParent();
                ModelSource src = Sources.buildSource((Path)pom);
                Model model = this.derive(src, r).readFileModel();
                this.putSource(DefaultModelBuilder.getGroupId(model), model.getArtifactId(), src);
                Model activated = this.activateFileModel(model);
                for (String subproject : DefaultModelBuilder.getSubprojects(activated)) {
                    DefaultModelBuilderResult cr;
                    if (subproject == null || subproject.isEmpty()) continue;
                    Path rawSubprojectFile = DefaultModelBuilder.this.modelProcessor.locateExistingPom(pomDirectory.resolve(subproject = subproject.replace('\\', File.separatorChar).replace('/', File.separatorChar)));
                    if (rawSubprojectFile == null) {
                        DefaultModelProblem problem = new DefaultModelProblem("Child subproject " + subproject + " of " + String.valueOf(pomDirectory) + " does not exist", BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        r.getProblemCollector().reportProblem((BuilderProblem)problem);
                        continue;
                    }
                    Path subprojectFile = rawSubprojectFile.toAbsolutePath().normalize();
                    if (parents.contains(subprojectFile)) {
                        StringBuilder buffer = new StringBuilder(256);
                        for (Path aggregatorFile : parents) {
                            buffer.append(aggregatorFile).append(" -> ");
                        }
                        buffer.append(subprojectFile);
                        DefaultModelProblem problem = new DefaultModelProblem("Child subproject " + String.valueOf(subprojectFile) + " of " + String.valueOf(pom) + " forms aggregation cycle " + String.valueOf(buffer), BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, model, -1, -1, null);
                        r.getProblemCollector().reportProblem((BuilderProblem)problem);
                        continue;
                    }
                    DefaultModelBuilderResult defaultModelBuilderResult = cr = Objects.equals(top, subprojectFile) ? this.result : new DefaultModelBuilderResult(this.request, (ProblemCollector<ModelProblem>)ProblemCollector.create((ProtoSession)this.session));
                    if (this.request.isRecursive()) {
                        r.getChildren().add(cr);
                    }
                    InternalSession session = InternalSession.from(this.session);
                    RequestTrace trace = session.getCurrentTrace();
                    executor.execute(() -> {
                        session.setCurrentTrace(trace);
                        try {
                            this.loadFilePom(executor, top, subprojectFile, ModelBuilderSessionState.concat(parents, pom), cr);
                        }
                        finally {
                            session.setCurrentTrace(null);
                        }
                    });
                }
            }
            catch (ModelBuilderException e) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, "Failed to load project " + String.valueOf(pom), (Exception)((Object)e));
            }
        }

        static <T> Set<T> concat(Set<T> a, T b) {
            HashSet<T> result = new HashSet<T>(a);
            result.add(b);
            return Set.copyOf(result);
        }

        void buildEffectiveModel(Collection<String> importIds) throws ModelBuilderException {
            ModelTransformer lifecycleBindingsInjector;
            Model resultModel = this.readEffectiveModel();
            this.setSource(resultModel);
            this.setRootModel(resultModel);
            resultModel = DefaultModelBuilder.this.modelPathTranslator.alignToBaseDirectory(resultModel, resultModel.getProjectDirectory(), this.request);
            resultModel = DefaultModelBuilder.this.pluginManagementInjector.injectManagement(resultModel, this.request, this);
            if (this.request.getRequestType() != ModelBuilderRequest.RequestType.CONSUMER_DEPENDENCY && (lifecycleBindingsInjector = this.request.getLifecycleBindingsInjector()) != null) {
                resultModel = lifecycleBindingsInjector.transform(resultModel, this.request, (ModelProblemCollector)this);
            }
            resultModel = this.importDependencyManagement(resultModel, importIds);
            resultModel = DefaultModelBuilder.this.dependencyManagementInjector.injectManagement(resultModel, this.request, this);
            resultModel = DefaultModelBuilder.this.modelNormalizer.injectDefaultValues(resultModel, this.request, this);
            if (this.request.getRequestType() != ModelBuilderRequest.RequestType.CONSUMER_DEPENDENCY) {
                resultModel = DefaultModelBuilder.this.pluginConfigurationExpander.expandPluginConfiguration(resultModel, this.request, this);
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                resultModel = transformer.transformEffectiveModel(resultModel);
            }
            this.result.setEffectiveModel(resultModel);
            if (this.result.getFileModel().getParent() != null && this.result.getFileModel().getParent().getRelativePath() == null) {
                this.result.setFileModel(this.result.getFileModel().withParent(this.result.getFileModel().getParent().withRelativePath(resultModel.getParent().getRelativePath())));
            }
            DefaultModelBuilder.this.modelValidator.validateEffectiveModel(this.session, resultModel, this.isBuildRequest() ? 40 : 0, this);
            if (this.hasErrors()) {
                throw this.newModelBuilderException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Model readParent(Model childModel, Parent parent, DefaultProfileActivationContext profileActivationContext, Set<String> parentChain) {
            if (parent != null) {
                String parentId = parent.getGroupId() + ":" + parent.getArtifactId() + ":" + parent.getVersion();
                if (!parentChain.add(parentId)) {
                    StringBuilder message = new StringBuilder("The parents form a cycle: ");
                    for (String id : parentChain) {
                        message.append(id).append(" -> ");
                    }
                    message.append(parentId);
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, message.toString());
                    throw this.newModelBuilderException();
                }
                try {
                    Model parentModel = this.resolveParent(childModel, parent, profileActivationContext, parentChain);
                    if (!"pom".equals(parentModel.getPackaging())) {
                        this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Invalid packaging for parent POM " + ModelProblemUtils.toSourceHint(parentModel) + ", must be \"pom\" but is \"" + parentModel.getPackaging() + "\"", parentModel.getLocation((Object)"packaging"));
                    }
                    this.result.setParentModel(parentModel);
                    if (parentModel.getParent() == null) return parentModel;
                    this.readParent(parentModel, parentModel.getParent(), profileActivationContext, parentChain);
                    return parentModel;
                }
                finally {
                    parentChain.remove(parentId);
                }
            } else {
                String superModelVersion = childModel.getModelVersion();
                if (superModelVersion != null) {
                    if (ModelBuilder.KNOWN_MODEL_VERSIONS.contains(superModelVersion)) return DefaultModelBuilder.this.getSuperModel(superModelVersion);
                }
                superModelVersion = "4.0.0";
                return DefaultModelBuilder.this.getSuperModel(superModelVersion);
            }
        }

        private Model resolveParent(Model childModel, Parent parent, DefaultProfileActivationContext profileActivationContext, Set<String> parentChain) throws ModelBuilderException {
            Model parentModel = null;
            if (this.isBuildRequest()) {
                parentModel = this.readParentLocally(childModel, parent, profileActivationContext, parentChain);
            }
            if (parentModel == null) {
                parentModel = this.resolveAndReadParentExternally(childModel, parent, profileActivationContext, parentChain);
            }
            return parentModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Model readParentLocally(Model childModel, Parent parent, DefaultProfileActivationContext profileActivationContext, Set<String> parentChain) throws ModelBuilderException {
            ModelSource candidateSource;
            String parentPath = parent.getRelativePath();
            if (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT) {
                if (parentPath != null && !parentPath.isEmpty()) {
                    candidateSource = this.request.getSource().resolve(DefaultModelBuilder.this.modelProcessor::locateExistingPom, parentPath);
                    if (candidateSource == null) {
                        this.wrongParentRelativePath(childModel);
                        return null;
                    }
                } else {
                    candidateSource = this.resolveReactorModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                    if (candidateSource == null && parentPath == null) {
                        candidateSource = this.request.getSource().resolve(DefaultModelBuilder.this.modelProcessor::locateExistingPom, "..");
                    }
                }
            } else {
                candidateSource = this.resolveReactorModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                if (candidateSource == null) {
                    if (parentPath == null) {
                        parentPath = "..";
                    }
                    if (!parentPath.isEmpty()) {
                        candidateSource = this.request.getSource().resolve(DefaultModelBuilder.this.modelProcessor::locateExistingPom, parentPath);
                    }
                }
            }
            if (candidateSource == null) {
                return null;
            }
            String sourceLocation = candidateSource.getLocation();
            if (!parentChain.add(sourceLocation)) {
                StringBuilder message = new StringBuilder("The parents form a cycle: ");
                for (String location : parentChain) {
                    message.append(location).append(" -> ");
                }
                message.append(sourceLocation);
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, message.toString());
                throw this.newModelBuilderException();
            }
            try {
                ModelBuilderSessionState derived = this.derive(candidateSource);
                Model candidateModel = derived.readAsParentModel(profileActivationContext, parentChain);
                this.addActivePomProfiles(derived.result.getActivePomProfiles());
                String groupId = DefaultModelBuilder.getGroupId(candidateModel);
                String artifactId = candidateModel.getArtifactId();
                String version = DefaultModelBuilder.getVersion(candidateModel);
                if (groupId == null || !groupId.equals(parent.getGroupId()) || artifactId == null || !artifactId.equals(parent.getArtifactId())) {
                    this.mismatchRelativePathAndGA(childModel, groupId, artifactId);
                    Model model = null;
                    return model;
                }
                if (version != null && parent.getVersion() != null && !version.equals(parent.getVersion())) {
                    block26: {
                        try {
                            VersionRange parentRange = DefaultModelBuilder.this.versionParser.parseVersionRange(parent.getVersion());
                            if (parentRange.contains(DefaultModelBuilder.this.versionParser.parseVersion(version))) break block26;
                            Model model = null;
                            return model;
                        }
                        catch (VersionParserException e) {
                            Model model = null;
                            parentChain.remove(sourceLocation);
                            return model;
                        }
                    }
                    String rawChildModelVersion = childModel.getVersion();
                    if (rawChildModelVersion == null) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
                    } else if (DefaultModelBuilder.this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
                    }
                }
                Model model = candidateModel;
                return model;
            }
            finally {
                parentChain.remove(sourceLocation);
            }
        }

        private void mismatchRelativePathAndGA(Model childModel, String groupId, String artifactId) {
            Parent parent = childModel.getParent();
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != this.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at ").append(groupId).append(':').append(artifactId);
            buffer.append(" instead of ").append(parent.getGroupId()).append(':');
            buffer.append(parent.getArtifactId()).append(", please verify your project structure");
            this.setSource(childModel);
            boolean warn = "4.0.0".equals(childModel.getModelVersion()) || childModel.getParent().getRelativePath() == null;
            this.add(warn ? BuilderProblem.Severity.WARNING : BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""));
        }

        private void wrongParentRelativePath(Model childModel) {
            Parent parent = childModel.getParent();
            String parentPath = parent.getRelativePath();
            StringBuilder buffer = new StringBuilder(256);
            buffer.append("'parent.relativePath'");
            if (childModel != this.getRootModel()) {
                buffer.append(" of POM ").append(ModelProblemUtils.toSourceHint(childModel));
            }
            buffer.append(" points at '").append(parentPath);
            buffer.append("' but no POM could be found, please verify your project structure");
            this.setSource(childModel);
            this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""));
        }

        Model resolveAndReadParentExternally(Model childModel, Parent parent, DefaultProfileActivationContext profileActivationContext, Set<String> parentChain) throws ModelBuilderException {
            ModelSource modelSource;
            ModelBuilderRequest request = this.request;
            this.setSource(childModel);
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            if (!childModel.getRepositories().isEmpty()) {
                List<RemoteRepository> previousRepositories = this.repositories;
                this.mergeRepositories(childModel, false);
                if (!Objects.equals(previousRepositories, this.repositories) && DefaultModelBuilder.this.logger.isDebugEnabled()) {
                    DefaultModelBuilder.this.logger.debug("Merging repositories from " + childModel.getId() + "\n" + this.repositories.stream().map(Object::toString).collect(Collectors.joining("\n", "    ", "")));
                }
            }
            try {
                modelSource = this.resolveReactorModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
                if (modelSource == null) {
                    AtomicReference<Parent> modified = new AtomicReference<Parent>();
                    modelSource = DefaultModelBuilder.this.modelResolver.resolveModel((Session)request.getSession(), this.repositories, parent, modified);
                    if (modified.get() != null) {
                        parent = modified.get();
                    }
                }
            }
            catch (ModelResolverException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable parent POM");
                if (!DefaultModelBuilder.this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                if (childModel != this.getRootModel()) {
                    buffer.append(" for ").append(ModelProblemUtils.toId(childModel));
                }
                buffer.append(": ").append(e.getMessage());
                if (request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT) {
                    buffer.append(" and parent could not be found in reactor");
                }
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, buffer.toString(), parent.getLocation((Object)""), (Exception)((Object)e));
                throw this.newModelBuilderException();
            }
            ModelBuilderRequest lenientRequest = ModelBuilderRequest.builder((ModelBuilderRequest)request).requestType(ModelBuilderRequest.RequestType.CONSUMER_PARENT).source(modelSource).build();
            Model parentModel = this.derive(lenientRequest).readAsParentModel(profileActivationContext, parentChain);
            if (!parent.getVersion().equals(version)) {
                String rawChildModelVersion = childModel.getVersion();
                if (rawChildModelVersion == null) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)""));
                } else if (DefaultModelBuilder.this.rawChildVersionReferencesParent(rawChildModelVersion)) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, "Version must be a constant", childModel.getLocation((Object)"version"));
                }
            }
            return parentModel;
        }

        Model activateFileModel(Model inputModel) throws ModelBuilderException {
            this.setRootModel(inputModel);
            DefaultProfileActivationContext profileActivationContext = DefaultModelBuilder.this.getProfileActivationContext(this.request, inputModel);
            this.setSource("(external profiles)");
            List<Profile> activeExternalProfiles = this.getActiveProfiles(this.request.getProfiles(), profileActivationContext);
            this.result.setActiveExternalProfiles(activeExternalProfiles);
            if (!activeExternalProfiles.isEmpty()) {
                HashMap<String, String> profileProps = new HashMap<String, String>();
                for (Profile profile : activeExternalProfiles) {
                    profileProps.putAll(profile.getProperties());
                }
                profileProps.putAll(this.request.getUserProperties());
                profileActivationContext.setUserProperties(profileProps);
            }
            profileActivationContext.setModel(inputModel);
            this.setSource(inputModel);
            List<Profile> activePomProfiles = this.getActiveProfiles(inputModel.getProfiles(), profileActivationContext);
            this.setSource(inputModel);
            inputModel = DefaultModelBuilder.this.modelNormalizer.mergeDuplicates(inputModel, this.request, this);
            Map<String, Activation> interpolatedActivations = DefaultModelBuilder.this.getProfileActivations(inputModel);
            inputModel = DefaultModelBuilder.this.injectProfileActivations(inputModel, interpolatedActivations);
            inputModel = DefaultModelBuilder.this.profileInjector.injectProfiles(inputModel, activePomProfiles, this.request, this);
            inputModel = DefaultModelBuilder.this.profileInjector.injectProfiles(inputModel, activeExternalProfiles, this.request, this);
            return inputModel;
        }

        private Model readEffectiveModel() throws ModelBuilderException {
            Model inputModel = this.readRawModel();
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            this.setRootModel(inputModel);
            Model activatedFileModel = this.activateFileModel(inputModel);
            DefaultProfileActivationContext profileActivationContext = DefaultModelBuilder.this.getProfileActivationContext(this.request, activatedFileModel);
            List<Profile> activeExternalProfiles = this.result.getActiveExternalProfiles();
            if (!activeExternalProfiles.isEmpty()) {
                HashMap<String, String> profileProps = new HashMap<String, String>();
                for (Profile profile : activeExternalProfiles) {
                    profileProps.putAll(profile.getProperties());
                }
                profileProps.putAll(this.request.getUserProperties());
                profileActivationContext.setUserProperties(profileProps);
            }
            Model parentModel = this.readParent(activatedFileModel, activatedFileModel.getParent(), profileActivationContext, this.parentChain);
            if (inputModel.getParent() != null && inputModel.getParent().getRelativePath() == null) {
                String relPath = parentModel.getPomFile() != null && this.isBuildRequest() ? inputModel.getPomFile().getParent().toAbsolutePath().relativize(parentModel.getPomFile().toAbsolutePath().getParent()).toString() : "..";
                inputModel = inputModel.withParent(inputModel.getParent().withRelativePath(relPath));
            }
            Model model = DefaultModelBuilder.this.inheritanceAssembler.assembleModelInheritance(inputModel, parentModel, this.request, this);
            profileActivationContext.setModel(model);
            List<Profile> activePomProfiles = this.getActiveProfiles(model.getProfiles(), profileActivationContext);
            model = DefaultModelBuilder.this.profileInjector.injectProfiles(model, activePomProfiles, this.request, this);
            model = DefaultModelBuilder.this.profileInjector.injectProfiles(model, activeExternalProfiles, this.request, this);
            this.addActivePomProfiles(activePomProfiles);
            Model resultModel = model;
            resultModel = DefaultModelBuilder.this.interpolateModel(resultModel, this.request, this);
            resultModel = DefaultModelBuilder.this.modelNormalizer.mergeDuplicates(resultModel, this.request, this);
            resultModel = DefaultModelBuilder.this.modelUrlNormalizer.normalize(resultModel, this.request);
            if (!resultModel.getRepositories().isEmpty()) {
                List<String> oldRepos = this.repositories.stream().map(Object::toString).toList();
                this.mergeRepositories(resultModel, true);
                List<String> newRepos = this.repositories.stream().map(Object::toString).toList();
                if (!Objects.equals(oldRepos, newRepos)) {
                    DefaultModelBuilder.this.logger.debug("Replacing repositories from " + resultModel.getId() + "\n" + newRepos.stream().map(s -> "    " + s).collect(Collectors.joining("\n")));
                }
            }
            return resultModel;
        }

        private void addActivePomProfiles(List<Profile> activePomProfiles) {
            if (activePomProfiles != null) {
                if (this.result.getActivePomProfiles() == null) {
                    this.result.setActivePomProfiles(new ArrayList<Profile>());
                }
                this.result.getActivePomProfiles().addAll(activePomProfiles);
            }
        }

        private List<Profile> getActiveProfiles(Collection<Profile> interpolatedProfiles, DefaultProfileActivationContext profileActivationContext) {
            if (this.isBuildRequestWithActivation()) {
                return DefaultModelBuilder.this.profileSelector.getActiveProfiles(interpolatedProfiles, profileActivationContext, this);
            }
            return List.of();
        }

        Model readFileModel() throws ModelBuilderException {
            Model model = this.cache((Source)this.request.getSource(), DefaultModelBuilder.FILE, this::doReadFileModel);
            this.result.setFileModel(model);
            return model;
        }

        Model doReadFileModel() throws ModelBuilderException {
            String namespace;
            Model model;
            Path rootDirectory;
            ModelSource modelSource;
            block54: {
                modelSource = this.request.getSource();
                this.setSource(modelSource.getLocation());
                DefaultModelBuilder.this.logger.debug("Reading file model from " + modelSource.getLocation());
                try {
                    InputSource v4src;
                    boolean strict = this.isBuildRequest();
                    try {
                        rootDirectory = ((Session)this.request.getSession()).getRootDirectory();
                    }
                    catch (IllegalStateException ignore) {
                        for (rootDirectory = modelSource.getPath(); rootDirectory != null && !Files.isDirectory(rootDirectory, new LinkOption[0]); rootDirectory = rootDirectory.getParent()) {
                        }
                    }
                    try (InputStream is = modelSource.openStream();){
                        model = DefaultModelBuilder.this.modelProcessor.read(XmlReaderRequest.builder().strict(strict).location(modelSource.getLocation()).path(modelSource.getPath()).rootDirectory(rootDirectory).inputStream(is).transformer((XmlReaderRequest.Transformer)new InterningTransformer(this.session)).build());
                    }
                    catch (XmlReaderException e) {
                        if (!strict) {
                            throw e;
                        }
                        try (InputStream is2 = modelSource.openStream();){
                            model = DefaultModelBuilder.this.modelProcessor.read(XmlReaderRequest.builder().strict(false).location(modelSource.getLocation()).path(modelSource.getPath()).rootDirectory(rootDirectory).inputStream(is2).transformer((XmlReaderRequest.Transformer)new InterningTransformer(this.session)).build());
                        }
                        catch (XmlReaderException ne) {
                            throw e;
                        }
                        this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, "Malformed POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                    }
                    InputLocation loc = model.getLocation((Object)"");
                    InputSource inputSource = v4src = loc != null ? loc.getSource() : null;
                    if (v4src == null) break block54;
                    try {
                        Field field = InputSource.class.getDeclaredField("modelId");
                        field.setAccessible(true);
                        field.set(v4src, ModelProblemUtils.toId(model));
                    }
                    catch (Throwable t) {
                        throw new IllegalStateException("Unable to set modelId on InputSource", t);
                    }
                }
                catch (XmlReaderException e) {
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-parseable POM " + modelSource.getLocation() + ": " + e.getMessage(), (Exception)((Object)e));
                    throw this.newModelBuilderException();
                }
                catch (IOException e) {
                    String msg = e.getMessage();
                    if (msg == null || msg.isEmpty()) {
                        msg = e.getClass().getName().endsWith("MalformedInputException") ? "Some input bytes do not match the file encoding." : e.getClass().getSimpleName();
                    }
                    this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Non-readable POM " + modelSource.getLocation() + ": " + msg, e);
                    throw this.newModelBuilderException();
                }
            }
            if (model.getModelVersion() == null && (namespace = model.getNamespaceUri()) != null && namespace.startsWith(DefaultModelBuilder.NAMESPACE_PREFIX)) {
                model = model.withModelVersion(namespace.substring(DefaultModelBuilder.NAMESPACE_PREFIX.length()));
            }
            if (this.isBuildRequest()) {
                Parent parent = (model = model.withPomFile(modelSource.getPath())).getParent();
                if (parent != null) {
                    String groupId = parent.getGroupId();
                    String artifactId = parent.getArtifactId();
                    String version = parent.getVersion();
                    String path = parent.getRelativePath();
                    if (!(groupId != null && artifactId != null && version != null || path != null && path.isEmpty())) {
                        Path relativePath;
                        Path pomFile = model.getPomFile();
                        Path pomPath = pomFile.resolveSibling(relativePath = Paths.get(path != null ? path : "..", new String[0])).normalize();
                        if (Files.isDirectory(pomPath, new LinkOption[0])) {
                            pomPath = DefaultModelBuilder.this.modelProcessor.locateExistingPom(pomPath);
                        }
                        if (pomPath != null && Files.isRegularFile(pomPath, new LinkOption[0])) {
                            if (!DefaultModelBuilder.isParentWithinRootDirectory(pomPath, rootDirectory)) {
                                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Parent POM " + String.valueOf(pomPath) + " is located above the root directory " + String.valueOf(rootDirectory) + ". This setup is invalid when a .mvn directory exists in a subdirectory.", parent.getLocation((Object)"relativePath"));
                                throw this.newModelBuilderException();
                            }
                            Model parentModel = this.derive(Sources.buildSource((Path)pomPath)).readFileModel();
                            String parentGroupId = DefaultModelBuilder.getGroupId(parentModel);
                            String parentArtifactId = parentModel.getArtifactId();
                            String parentVersion = DefaultModelBuilder.getVersion(parentModel);
                            if (!(groupId != null && !groupId.equals(parentGroupId) || artifactId != null && !artifactId.equals(parentArtifactId) || version != null && !version.equals(parentVersion))) {
                                model = model.withParent(parent.with().groupId(parentGroupId).artifactId(parentArtifactId).version(parentVersion).build());
                            } else {
                                this.mismatchRelativePathAndGA(model, parentGroupId, parentArtifactId);
                            }
                        } else if (!"4.0.0".equals(model.getModelVersion()) && path != null) {
                            this.wrongParentRelativePath(model);
                        }
                    }
                }
                if (!DefaultModelBuilder.hasSubprojectsDefined(model) && !"4.0.0".equals(model.getModelVersion()) && "pom".equals(model.getPackaging())) {
                    ArrayList<String> subprojects = new ArrayList<String>();
                    try (Stream<Path> files = Files.list(model.getProjectDirectory());){
                        for (Path f : files.toList()) {
                            Path subproject;
                            if (!Files.isDirectory(f, new LinkOption[0]) || (subproject = DefaultModelBuilder.this.modelProcessor.locateExistingPom(f)) == null) continue;
                            subprojects.add(f.getFileName().toString());
                        }
                        if (!subprojects.isEmpty()) {
                            model = model.withSubprojects(subprojects);
                        }
                    }
                    catch (IOException e) {
                        this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, "Error discovering subprojects", e);
                    }
                }
                Map<String, String> properties = this.getEnhancedProperties(model, rootDirectory);
                model = model.with().version(this.replaceCiFriendlyVersion(properties, model.getVersion())).parent(model.getParent() != null ? model.getParent().withVersion(this.replaceCiFriendlyVersion(properties, model.getParent().getVersion())) : null).build();
                UnaryOperator callback = properties::get;
                Map<String, String> newProps = this.merge((model = model.with().repositories(this.interpolateRepository(model.getRepositories(), (UnaryOperator<String>)callback)).pluginRepositories(this.interpolateRepository(model.getPluginRepositories(), (UnaryOperator<String>)callback)).profiles(DefaultModelBuilder.map(model.getProfiles(), this::interpolateRepository, callback)).distributionManagement(this.interpolateRepository(model.getDistributionManagement(), (UnaryOperator<String>)callback)).build()).getProperties(), (Map<String, String>)this.session.getUserProperties());
                if (newProps != null) {
                    model = model.withProperties(newProps);
                }
                model = model.withProfiles(this.merge(model.getProfiles(), (Map<String, String>)this.session.getUserProperties()));
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                model = transformer.transformFileModel(model);
            }
            this.setSource(model);
            DefaultModelBuilder.this.modelValidator.validateFileModel(this.session, model, this.isBuildRequest() ? 40 : 0, this);
            InternalSession internalSession = InternalSession.from(this.session);
            if (Features.mavenMaven3Personality((Map)internalSession.getSession().getConfigProperties()) && Objects.equals("4.1.0", model.getModelVersion())) {
                this.add(BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "Maven3 mode: no higher model version than 4.0.0 allowed");
            }
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            return model;
        }

        private DistributionManagement interpolateRepository(DistributionManagement distributionManagement, UnaryOperator<String> callback) {
            return distributionManagement == null ? null : distributionManagement.with().repository((DeploymentRepository)this.interpolateRepository((Repository)distributionManagement.getRepository(), callback)).snapshotRepository((DeploymentRepository)this.interpolateRepository((Repository)distributionManagement.getSnapshotRepository(), callback)).build();
        }

        private Profile interpolateRepository(Profile profile, UnaryOperator<String> callback) {
            return profile == null ? null : profile.with().repositories(this.interpolateRepository(profile.getRepositories(), callback)).pluginRepositories(this.interpolateRepository(profile.getPluginRepositories(), callback)).build();
        }

        private List<Repository> interpolateRepository(List<Repository> repositories, UnaryOperator<String> callback) {
            return DefaultModelBuilder.map(repositories, this::interpolateRepository, callback);
        }

        private Repository interpolateRepository(Repository repository, UnaryOperator<String> callback) {
            return repository == null ? null : repository.with().id(DefaultModelBuilder.this.interpolator.interpolate(repository.getId(), callback)).url(DefaultModelBuilder.this.interpolator.interpolate(repository.getUrl(), callback)).build();
        }

        List<Profile> merge(List<Profile> profiles, Map<String, String> userProperties) {
            List<Profile> result = null;
            for (int i = 0; i < profiles.size(); ++i) {
                Profile profile = profiles.get(i);
                Map<String, String> props = this.merge(profile.getProperties(), userProperties);
                if (props == null) continue;
                Profile merged = profile.withProperties(props);
                if (result == null) {
                    result = new ArrayList<Profile>(profiles);
                }
                result.set(i, merged);
            }
            return result != null ? result : profiles;
        }

        Map<String, String> merge(Map<String, String> properties, Map<String, String> userProperties) {
            LinkedHashMap<String, String> result = null;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                String key = entry.getKey();
                String value = userProperties.get(key);
                if (value == null || Objects.equals(value, entry.getValue())) continue;
                if (result == null) {
                    result = new LinkedHashMap<String, String>(properties);
                }
                result.put(entry.getKey(), value);
            }
            return result;
        }

        Model readRawModel() throws ModelBuilderException {
            this.readFileModel();
            Model model = this.cache((Source)this.request.getSource(), DefaultModelBuilder.RAW, this::doReadRawModel);
            this.result.setRawModel(model);
            return model;
        }

        private Model doReadRawModel() throws ModelBuilderException {
            Model rawModel = this.readFileModel();
            if (!"4.0.0".equals(rawModel.getModelVersion()) && this.isBuildRequest()) {
                rawModel = this.transformFileToRaw(rawModel);
            }
            for (org.apache.maven.api.spi.ModelTransformer transformer : DefaultModelBuilder.this.transformers) {
                rawModel = transformer.transformRawModel(rawModel);
            }
            DefaultModelBuilder.this.modelValidator.validateRawModel(this.session, rawModel, this.isBuildRequest() ? 40 : 0, this);
            if (this.hasFatalErrors()) {
                throw this.newModelBuilderException();
            }
            return rawModel;
        }

        Model readAsParentModel(DefaultProfileActivationContext profileActivationContext, Set<String> parentChain) throws ModelBuilderException {
            Map parentsPerContext = this.cache((Source)this.request.getSource(), DefaultModelBuilder.PARENT, ConcurrentHashMap::new);
            for (Map.Entry e : parentsPerContext.entrySet()) {
                if (!((DefaultProfileActivationContext.Record)e.getKey()).matches(profileActivationContext)) continue;
                ParentModelWithProfiles cached = (ParentModelWithProfiles)e.getValue();
                if (profileActivationContext.record != null) {
                    this.replayRecordIntoContext((DefaultProfileActivationContext.Record)e.getKey(), profileActivationContext);
                }
                this.addActivePomProfiles(cached.activatedProfiles());
                return cached.model();
            }
            DefaultProfileActivationContext ctx = profileActivationContext.start();
            ParentModelWithProfiles modelWithProfiles = this.doReadAsParentModel(ctx, parentChain);
            DefaultProfileActivationContext.Record record = ctx.stop();
            this.replayRecordIntoContext(record, profileActivationContext);
            parentsPerContext.put(record, modelWithProfiles);
            this.addActivePomProfiles(modelWithProfiles.activatedProfiles());
            return modelWithProfiles.model();
        }

        private ParentModelWithProfiles doReadAsParentModel(DefaultProfileActivationContext childProfileActivationContext, Set<String> parentChain) throws ModelBuilderException {
            Model raw = this.readRawModel();
            Model parentData = this.readParent(raw, raw.getParent(), childProfileActivationContext, parentChain);
            Model parent = new DefaultInheritanceAssembler(new DefaultInheritanceAssembler.InheritanceModelMerger(){

                protected void mergeModel_Modules(Model.Builder builder, Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
                }

                protected void mergeModel_Subprojects(Model.Builder builder, Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
                }
            }).assembleModelInheritance(raw, parentData, this.request, this);
            List<Profile> parentActivePomProfiles = this.getActiveProfiles(parent.getProfiles(), childProfileActivationContext);
            Model injectedParentModel = DefaultModelBuilder.this.profileInjector.injectProfiles(parent, parentActivePomProfiles, this.request, this).withProfiles(List.of());
            return new ParentModelWithProfiles(injectedParentModel.withParent(null), parentActivePomProfiles);
        }

        private Model importDependencyManagement(Model model, Collection<String> importIds) {
            DependencyManagement depMgmt = model.getDependencyManagement();
            if (depMgmt == null) {
                return model;
            }
            String importing = model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
            importIds.add(importing);
            ArrayList<DependencyManagement> importMgmts = null;
            ArrayList deps = new ArrayList(depMgmt.getDependencies());
            Iterator it = deps.iterator();
            while (it.hasNext()) {
                Dependency dependency = (Dependency)it.next();
                if (!"pom".equals(dependency.getType()) || !DefaultModelBuilder.IMPORT.equals(dependency.getScope()) || "bom".equals(dependency.getType())) continue;
                it.remove();
                DependencyManagement importMgmt = this.loadDependencyManagement(dependency, importIds);
                if (importMgmt == null) continue;
                if (importMgmts == null) {
                    importMgmts = new ArrayList<DependencyManagement>();
                }
                importMgmts.add(importMgmt);
            }
            importIds.remove(importing);
            model = model.withDependencyManagement(model.getDependencyManagement().withDependencies(deps));
            return DefaultModelBuilder.this.dependencyManagementImporter.importManagement(model, importMgmts, this.request, this);
        }

        private DependencyManagement loadDependencyManagement(Dependency dependency, Collection<String> importIds) {
            DependencyManagement importMgmt;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            if (groupId == null || groupId.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.groupId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            if (artifactId == null || artifactId.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.artifactId' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            if (version == null || version.isEmpty()) {
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "'dependencyManagement.dependencies.dependency.version' for " + dependency.getManagementKey() + " is missing.", dependency.getLocation((Object)""));
                return null;
            }
            String imported = groupId + ":" + artifactId + ":" + version;
            if (importIds.contains(imported)) {
                StringBuilder message = new StringBuilder("The dependencies of type=pom and with scope=import form a cycle: ");
                for (String modelId : importIds) {
                    message.append(modelId).append(" -> ");
                }
                message.append(imported);
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, message.toString());
                return null;
            }
            Model importModel = this.cache(this.repositories, groupId, artifactId, version, null, DefaultModelBuilder.IMPORT, () -> this.doLoadDependencyManagement(dependency, groupId, artifactId, version, importIds));
            DependencyManagement dependencyManagement = importMgmt = importModel != null ? importModel.getDependencyManagement() : null;
            if (importMgmt == null) {
                importMgmt = DependencyManagement.newInstance();
            }
            List exclusions = dependency.getExclusions();
            if (importMgmt != null && !exclusions.isEmpty()) {
                List dependencies = importMgmt.getDependencies().stream().filter(candidate -> exclusions.stream().noneMatch(exclusion -> DefaultModelBuilder.this.match((Exclusion)exclusion, (Dependency)candidate))).map(candidate -> DefaultModelBuilder.addExclusions(candidate, exclusions)).collect(Collectors.toList());
                importMgmt = importMgmt.withDependencies(dependencies);
            }
            return importMgmt;
        }

        private Model doLoadDependencyManagement(Dependency dependency, String groupId, String artifactId, String version, Collection<String> importIds) {
            DefaultModelBuilderResult importResult;
            Path sourcePath;
            Path rootDirectory;
            ModelSource importSource;
            try {
                importSource = this.resolveReactorModel(groupId, artifactId, version);
                if (importSource == null) {
                    importSource = DefaultModelBuilder.this.modelResolver.resolveModel((Session)this.request.getSession(), this.repositories, dependency, new AtomicReference<Dependency>());
                }
            }
            catch (ModelBuilderException | ModelResolverException e) {
                StringBuilder buffer = new StringBuilder(256);
                buffer.append("Non-resolvable import POM");
                if (!DefaultModelBuilder.this.containsCoordinates(e.getMessage(), groupId, artifactId, version)) {
                    buffer.append(' ').append(ModelProblemUtils.toId(groupId, artifactId, version));
                }
                buffer.append(": ").append(e.getMessage());
                this.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, buffer.toString(), dependency.getLocation((Object)""), (Exception)e);
                return null;
            }
            try {
                rootDirectory = ((Session)this.request.getSession()).getRootDirectory();
            }
            catch (IllegalStateException e) {
                rootDirectory = null;
            }
            if (this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT && rootDirectory != null && (sourcePath = importSource.getPath()) != null && sourcePath.startsWith(rootDirectory)) {
                this.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "BOM imports from within reactor should be avoided", dependency.getLocation((Object)""));
            }
            try {
                ModelBuilderRequest importRequest = ModelBuilderRequest.builder().session((Session)this.request.getSession()).requestType(ModelBuilderRequest.RequestType.CONSUMER_DEPENDENCY).systemProperties(this.request.getSystemProperties()).userProperties(this.request.getUserProperties()).source(importSource).repositories(this.repositories).build();
                ModelBuilderSessionState modelBuilderSession = this.derive(importRequest);
                modelBuilderSession.buildEffectiveModel(importIds);
                importResult = modelBuilderSession.result;
            }
            catch (ModelBuilderException e) {
                return null;
            }
            Model importModel = importResult.getEffectiveModel();
            return importModel;
        }

        ModelSource resolveReactorModel(String groupId, String artifactId, String version) throws ModelBuilderException {
            Set<ModelSource> sources = this.mappedSources.get(new GAKey(groupId, artifactId));
            if (sources != null) {
                for (ModelSource source : sources) {
                    Model model = this.derive(source).readRawModel();
                    if (!Objects.equals(DefaultModelBuilder.getVersion(model), version)) continue;
                    return source;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T cache(List<RemoteRepository> repositories, String groupId, String artifactId, String version, String classifier, String tag, Supplier<T> supplier) {
            RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(this.session, this.request);
            try {
                RgavCacheKey r = new RgavCacheKey(this.session, trace.mvnTrace(), repositories, groupId, artifactId, version, classifier, tag);
                SourceResponse response = InternalSession.from(this.session).request(r, tr -> new SourceResponse((RgavCacheKey)tr, supplier.get()));
                Object t = response.response;
                return t;
            }
            finally {
                RequestTraceHelper.exit(trace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T cache(Source source, String tag, Supplier<T> supplier) throws ModelBuilderException {
            RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(this.session, this.request);
            try {
                SourceCacheKey r = new SourceCacheKey(this.session, trace.mvnTrace(), source, tag);
                SourceResponse response = InternalSession.from(this.session).request(r, tr -> new SourceResponse((SourceCacheKey)tr, supplier.get()));
                Object t = response.response;
                return t;
            }
            finally {
                RequestTraceHelper.exit(trace);
            }
        }

        boolean isBuildRequest() {
            return this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_PROJECT || this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_EFFECTIVE || this.request.getRequestType() == ModelBuilderRequest.RequestType.BUILD_CONSUMER;
        }

        boolean isBuildRequestWithActivation() {
            return this.request.getRequestType() != ModelBuilderRequest.RequestType.BUILD_CONSUMER;
        }

        private void replayRecordIntoContext(DefaultProfileActivationContext.Record cachedRecord, DefaultProfileActivationContext targetContext) {
            if (targetContext.record == null) {
                return;
            }
            DefaultProfileActivationContext.Record targetRecord = targetContext.record;
            cachedRecord.usedActiveProfiles.forEach(targetRecord.usedActiveProfiles::putIfAbsent);
            cachedRecord.usedInactiveProfiles.forEach(targetRecord.usedInactiveProfiles::putIfAbsent);
            cachedRecord.usedSystemProperties.forEach(targetRecord.usedSystemProperties::putIfAbsent);
            cachedRecord.usedUserProperties.forEach(targetRecord.usedUserProperties::putIfAbsent);
            cachedRecord.usedModelProperties.forEach(targetRecord.usedModelProperties::putIfAbsent);
            cachedRecord.usedModelInfos.forEach(targetRecord.usedModelInfos::putIfAbsent);
            cachedRecord.usedExists.forEach(targetRecord.usedExists::putIfAbsent);
        }

        private record ParentModelWithProfiles(Model model, List<Profile> activatedProfiles) {
        }
    }

    static class InterningTransformer
    implements XmlReaderRequest.Transformer {
        static final Set<String> DEFAULT_CONTEXTS = Set.of("groupId", "artifactId", "version", "namespaceUri", "packaging", "scope", "type", "classifier", "phase", "goal", "execution", "layout", "policy", "checksumPolicy", "updatePolicy", "modelVersion", "name", "url", "system", "distribution", "status", "connection", "developerConnection", "tag", "id", "inherited", "optional");
        private final Set<String> contexts;

        InterningTransformer() {
            this.contexts = DEFAULT_CONTEXTS;
        }

        InterningTransformer(Session session) {
            this.contexts = this.parseContextsFromSession(session);
        }

        private Set<String> parseContextsFromSession(Session session) {
            String contextsProperty = (String)session.getUserProperties().get("maven.modelBuilder.interns");
            if (contextsProperty == null) {
                contextsProperty = (String)session.getSystemProperties().get("maven.modelBuilder.interns");
            }
            if (contextsProperty == null || contextsProperty.trim().isEmpty()) {
                return DEFAULT_CONTEXTS;
            }
            return Arrays.stream(contextsProperty.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }

        public String transform(String input, String context) {
            return input != null && this.contexts.contains(context) ? input.intern() : input;
        }

        Set<String> getContexts() {
            return this.contexts;
        }
    }

    public static class SourceResponse<R extends Request<?>, T>
    implements Result<R> {
        private final R request;
        private final T response;

        SourceResponse(R request, T response) {
            this.request = request;
            this.response = response;
        }

        @Nonnull
        public R getRequest() {
            return this.request;
        }
    }

    public record SourceCacheKey(Session session, RequestTrace trace, Source source, String tag) implements Request<Session>,
    CacheMetadata
    {
        @Nonnull
        public Session getSession() {
            return this.session;
        }

        @Nullable
        public RequestTrace getTrace() {
            return this.trace;
        }

        public CacheRetention getCacheRetention() {
            CacheRetention cacheRetention;
            Source source = this.source;
            if (source instanceof CacheMetadata) {
                CacheMetadata cacheMetadata = (CacheMetadata)source;
                cacheRetention = cacheMetadata.getCacheRetention();
            } else {
                cacheRetention = null;
            }
            return cacheRetention;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SourceCacheKey)) return false;
            SourceCacheKey that = (SourceCacheKey)o;
            if (!Objects.equals(this.tag, that.tag)) return false;
            if (!Objects.equals(this.source, that.source)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.source, this.tag);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[location=" + this.source.getLocation() + ", tag=" + this.tag + ", path=" + String.valueOf(this.source.getPath()) + "]";
        }
    }

    public record RgavCacheKey(Session session, RequestTrace trace, List<RemoteRepository> repositories, String groupId, String artifactId, String version, String classifier, String tag) implements Request<Session>
    {
        @Nonnull
        public Session getSession() {
            return this.session;
        }

        @Nullable
        public RequestTrace getTrace() {
            return this.trace;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RgavCacheKey)) return false;
            RgavCacheKey that = (RgavCacheKey)o;
            if (!Objects.equals(this.tag, that.tag)) return false;
            if (!Objects.equals(this.groupId, that.groupId)) return false;
            if (!Objects.equals(this.version, that.version)) return false;
            if (!Objects.equals(this.artifactId, that.artifactId)) return false;
            if (!Objects.equals(this.classifier, that.classifier)) return false;
            if (!Objects.equals(this.repositories, that.repositories)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.repositories, this.groupId, this.artifactId, this.version, this.classifier, this.tag);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[").append("gav='");
            if (this.groupId != null) {
                sb.append(this.groupId);
            }
            sb.append(":");
            if (this.artifactId != null) {
                sb.append(this.artifactId);
            }
            sb.append(":");
            if (this.version != null) {
                sb.append(this.version);
            }
            sb.append(":");
            if (this.classifier != null) {
                sb.append(this.classifier);
            }
            sb.append("', tag='");
            sb.append(this.tag);
            sb.append("']");
            return sb.toString();
        }
    }

    record GAKey(String groupId, String artifactId) {
    }
}

