/*
 * Decompiled with CFR 0.152.
 */
package org.tullmann.taglets;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.HashMap;
import java.util.Map;
import org.tullmann.taglets.TagPrefs;

public abstract class ListTag
implements Taglet {
    private static final String LISTTYPE = "listtype";
    private static final String HEADER_TEXT = "header.text";
    private static final String TEXT_FGCOLOR = "text.color.fg";
    private static final String TEXT_BGCOLOR = "text.color.bg";
    private static final String TEXT_RELSIZE = "text.relsize";
    public static final ListType ORDERED_LIST = new ListType("ordered", "<ol>", "</ol>", "<li>", "</li>");
    public static final ListType UNORDERED_LIST = new ListType("unordered", "<ul>", "</ul>", "<li>", "</li>");
    public static final ListType TABLE_LIST = new ListType("table", "<table cellpadding=\"2\">", "</table>", "<tr>", "</tr>");
    public static final ListType VISIBLETABLE_LIST = new ListType("table", "<table BORDER=\"1\" CELLPADDING=\"2\">", "</table>", "<tr>", "</tr>");
    private final String tagName;
    protected final TagPrefs tagPrefs;

    protected void forceCustomDefaultPrefs(TagPrefs tagPrefs) throws Exception {
    }

    protected void forceColorPrefs(TagPrefs tagPrefs, String string) {
        tagPrefs.forcePref(string + ".color.fg", "-");
        tagPrefs.forcePref(string + ".color.bg", "-");
        tagPrefs.forcePref(string + ".relsize", "-");
    }

    private final void forceDefaultPrefs(String string, ListType listType) {
        try {
            this.tagPrefs.forcePref(LISTTYPE, listType.mapKey());
            this.tagPrefs.forcePref(HEADER_TEXT, string);
            this.forceColorPrefs(this.tagPrefs, "header");
            this.forceColorPrefs(this.tagPrefs, "text");
            this.forceCustomDefaultPrefs(this.tagPrefs);
            TagPrefs.flush();
        }
        catch (Exception exception) {
            System.err.println("(ignored) prefs exception: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
    }

    public static void register(Map map, ListTag listTag) {
        Taglet taglet = (Taglet)map.get(listTag.tagName);
        if (taglet != null) {
            System.err.println("Warning(ListTag): replacing taglet " + taglet + " with " + listTag + ".");
            map.remove(listTag.tagName);
        }
        map.put(listTag.tagName, listTag);
    }

    public String getName() {
        return this.tagName;
    }

    public boolean isInlineTag() {
        return false;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    protected void formatText(StringBuffer stringBuffer, String string, String string2) {
        String string3 = this.tagPrefs.getPref(string2 + ".color.fg");
        String string4 = this.tagPrefs.getPref(string2 + ".color.bg");
        String string5 = this.tagPrefs.getPref(string2 + ".relsize");
        boolean bl = false;
        if (!string4.equals("-")) {
            stringBuffer.append("<table><tr><td bgcolor=\"").append(string4).append("\">");
            bl = true;
        }
        if (string3.equals("-") && string5.equals("-")) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("<font ");
            if (!string3.equals("-")) {
                stringBuffer.append("color=\"").append(string3).append("\" ");
            }
            if (!string5.equals("-")) {
                stringBuffer.append("size=\"").append(string5).append("\" ");
            }
            stringBuffer.append(">").append(string).append("</font>");
        }
        if (bl) {
            stringBuffer.append("</td></tr></table>");
        }
    }

    protected void parseTagText(StringBuffer stringBuffer, String string, boolean bl) {
        String string2 = this.tagPrefs.getPref(LISTTYPE);
        ListType listType = ListType.lookup(string2);
        boolean bl2 = false;
        if (bl && listType == TABLE_LIST) {
            bl2 = true;
        }
        if (bl2) {
            stringBuffer.append("<td>");
        }
        this.formatText(stringBuffer, string, "text");
        if (bl2) {
            stringBuffer.append("</td>\n");
        }
    }

    protected void emitCustomHeader(StringBuffer stringBuffer, boolean bl) {
    }

    protected void emitCustomFooter(StringBuffer stringBuffer, boolean bl) {
    }

    protected void emitHeader(StringBuffer stringBuffer, boolean bl) {
        String string = this.tagPrefs.getPref(HEADER_TEXT);
        String string2 = this.tagPrefs.getPref(LISTTYPE);
        ListType listType = ListType.lookup(string2);
        stringBuffer.append("<dt><b>");
        this.formatText(stringBuffer, string, "header");
        stringBuffer.append("</b></dt>").append("<dd>\n");
        if (bl) {
            stringBuffer.append(listType.getStartHtml());
        }
        stringBuffer.append("\n");
        this.emitCustomHeader(stringBuffer, bl);
    }

    protected void emitTag(Tag tag, StringBuffer stringBuffer, boolean bl) {
        String string = this.tagPrefs.getPref(LISTTYPE);
        ListType listType = ListType.lookup(string);
        if (bl) {
            stringBuffer.append(listType.getEntryStartHtml());
        }
        this.parseTagText(stringBuffer, tag.text(), bl);
        if (bl) {
            stringBuffer.append(listType.getEntryEndHtml());
        }
    }

    protected void emitFooter(StringBuffer stringBuffer, boolean bl) {
        String string = this.tagPrefs.getPref(LISTTYPE);
        ListType listType = ListType.lookup(string);
        this.emitCustomFooter(stringBuffer, bl);
        if (bl) {
            stringBuffer.append(listType.getEndHtml());
        }
        stringBuffer.append("</dd>\n");
    }

    protected void startingTags() {
    }

    protected void endingTags(StringBuffer stringBuffer) {
    }

    public String toString(Tag tag) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        this.startingTags();
        this.emitHeader(stringBuffer, false);
        this.emitTag(tag, stringBuffer, false);
        this.emitFooter(stringBuffer, false);
        this.endingTags(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString(Tag[] tagArray) {
        if (tagArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200 + 800 * tagArray.length);
        this.startingTags();
        this.emitHeader(stringBuffer, true);
        int n = 0;
        while (n < tagArray.length) {
            this.emitTag(tagArray[n], stringBuffer, true);
            ++n;
        }
        this.emitFooter(stringBuffer, true);
        this.endingTags(stringBuffer);
        return stringBuffer.toString();
    }

    public ListTag(String string, String string2, ListType listType) {
        this(string, string, string2, listType);
    }

    public ListTag(String string, String string2, String string3, ListType listType) {
        this.tagName = string;
        this.tagPrefs = new TagPrefs(string2);
        this.forceDefaultPrefs(string3, listType);
    }

    private static class ListType {
        private static final HashMap nameToType = new HashMap(5);
        private final String type;
        private final String s;
        private final String e;
        private final String entryS;
        private final String entryE;

        public String getStartHtml() {
            return this.s;
        }

        public String getEndHtml() {
            return this.e;
        }

        public String getEntryStartHtml() {
            return this.entryS;
        }

        public String getEntryEndHtml() {
            return this.entryE;
        }

        public String mapKey() {
            return this.type;
        }

        public static ListType lookup(String string) {
            ListType listType = (ListType)nameToType.get(string);
            return listType;
        }

        ListType(String string, String string2, String string3, String string4, String string5) {
            this.type = string;
            this.s = string2;
            this.e = string3;
            this.entryS = string4;
            this.entryE = string5;
            nameToType.put(this.mapKey(), this);
        }
    }
}

