/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.mylyn.util.commands;

import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.netbeans.modules.mylyn.util.internal.CommandsAccessor;

/**
 *
 * @author Ondrej Vrabec
 */
class CommandsAccessorImpl extends CommandsAccessor {

    @Override
    public CommandFactory getCommandFactory (TaskList taskList, TaskDataManager taskDataManager,
            TaskRepositoryManager taskRepositoryManager, RepositoryModel repositoryModel) {
        return new CommandFactory(taskList, taskDataManager, taskRepositoryManager, repositoryModel);
    }
    
}
