/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.OkResult;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class SyncFlowVersions
extends AbstractNiFiRegistryCommand<StringResult> {
    public SyncFlowVersions() {
        super("sync-flow-versions", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Syncs the versions of a flow to another flow, which could be in a different bucket or registry. This command assumes the intent is to maintain the exact version history across the two flows. The list of versions from the source flow will be compared to the destination flow, and any versions not present will be added. If --" + CommandOption.SRC_PROPS.getLongName() + " is not provided then the source registry will be assumed to be the same as the destination registry.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.SRC_PROPS.createOption());
        this.addOption(CommandOption.SRC_FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        VersionedFlow destFlow;
        VersionedFlow srcFlow;
        String srcPropsValue = this.getArg(properties, CommandOption.SRC_PROPS);
        String srcFlowId = this.getRequiredArg(properties, CommandOption.SRC_FLOW_ID);
        String destFlowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        NiFiRegistryClient srcClient = this.getSourceClient(client, srcPropsValue);
        try {
            srcFlow = srcClient.getFlowClient().get(srcFlowId);
        }
        catch (Exception e) {
            throw new NiFiRegistryException("Error retrieving source flow : " + e.getMessage(), (Throwable)e);
        }
        try {
            destFlow = client.getFlowClient().get(destFlowId);
        }
        catch (Exception e) {
            throw new NiFiRegistryException("Error retrieving destination flow : " + e.getMessage(), (Throwable)e);
        }
        List<Integer> srcVersions = this.getVersions(srcClient, srcFlow.getIdentifier());
        List<Integer> destVersions = this.getVersions(client, destFlow.getIdentifier());
        if (destVersions.size() > srcVersions.size()) {
            throw new NiFiRegistryException("Destination flow has more versions than source flow");
        }
        srcVersions.removeAll(destVersions);
        if (srcVersions.isEmpty()) {
            if (this.getContext().isInteractive()) {
                this.println();
                this.println("Source and destination already in sync");
            }
            return new OkResult(this.getContext().isInteractive());
        }
        Collections.sort(srcVersions);
        for (Integer srcVersion : srcVersions) {
            VersionedFlowSnapshot srcFlowSnapshot = srcClient.getFlowSnapshotClient().get(srcFlowId, srcVersion.intValue());
            srcFlowSnapshot.setFlow(null);
            srcFlowSnapshot.setBucket(null);
            VersionedFlowSnapshotMetadata destMetadata = new VersionedFlowSnapshotMetadata();
            destMetadata.setBucketIdentifier(destFlow.getBucketIdentifier());
            destMetadata.setFlowIdentifier(destFlowId);
            destMetadata.setVersion(srcVersion.intValue());
            destMetadata.setComments(srcFlowSnapshot.getSnapshotMetadata().getComments());
            srcFlowSnapshot.setSnapshotMetadata(destMetadata);
            client.getFlowSnapshotClient().create(srcFlowSnapshot);
            if (!this.getContext().isInteractive()) continue;
            this.println();
            this.println("Synced version " + srcVersion);
        }
        return new OkResult(this.getContext().isInteractive());
    }
}

