/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MappingReader {
    MappingReader() {
    }

    static Map<Actions, Map<String, List<String>>> parseMapping(Element mappingElement) {
        Element field;
        int j;
        HashMap<String, List<String>> fieldsMap;
        NodeList fieldList;
        HashMap<Actions, Map<String, List<String>>> parsedMapping = new HashMap<Actions, Map<String, List<String>>>();
        Node node = mappingElement.getElementsByTagName("rename").item(0);
        if (node != null) {
            fieldList = ((Element)node).getElementsByTagName("field");
            fieldsMap = new HashMap<String, List<String>>();
            for (j = 0; j < fieldList.getLength(); ++j) {
                field = (Element)fieldList.item(j);
                fieldsMap.put(field.getAttribute("source"), Collections.singletonList(field.getAttribute("dest")));
            }
            parsedMapping.put(Actions.RENAME, fieldsMap);
        }
        if ((node = mappingElement.getElementsByTagName("copy").item(0)) != null) {
            fieldList = ((Element)node).getElementsByTagName("field");
            fieldsMap = new HashMap();
            for (j = 0; j < fieldList.getLength(); ++j) {
                field = (Element)fieldList.item(j);
                fieldsMap.put(field.getAttribute("source"), Arrays.asList(field.getAttribute("dest").split(",")));
            }
            parsedMapping.put(Actions.COPY, fieldsMap);
        }
        if ((node = mappingElement.getElementsByTagName("remove").item(0)) != null) {
            fieldList = ((Element)node).getElementsByTagName("field");
            fieldsMap = new HashMap();
            for (j = 0; j < fieldList.getLength(); ++j) {
                field = (Element)fieldList.item(j);
                fieldsMap.put(field.getAttribute("source"), null);
            }
            parsedMapping.put(Actions.REMOVE, fieldsMap);
        }
        return parsedMapping;
    }

    static enum Actions {
        RENAME,
        COPY,
        REMOVE;

    }
}

