/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.browser.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum BrowserCommandId {
    OPENTABSEARCH("openTabSearch"),
    CLOSETABSEARCH("closeTabSearch");

    private String value;

    private BrowserCommandId(String value) {
        this.value = value;
    }

    public static BrowserCommandId fromString(String s) {
        return Arrays.stream(BrowserCommandId.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within BrowserCommandId "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static BrowserCommandId fromJson(JsonInput input) {
        return BrowserCommandId.fromString(input.nextString());
    }
}

