/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.metadata;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;

public class MetadataIndexer
implements IndexingFilter {
    private Configuration conf;
    private String[] dbFieldnames;
    private String[] parseFieldnames;
    private String[] contentFieldnames;
    private String separator;
    private Set<String> mvFields;
    private static final String db_CONF_PROPERTY = "index.db.md";
    private static final String parse_CONF_PROPERTY = "index.parse.md";
    private static final String content_CONF_PROPERTY = "index.content.md";
    private static final String separator_CONF_PROPERTY = "index.metadata.separator";
    private static final String mvfields_CONF_PROPERTY = "index.metadata.multivalued.fields";

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        if (doc == null) {
            return doc;
        }
        if (this.dbFieldnames != null) {
            for (String metatag : this.dbFieldnames) {
                Writable metadata = datum.getMetaData().get((Object)new Text(metatag));
                if (metadata == null) continue;
                this.add(doc, metatag, metadata.toString());
            }
        }
        if (this.parseFieldnames != null) {
            for (String metatag : this.parseFieldnames) {
                for (String value : parse.getData().getParseMeta().getValues(metatag)) {
                    if (value == null) continue;
                    this.add(doc, metatag, value);
                }
            }
        }
        if (this.contentFieldnames != null) {
            for (String metatag : this.contentFieldnames) {
                for (String value : parse.getData().getContentMeta().getValues(metatag)) {
                    if (value == null) continue;
                    this.add(doc, metatag, value);
                }
            }
        }
        return doc;
    }

    protected void add(NutchDocument doc, String key, String value) {
        if (this.separator == null || value.indexOf(this.separator) == -1 || !this.mvFields.contains(key)) {
            if (!(value = value.trim()).isEmpty()) {
                doc.add(key, (Object)value);
            }
        } else {
            String[] parts;
            for (String part : parts = value.split(this.separator)) {
                if ((part = part.trim()).isEmpty()) continue;
                doc.add(key, (Object)part);
            }
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.dbFieldnames = conf.getStrings(db_CONF_PROPERTY);
        this.parseFieldnames = conf.getStrings(parse_CONF_PROPERTY);
        this.contentFieldnames = conf.getStrings(content_CONF_PROPERTY);
        this.separator = conf.get(separator_CONF_PROPERTY, null);
        this.mvFields = new HashSet<String>(Arrays.asList(conf.getStrings(mvfields_CONF_PROPERTY, new String[0])));
    }

    public Configuration getConf() {
        return this.conf;
    }
}

