/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.applicationcache.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v85.applicationcache.model.ApplicationCacheResource;
import org.openqa.selenium.json.JsonInput;

public class ApplicationCache {
    private final String manifestURL;
    private final Number size;
    private final Number creationTime;
    private final Number updateTime;
    private final List<ApplicationCacheResource> resources;

    public ApplicationCache(String manifestURL, Number size, Number creationTime, Number updateTime, List<ApplicationCacheResource> resources) {
        this.manifestURL = Objects.requireNonNull(manifestURL, "manifestURL is required");
        this.size = Objects.requireNonNull(size, "size is required");
        this.creationTime = Objects.requireNonNull(creationTime, "creationTime is required");
        this.updateTime = Objects.requireNonNull(updateTime, "updateTime is required");
        this.resources = Objects.requireNonNull(resources, "resources is required");
    }

    public String getManifestURL() {
        return this.manifestURL;
    }

    public Number getSize() {
        return this.size;
    }

    public Number getCreationTime() {
        return this.creationTime;
    }

    public Number getUpdateTime() {
        return this.updateTime;
    }

    public List<ApplicationCacheResource> getResources() {
        return this.resources;
    }

    private static ApplicationCache fromJson(JsonInput input) {
        String manifestURL = null;
        Number size = 0;
        Number creationTime = 0;
        Number updateTime = 0;
        List resources = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "manifestURL": {
                    manifestURL = input.nextString();
                    continue block14;
                }
                case "size": {
                    size = input.nextNumber();
                    continue block14;
                }
                case "creationTime": {
                    creationTime = input.nextNumber();
                    continue block14;
                }
                case "updateTime": {
                    updateTime = input.nextNumber();
                    continue block14;
                }
                case "resources": {
                    resources = (List)input.read(new TypeToken<List<ApplicationCacheResource>>(){}.getType());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ApplicationCache(manifestURL, size, creationTime, updateTime, resources);
    }
}

