/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.ftp.Client;
import org.apache.nutch.protocol.ftp.Ftp;
import org.apache.nutch.protocol.ftp.FtpException;
import org.apache.nutch.protocol.ftp.FtpExceptionBadSystResponse;
import org.apache.nutch.protocol.ftp.FtpExceptionCanNotHaveDataConnection;
import org.apache.nutch.protocol.ftp.FtpExceptionControlClosedByForcedDataClose;
import org.apache.nutch.protocol.ftp.FtpExceptionUnknownForcedDataClose;
import org.apache.nutch.protocol.ftp.PrintCommandListener;

public class FtpResponse {
    private String orig;
    private String base;
    private byte[] content;
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private int code;
    private Metadata headers = new Metadata();
    private final Ftp ftp;
    private Configuration conf;

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public byte[] getContent() {
        return this.content;
    }

    public Content toContent() {
        return new Content(this.orig, this.base, this.content != null ? this.content : EMPTY_CONTENT, this.getHeader("Content-Type"), this.headers, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public FtpResponse(URL url, CrawlDatum datum, Ftp ftp, Configuration conf) throws FtpException, IOException {
        super();
        this.orig = url.toString();
        this.base = url.toString();
        this.ftp = ftp;
        this.conf = conf;
        if (!"ftp".equals(url.getProtocol())) {
            throw new FtpException("Not a ftp url: " + String.valueOf(url));
        }
        if (url.getQuery() != null) {
            Ftp.LOG.warn("ftp:// URL may not include a query (query part ignored): {}", (Object)url);
        }
        path = url.getPath().isEmpty() != false ? "/" : url.getPath();
        try {
            if (ftp.followTalk) {
                Ftp.LOG.info("fetching {}", (Object)url);
            } else {
                Ftp.LOG.trace("fetching {}", (Object)url);
            }
            addr = InetAddress.getByName(url.getHost());
            if (addr != null && conf.getBoolean("store.ip.address", false)) {
                this.headers.add("_ip_", addr.getHostAddress());
            }
            if (ftp.client != null && ftp.keepConnection && ftp.renewalTime < System.currentTimeMillis()) {
                Ftp.LOG.info("delete client because idled too long");
                ftp.client = null;
            }
            if (ftp.client == null) {
                if (ftp.followTalk) {
                    Ftp.LOG.info("start client");
                }
                ftp.client = new Client();
                ftp.client.setDefaultTimeout(ftp.timeout);
                ftp.client.setDataTimeout(ftp.timeout);
                if (ftp.followTalk) {
                    ftp.client.addProtocolCommandListener(new PrintCommandListener(Ftp.LOG));
                }
            }
            if (ftp.client.isConnected() && !addr.equals(remoteAddress = ftp.client.getRemoteAddress())) {
                if (ftp.followTalk) {
                    Ftp.LOG.info("disconnect from {} before connect to {}", (Object)remoteAddress, (Object)addr);
                }
                ftp.client.logout();
                ftp.client.disconnect();
            }
            if (!ftp.client.isConnected()) {
                if (ftp.followTalk) {
                    Ftp.LOG.info("connect to {}", (Object)addr);
                }
                ftp.client.connect(addr);
                if (!FTPReply.isPositiveCompletion((int)ftp.client.getReplyCode())) {
                    ftp.client.disconnect();
                    Ftp.LOG.warn("ftp.client.connect() failed: {} {}", (Object)addr, (Object)ftp.client.getReplyString());
                    this.code = 500;
                    return;
                }
                if (ftp.followTalk) {
                    Ftp.LOG.info("log into {}", (Object)addr);
                }
                if (!ftp.client.login(ftp.userName, ftp.passWord)) {
                    ftp.client.disconnect();
                    Ftp.LOG.warn("ftp.client.login() failed: {}", (Object)addr);
                    this.code = 401;
                    return;
                }
                if (!ftp.client.setFileType(2)) {
                    ftp.client.logout();
                    ftp.client.disconnect();
                    Ftp.LOG.warn("ftp.client.setFileType() failed: {}", (Object)addr);
                    this.code = 500;
                    return;
                }
                if (ftp.followTalk) {
                    Ftp.LOG.info("set parser for {}", (Object)addr);
                }
                try {
                    ftp.parser = null;
                    parserKey = ftp.client.getSystemName();
                    if (parserKey.startsWith("UNKNOWN Type: L8")) {
                        parserKey = "UNIX Type: L8";
                    }
                    ftp.parser = new DefaultFTPFileEntryParserFactory().createFileEntryParser(parserKey);
                }
                catch (FtpExceptionBadSystResponse e) {
                    Ftp.LOG.warn("ftp.client.getSystemName() failed: {} ", (Object)addr, (Object)e);
                    ftp.parser = null;
                    return ftp.parser;
                }
                catch (ParserInitializationException e) {
                    Ftp.LOG.warn("createFileEntryParser() failed: {} ", (Object)addr, (Object)e);
                    ftp.parser = null;
                    return ftp.parser;
                }
                finally {
                    if (ftp.parser != null) ** GOTO lbl87
                    Ftp.LOG.warn("ftp.parser is null: {}", (Object)addr);
                    ftp.client.logout();
                    ftp.client.disconnect();
                    this.code = 500;
                    return;
                }
            } else if (ftp.followTalk) {
                Ftp.LOG.info("use existing connection");
            }
lbl87:
            // 5 sources

            this.content = null;
            if ((path = URLDecoder.decode(path, "UTF-8")).endsWith("/")) {
                this.getDirAsHttpResponse(path, datum.getModifiedTime());
            } else {
                this.getFileAsHttpResponse(path, datum.getModifiedTime());
            }
            if (ftp.client != null && ftp.keepConnection) {
                ftp.renewalTime = System.currentTimeMillis() + (long)(ftp.timeout < ftp.serverTimeout ? ftp.timeout : ftp.serverTimeout);
                if (ftp.followTalk) {
                    Ftp.LOG.info("reset renewalTime to {}", (Object)HttpDateFormat.toString((long)ftp.renewalTime));
                }
            }
            if (ftp.client != null && !ftp.keepConnection) {
                if (ftp.followTalk) {
                    Ftp.LOG.info("disconnect from {}", (Object)addr);
                }
                ftp.client.logout();
                ftp.client.disconnect();
            }
        }
        catch (Exception e) {
            Ftp.LOG.warn("Error: ", (Throwable)e);
            if (ftp.followTalk) {
                Ftp.LOG.info("delete client due to exception");
            }
            ftp.client = null;
            throw new FtpException(e);
        }
    }

    private void getFileAsHttpResponse(String path, long lastModified) throws IOException {
        ByteArrayOutputStream os = null;
        LinkedList<FTPFile> list = null;
        try {
            list = new LinkedList<FTPFile>();
            this.ftp.client.retrieveList(path, list, this.ftp.maxContentLength, this.ftp.parser);
            FTPFile ftpFile = (FTPFile)list.get(0);
            this.headers.set("Content-Length", Long.valueOf(ftpFile.getSize()).toString());
            this.headers.set("Last-Modified", HttpDateFormat.toString((Calendar)ftpFile.getTimestamp()));
            if (ftpFile.getTimestamp().getTimeInMillis() <= lastModified) {
                this.code = 304;
                return;
            }
            os = new ByteArrayOutputStream(this.ftp.getBufferSize());
            this.ftp.client.retrieveFile(path, os, this.ftp.maxContentLength);
            this.content = os.toByteArray();
            this.code = 200;
        }
        catch (FtpExceptionControlClosedByForcedDataClose e) {
            if (this.ftp.followTalk) {
                Ftp.LOG.info("delete client because server cut off control channel: ", (Throwable)((Object)e));
            }
            this.ftp.client = null;
            if (os == null) {
                Ftp.LOG.warn("Please try larger maxContentLength for ftp.client.retrieveList(). ", (Throwable)((Object)e));
                this.code = 400;
                return;
            }
            FTPFile ftpFile = (FTPFile)list.get(0);
            this.headers.set("Content-Length", Long.valueOf(ftpFile.getSize()).toString());
            this.headers.set("Last-Modified", HttpDateFormat.toString((Calendar)ftpFile.getTimestamp()));
            this.content = os.toByteArray();
            if (ftpFile.getTimestamp().getTimeInMillis() <= lastModified) {
                this.code = 304;
                return;
            }
            this.code = 200;
        }
        catch (FtpExceptionCanNotHaveDataConnection e) {
            if (FTPReply.isPositiveCompletion((int)this.ftp.client.cwd(path))) {
                this.headers.set("Location", path + "/");
                this.code = 300;
            } else {
                this.code = 404;
            }
        }
        catch (FtpExceptionUnknownForcedDataClose e) {
            Ftp.LOG.warn("Unrecognized reply after forced close of data channel. If this is acceptable, please modify Client.java accordingly. ", (Throwable)((Object)e));
            this.code = 400;
        }
    }

    private void getDirAsHttpResponse(String path, long lastModified) throws IOException {
        LinkedList<FTPFile> list = new LinkedList<FTPFile>();
        try {
            if (!FTPReply.isPositiveCompletion((int)this.ftp.client.cwd(path))) {
                this.code = 404;
                return;
            }
            this.ftp.client.retrieveList(null, list, this.ftp.maxContentLength, this.ftp.parser);
            this.content = this.list2html(list, path, !"/".equals(path));
            this.headers.set("Content-Length", Integer.valueOf(this.content.length).toString());
            this.headers.set("Content-Type", "text/html");
            this.code = 200;
        }
        catch (FtpExceptionControlClosedByForcedDataClose e) {
            if (this.ftp.followTalk) {
                Ftp.LOG.info("delete client because server cut off control channel: ", (Throwable)((Object)e));
            }
            this.ftp.client = null;
            this.content = this.list2html(list, path, !"/".equals(path));
            this.headers.set("Content-Length", Integer.valueOf(this.content.length).toString());
            this.headers.set("Content-Type", "text/html");
            this.code = 200;
        }
        catch (FtpExceptionUnknownForcedDataClose e) {
            Ftp.LOG.warn("Unrecognized reply after forced close of data channel. If this is acceptable, please modify Client.java accordingly. ", (Throwable)((Object)e));
            this.code = 400;
        }
        catch (FtpExceptionCanNotHaveDataConnection e) {
            Ftp.LOG.warn("{}", (Throwable)((Object)e));
            this.code = 500;
        }
    }

    private byte[] list2html(List<FTPFile> list, String path, boolean includeDotDot) {
        StringBuffer x = new StringBuffer("<html><head>");
        x.append("<title>Index of " + path + "</title></head>\n");
        x.append("<body><h1>Index of " + path + "</h1><pre>\n");
        if (includeDotDot) {
            x.append("<a href='../'>../</a>\t-\t-\t-\n");
        }
        for (int i = 0; i < list.size(); ++i) {
            FTPFile f = list.get(i);
            String name = f.getName();
            String time = HttpDateFormat.toString((Calendar)f.getTimestamp());
            if (f.isDirectory()) {
                if (name.equals(".") || name.equals("..")) continue;
                x.append("<a href='" + name + "/'>" + name + "/</a>\t");
                x.append(time + "\t-\n");
                continue;
            }
            if (!f.isFile()) continue;
            x.append("<a href='" + name + "'>" + name + "</a>\t");
            x.append(time + "\t" + f.getSize() + "\n");
        }
        x.append("</pre></body></html>\n");
        return new String(x).getBytes();
    }
}

