/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.ignoreexempt;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLExemptionFilter;
import org.apache.nutch.urlfilter.regex.RegexURLFilter;
import org.apache.nutch.util.NutchConfiguration;

public class ExemptionUrlFilter
extends RegexURLFilter
implements URLExemptionFilter {
    public static final String DB_IGNORE_EXTERNAL_EXEMPTIONS_FILE = "db.ignore.external.exemptions.file";
    private List<Pattern> exemptions;

    public List<Pattern> getExemptions() {
        return this.exemptions;
    }

    public boolean filter(String fromUrl, String toUrl) {
        return this.filter(toUrl) != null;
    }

    protected Reader getRulesReader(Configuration conf) throws IOException {
        String fileRules = conf.get(DB_IGNORE_EXTERNAL_EXEMPTIONS_FILE);
        return conf.getConfResourceAsReader(fileRules);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Error: Invalid Args");
            System.out.println("Usage: " + ExemptionUrlFilter.class.getName() + " <url>");
            return;
        }
        String url = args[0];
        ExemptionUrlFilter instance = new ExemptionUrlFilter();
        instance.setConf(NutchConfiguration.create());
        System.out.println(instance.filter(null, url));
    }
}

