/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DocumentSuggesterOptions;
import com.amazonaws.services.cloudsearchv2.model.Suggester;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DefineSuggesterRequestMarshaller
implements Marshaller<Request<DefineSuggesterRequest>, DefineSuggesterRequest> {
    public Request<DefineSuggesterRequest> marshall(DefineSuggesterRequest defineSuggesterRequest) {
        Suggester suggesterSuggester;
        if (defineSuggesterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineSuggesterRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineSuggester");
        request.addParameter("Version", "2013-01-01");
        if (defineSuggesterRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineSuggesterRequest.getDomainName()));
        }
        if ((suggesterSuggester = defineSuggesterRequest.getSuggester()) != null) {
            DocumentSuggesterOptions documentSuggesterOptionsDocumentSuggesterOptions;
            if (suggesterSuggester.getSuggesterName() != null) {
                request.addParameter("Suggester.SuggesterName", StringUtils.fromString((String)suggesterSuggester.getSuggesterName()));
            }
            if ((documentSuggesterOptionsDocumentSuggesterOptions = suggesterSuggester.getDocumentSuggesterOptions()) != null) {
                if (documentSuggesterOptionsDocumentSuggesterOptions.getSourceField() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SourceField", StringUtils.fromString((String)documentSuggesterOptionsDocumentSuggesterOptions.getSourceField()));
                }
                if (documentSuggesterOptionsDocumentSuggesterOptions.getFuzzyMatching() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.FuzzyMatching", StringUtils.fromString((String)documentSuggesterOptionsDocumentSuggesterOptions.getFuzzyMatching()));
                }
                if (documentSuggesterOptionsDocumentSuggesterOptions.getSortExpression() != null) {
                    request.addParameter("Suggester.DocumentSuggesterOptions.SortExpression", StringUtils.fromString((String)documentSuggesterOptionsDocumentSuggesterOptions.getSortExpression()));
                }
            }
        }
        return request;
    }
}

