/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.http.HttpMessageParser;
import org.archive.format.http.HttpParseException;
import org.archive.format.http.HttpResponseMessage;
import org.archive.format.http.HttpResponseMessageObserver;

public class HttpResponseMessageParser
extends HttpMessageParser {
    public int maxBytes = 131072;
    public boolean strict = false;

    public HttpResponseMessage parseMessage(InputStream is) throws HttpParseException, IOException {
        HttpResponseMessage message = new HttpResponseMessage();
        this.parse(is, message);
        return message;
    }

    public int parse(InputStream is, HttpResponseMessageObserver obs) throws HttpParseException, IOException {
        byte[] buf = new byte[this.maxBytes];
        for (int bytesRead = 0; bytesRead < this.maxBytes; ++bytesRead) {
            byte b;
            int i = is.read();
            if (i == -1) {
                if (this.strict) {
                    throw new HttpParseException("EOF before CRLF");
                }
                obs.messageCorrupt();
                return bytesRead;
            }
            if (i > 127) {
                if (this.strict) {
                    throw new HttpParseException("Non ASCII byte in message");
                }
                obs.messageCorrupt();
                return bytesRead;
            }
            buf[bytesRead] = b = (byte)(i & 0xFF);
            if (b != 10) continue;
            return this.parse(buf, bytesRead, obs);
        }
        throw new HttpParseException("Response Message too long");
    }

    public int parse(byte[] buf, int len, HttpResponseMessageObserver obs) throws HttpParseException, IOException {
        return this.strict ? this.parseStrict(buf, len, obs) : this.parseLax(buf, len, obs);
    }

    public int parseStrict(byte[] buf, int len, HttpResponseMessageObserver obs) throws HttpParseException, IOException {
        int idx;
        if (buf[len - 1] != 13) {
            obs.messageCorrupt();
            throw new HttpParseException("Response Message missing CRLF");
        }
        int version = 0;
        int status = 0;
        String reason = "UNK";
        int vs = 0;
        int vl = -1;
        int ss = -1;
        int sl = -1;
        for (idx = 0; idx < len; ++idx) {
            if (buf[idx] != 32) {
                if (ss == -1) {
                    ++vl;
                    continue;
                }
                ++vs;
                continue;
            }
            if (ss != -1) break;
            ss = idx + 1;
        }
        if (idx == len) {
            obs.messageCorrupt();
            throw new HttpParseException("Response Message Missing Fields");
        }
        version = this.parseVersionStrict(buf, vs, vl);
        status = this.parseStatusStrict(buf, ss, sl);
        reason = new String(buf, idx + 1, len - idx - 1);
        obs.messageParsed(version, status, reason, len);
        return len;
    }

    private int parseLax(byte[] buf, int len, HttpResponseMessageObserver obs) throws HttpParseException, IOException {
        int version = 0;
        int status = 0;
        String reason = "UNK";
        int idx = 0;
        int vs = -1;
        int vl = 0;
        int ss = -1;
        int sl = 0;
        int bufferEnd = len - 1;
        if (len > 2 && buf[len - 2] == 13) {
            --bufferEnd;
        }
        while (idx < bufferEnd && buf[idx] == 32) {
            ++idx;
        }
        vs = idx;
        while (idx < bufferEnd) {
            if (buf[idx] != 32) {
                if (ss == -1) {
                    ++vl;
                } else {
                    ++sl;
                }
            } else {
                if (ss != -1) break;
                ss = idx + 1;
            }
            ++idx;
        }
        if (idx < bufferEnd) {
            int reasonLen;
            version = this.parseVersionLax(buf, vs, vl);
            status = this.parseStatusLax(buf, ss, sl);
            if ((reasonLen = bufferEnd - ++idx) > 0) {
                reason = new String(buf, idx, reasonLen);
            }
        } else {
            if (vl > 0) {
                version = this.parseVersionLax(buf, vs, vl);
            }
            if (sl > 0) {
                status = this.parseStatusLax(buf, ss, sl);
            }
        }
        obs.messageParsed(version, status, reason, len);
        return len;
    }

    private int parseStatusStrict(byte[] buf, int start, int len) throws HttpParseException {
        int status = 0;
        try {
            int testStatus = Integer.valueOf(new String(buf, start, len, UTF8));
            if (testStatus >= 100 && testStatus < 600) {
                status = testStatus;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (status == -1) {
            throw new HttpParseException("Bad status code in Response Message");
        }
        return status;
    }

    private int parseStatusLax(byte[] buf, int start, int len) throws HttpParseException {
        int status = 0;
        try {
            int testStatus = Integer.valueOf(new String(buf, start, len, UTF8));
            if (testStatus >= 100 && testStatus < 600) {
                status = testStatus;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return status;
    }
}

