/*
 * Decompiled with CFR 0.152.
 */
package org.archive.streamcontext;

import java.io.IOException;
import java.io.InputStream;
import org.archive.streamcontext.Stream;
import org.archive.util.io.PushBackOneByteInputStream;

public class StreamWrappedInputStream
extends InputStream
implements PushBackOneByteInputStream {
    private static final long UNMARKED = -1L;
    private long markPos;
    private Stream stream;
    private boolean closeOnClose;

    public StreamWrappedInputStream(Stream stream) {
        this.stream = stream;
        this.markPos = -1L;
        this.closeOnClose = false;
    }

    public void setCloseOnClose(boolean closeOnClose) {
        this.closeOnClose = closeOnClose;
    }

    public boolean isCloseOnClose() {
        return this.closeOnClose;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closeOnClose) {
            this.stream.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPos = this.stream.getOffset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markPos == -1L) {
            throw new IOException("reset without mark() unsupported");
        }
        this.stream.setOffset(this.markPos);
        this.markPos = -1L;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int amt = this.stream.read(b, 0, 1);
        if (amt == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long startOffset = this.stream.getOffset();
        long gotOffset = this.stream.setOffset(startOffset + n);
        return gotOffset - startOffset;
    }

    @Override
    public void pushback() throws IOException {
        this.stream.setOffset(this.stream.getOffset() - 1L);
    }
}

