/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.more;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.util.MimeUtil;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private MimeUtil MIME;
    private Tika tika = new Tika();
    private HashMap<String, String> mimeMap = null;
    private boolean mapMimes = false;
    private String mapFieldName;
    private String[] defaultDateStyles = new String[]{"EEE MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE MMM dd HH:mm:ss zzz yyyy", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE,dd MMM yyyy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:sszzz", "EEE, dd MMM yyyy HH:mm:ss", "EEE, dd-MMM-yy HH:mm:ss zzz", "yyyy/MM/dd HH:mm:ss.SSS zzz", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss zzz", "yyyy/MM/dd", "yyyy.MM.dd HH:mm:ss", "yyyy-MM-dd HH:mm", "MMM dd yyyy HH:mm:ss. zzz", "MMM dd yyyy HH:mm:ss zzz", "dd.MM.yyyy HH:mm:ss zzz", "dd MM yyyy HH:mm:ss zzz", "dd.MM.yyyy; HH:mm:ss", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy zzz", "yyyy-MM-dd'T'HH:mm:ssXXX"};
    private String[] dateStyles = null;
    private Configuration conf;
    static Pattern[] patterns = new Pattern[]{null, null};

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        String url_s = url.toString();
        this.addTime(doc, parse.getData(), url_s, datum);
        this.addLength(doc, parse.getData());
        this.addType(doc, parse.getData(), url_s, datum);
        this.resetTitle(doc, parse.getData());
        return doc;
    }

    private NutchDocument addTime(NutchDocument doc, ParseData data, String url, CrawlDatum datum) {
        long time = -1L;
        String lastModified = data.getMeta("Last-Modified");
        if (lastModified != null && (time = this.getTime(lastModified, url)) > -1L) {
            doc.add("lastModified", (Object)new Date(time));
        }
        if (time == -1L && (time = datum.getModifiedTime()) <= 0L) {
            time = datum.getFetchTime();
        }
        doc.add("date", (Object)new Date(time));
        return doc;
    }

    private long getTime(String date, String url) {
        long time = -1L;
        try {
            time = HttpDateFormat.toLong((String)date);
        }
        catch (ParseException e) {
            try {
                Date parsedDate = DateUtils.parseDate((String)date, (String[])this.dateStyles);
                time = parsedDate.getTime();
                LOG.info("{}: parsed date: {} to: {}", new Object[]{url, date, time});
            }
            catch (Exception e2) {
                LOG.warn("{}: can't parse erroneous date: {}", (Object)url, (Object)date);
            }
        }
        return time;
    }

    private NutchDocument addLength(NutchDocument doc, ParseData data) {
        String trimmed;
        String contentLength = data.getMeta("Content-Length");
        if (contentLength != null && !(trimmed = contentLength.trim()).isEmpty()) {
            doc.add("contentLength", (Object)trimmed);
        }
        return doc;
    }

    private NutchDocument addType(NutchDocument doc, ParseData data, String url, CrawlDatum datum) {
        String mimeType = null;
        String contentType = null;
        Writable tcontentType = datum.getMetaData().get((Object)new Text("Content-Type"));
        contentType = tcontentType != null ? tcontentType.toString() : data.getMeta("Content-Type");
        mimeType = contentType == null ? this.tika.detect(url) : this.MIME.forName(MimeUtil.cleanMimeType((String)contentType));
        if (mimeType == null) {
            return doc;
        }
        if (this.mapMimes && this.mimeMap.containsKey(mimeType)) {
            if (this.mapFieldName != null) {
                doc.add(this.mapFieldName, (Object)this.mimeMap.get(mimeType));
            } else {
                mimeType = this.mimeMap.get(mimeType);
            }
        }
        contentType = mimeType;
        doc.add("type", (Object)contentType);
        if (this.conf.getBoolean("moreIndexingFilter.indexMimeTypeParts", true)) {
            String[] parts;
            for (String part : parts = MoreIndexingFilter.getParts(contentType)) {
                doc.add("type", (Object)part);
            }
        }
        return doc;
    }

    static String[] getParts(String mimeType) {
        return mimeType.split("/");
    }

    private NutchDocument resetTitle(NutchDocument doc, ParseData data) {
        String contentDisposition = data.getMeta("Content-Disposition");
        if (contentDisposition == null || doc.getFieldValue("title") != null) {
            return doc;
        }
        for (int i = 0; i < patterns.length; ++i) {
            Matcher matcher = patterns[i].matcher(contentDisposition);
            if (!matcher.find()) continue;
            doc.add("title", (Object)matcher.group(1));
            break;
        }
        return doc;
    }

    public void setConf(Configuration conf) {
        URL dateStylesResource;
        this.conf = conf;
        this.MIME = new MimeUtil(conf);
        if (conf.getBoolean("moreIndexingFilter.mapMimeTypes", false)) {
            this.mapMimes = true;
            this.mapFieldName = conf.get("moreIndexingFilter.mapMimeTypes.field");
            try {
                this.readConfiguration();
            }
            catch (Exception e) {
                LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            }
        }
        if ((dateStylesResource = conf.getResource("date-styles.txt")) == null) {
            this.dateStyles = this.defaultDateStyles;
            LOG.warn("Can't find resource: date-styles.txt - Defaults will be used.");
        } else {
            try {
                ArrayList<String> usedLines = new ArrayList<String>();
                for (String dateStyle : FileUtils.readLines((File)new File(dateStylesResource.getFile()), (Charset)StandardCharsets.US_ASCII)) {
                    if (StringUtils.isBlank((CharSequence)dateStyle) || dateStyle.startsWith("#")) continue;
                    usedLines.add(StringUtils.trim((String)dateStyle));
                }
                this.dateStyles = new String[usedLines.size()];
                usedLines.toArray(this.dateStyles);
            }
            catch (IOException e) {
                LOG.error("Failed to load resource: date-styles.txt", (Throwable)e);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void readConfiguration() throws IOException {
        LOG.info("Reading content type mappings from file contenttype-mapping.txt");
        try (BufferedReader reader = new BufferedReader(this.conf.getConfResourceAsReader("contenttype-mapping.txt"));){
            String line;
            boolean formatWarningShown = false;
            this.mimeMap = new HashMap();
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isBlank((CharSequence)line) || line.startsWith("#")) continue;
                String[] parts = (line = line.trim()).split("\t");
                if (parts.length > 1) {
                    for (int i = 1; i < parts.length; ++i) {
                        this.mimeMap.put(parts[i].trim(), parts[0].trim());
                    }
                    continue;
                }
                LOG.warn("Wrong format of line: {}", (Object)line);
                if (formatWarningShown) continue;
                LOG.warn("Expected format: <target type> <tab> <type1> [<tab> <type2> ...]");
                formatWarningShown = true;
            }
        }
    }

    static {
        try {
            MoreIndexingFilter.patterns[0] = Pattern.compile("\\bfilename=['\"]([^\"]+)");
            MoreIndexingFilter.patterns[1] = Pattern.compile("\\bfilename=(\\S+)\\b");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

