/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.geoip;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.InsightsResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.RepresentedCountry;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.nutch.indexer.NutchDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPDocumentCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void addIfNotNull(NutchDocument doc, String name, Object value) {
        if (value != null) {
            doc.add(name, value);
        }
    }

    public static NutchDocument createDocFromInsightsService(String serverIp, NutchDocument doc, WebServiceClient client) throws UnknownHostException, IOException, GeoIp2Exception {
        GeoIPDocumentCreator.addIfNotNull(doc, "ip", serverIp);
        InsightsResponse response = client.insights(InetAddress.getByName(serverIp));
        City city = response.getCity();
        GeoIPDocumentCreator.addIfNotNull(doc, "cityName", city.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "cityConfidence", city.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "cityGeoNameId", city.getGeoNameId());
        Continent continent = response.getContinent();
        GeoIPDocumentCreator.addIfNotNull(doc, "continentCode", continent.getCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "continentGeoNameId", continent.getGeoNameId());
        GeoIPDocumentCreator.addIfNotNull(doc, "continentName", continent.getName());
        Country country = response.getCountry();
        GeoIPDocumentCreator.addIfNotNull(doc, "countryIsoCode", country.getIsoCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryName", country.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryConfidence", country.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryGeoNameId", country.getGeoNameId());
        Location location = response.getLocation();
        GeoIPDocumentCreator.addIfNotNull(doc, "latLon", location.getLatitude() + "," + location.getLongitude());
        GeoIPDocumentCreator.addIfNotNull(doc, "accRadius", location.getAccuracyRadius());
        GeoIPDocumentCreator.addIfNotNull(doc, "timeZone", location.getTimeZone());
        GeoIPDocumentCreator.addIfNotNull(doc, "metroCode", location.getMetroCode());
        Postal postal = response.getPostal();
        GeoIPDocumentCreator.addIfNotNull(doc, "postalCode", postal.getCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "postalConfidence", postal.getConfidence());
        RepresentedCountry rCountry = response.getRepresentedCountry();
        GeoIPDocumentCreator.addIfNotNull(doc, "countryType", rCountry.getType());
        Subdivision subdivision = response.getMostSpecificSubdivision();
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivName", subdivision.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivIsoCode", subdivision.getIsoCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivConfidence", subdivision.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivGeoNameId", subdivision.getGeoNameId());
        Traits traits = response.getTraits();
        GeoIPDocumentCreator.addIfNotNull(doc, "autonSystemNum", traits.getAutonomousSystemNumber());
        GeoIPDocumentCreator.addIfNotNull(doc, "autonSystemOrg", traits.getAutonomousSystemOrganization());
        GeoIPDocumentCreator.addIfNotNull(doc, "domain", traits.getDomain());
        GeoIPDocumentCreator.addIfNotNull(doc, "isp", traits.getIsp());
        GeoIPDocumentCreator.addIfNotNull(doc, "org", traits.getOrganization());
        GeoIPDocumentCreator.addIfNotNull(doc, "userType", traits.getUserType());
        GeoIPDocumentCreator.addIfNotNull(doc, "isAnonProxy", String.valueOf(traits.isAnonymousProxy()));
        return doc;
    }

    public static NutchDocument createDocFromCityService(String serverIp, NutchDocument doc, WebServiceClient client) throws UnknownHostException, IOException, GeoIp2Exception {
        CityResponse response = client.city(InetAddress.getByName(serverIp));
        return doc;
    }

    public static NutchDocument createDocFromCountryService(String serverIp, NutchDocument doc, WebServiceClient client) throws UnknownHostException, IOException, GeoIp2Exception {
        CountryResponse response = client.country(InetAddress.getByName(serverIp));
        return doc;
    }

    public static NutchDocument createDocFromIspDb(String serverIp, NutchDocument doc, DatabaseReader reader) throws UnknownHostException, IOException, GeoIp2Exception {
        IspResponse response = reader.isp(InetAddress.getByName(serverIp));
        GeoIPDocumentCreator.addIfNotNull(doc, "ip", serverIp);
        GeoIPDocumentCreator.addIfNotNull(doc, "autonSystemNum", response.getAutonomousSystemNumber());
        GeoIPDocumentCreator.addIfNotNull(doc, "autonSystemOrg", response.getAutonomousSystemOrganization());
        GeoIPDocumentCreator.addIfNotNull(doc, "isp", response.getIsp());
        GeoIPDocumentCreator.addIfNotNull(doc, "org", response.getOrganization());
        return doc;
    }

    public static NutchDocument createDocFromDomainDb(String serverIp, NutchDocument doc, DatabaseReader reader) throws UnknownHostException, IOException, GeoIp2Exception {
        DomainResponse response;
        try {
            response = reader.domain(InetAddress.getByName(serverIp));
        }
        catch (AddressNotFoundException e) {
            LOG.debug("IP address not found: {}", (Object)serverIp);
            return doc;
        }
        GeoIPDocumentCreator.addIfNotNull(doc, "ip", serverIp);
        GeoIPDocumentCreator.addIfNotNull(doc, "domain", response.getDomain());
        return doc;
    }

    public static NutchDocument createDocFromConnectionDb(String serverIp, NutchDocument doc, DatabaseReader reader) throws UnknownHostException, IOException, GeoIp2Exception {
        ConnectionTypeResponse response = reader.connectionType(InetAddress.getByName(serverIp));
        GeoIPDocumentCreator.addIfNotNull(doc, "ip", serverIp);
        GeoIPDocumentCreator.addIfNotNull(doc, "connType", response.getConnectionType().toString());
        return doc;
    }

    public static NutchDocument createDocFromCityDb(String serverIp, NutchDocument doc, DatabaseReader reader) throws UnknownHostException, IOException, GeoIp2Exception {
        CityResponse response;
        GeoIPDocumentCreator.addIfNotNull(doc, "ip", serverIp);
        try {
            response = reader.city(InetAddress.getByName(serverIp));
        }
        catch (AddressNotFoundException e) {
            LOG.debug("IP address not found: {}", (Object)serverIp);
            return doc;
        }
        City city = response.getCity();
        GeoIPDocumentCreator.addIfNotNull(doc, "cityName", city.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "cityConfidence", city.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "cityGeoNameId", city.getGeoNameId());
        Continent continent = response.getContinent();
        GeoIPDocumentCreator.addIfNotNull(doc, "continentCode", continent.getCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "continentGeoNameId", continent.getGeoNameId());
        GeoIPDocumentCreator.addIfNotNull(doc, "continentName", continent.getName());
        Country country = response.getCountry();
        GeoIPDocumentCreator.addIfNotNull(doc, "countryIsoCode", country.getIsoCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryName", country.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryConfidence", country.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "countryGeoNameId", country.getGeoNameId());
        Location location = response.getLocation();
        GeoIPDocumentCreator.addIfNotNull(doc, "latLon", location.getLatitude() + "," + location.getLongitude());
        GeoIPDocumentCreator.addIfNotNull(doc, "accRadius", location.getAccuracyRadius());
        GeoIPDocumentCreator.addIfNotNull(doc, "timeZone", location.getTimeZone());
        GeoIPDocumentCreator.addIfNotNull(doc, "metroCode", location.getMetroCode());
        Postal postal = response.getPostal();
        GeoIPDocumentCreator.addIfNotNull(doc, "postalCode", postal.getCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "postalConfidence", postal.getConfidence());
        RepresentedCountry rCountry = response.getRepresentedCountry();
        GeoIPDocumentCreator.addIfNotNull(doc, "countryType", rCountry.getType());
        Subdivision subdivision = response.getMostSpecificSubdivision();
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivName", subdivision.getName());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivIsoCode", subdivision.getIsoCode());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivConfidence", subdivision.getConfidence());
        GeoIPDocumentCreator.addIfNotNull(doc, "subDivGeoNameId", subdivision.getGeoNameId());
        return doc;
    }
}

