/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.SecretKey;
import javax.net.ssl.HttpsURLConnection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.security.IntermediateEncryptedStream;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleSchedulerImpl;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Fetcher<K, V>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(Fetcher.class);
    private static final int DEFAULT_STALLED_COPY_TIMEOUT = 180000;
    private static final int UNIT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_READ_TIMEOUT = 180000;
    private static final long FETCH_RETRY_DELAY_DEFAULT = 1000L;
    static final int TOO_MANY_REQ_STATUS_CODE = 429;
    private static final String FETCH_RETRY_AFTER_HEADER = "Retry-After";
    protected final Reporter reporter;
    private static final String SHUFFLE_ERR_GRP_NAME = "Shuffle Errors";
    private final JobConf jobConf;
    private final Counters.Counter connectionErrs;
    private final Counters.Counter ioErrs;
    private final Counters.Counter wrongLengthErrs;
    private final Counters.Counter badIdErrs;
    private final Counters.Counter wrongMapErrs;
    private final Counters.Counter wrongReduceErrs;
    protected final MergeManager<K, V> merger;
    protected final ShuffleSchedulerImpl<K, V> scheduler;
    protected final ShuffleClientMetrics metrics;
    protected final ExceptionReporter exceptionReporter;
    protected final int id;
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    protected final int reduce;
    private final int connectionTimeout;
    private final int readTimeout;
    private final int fetchRetryTimeout;
    private final int fetchRetryInterval;
    private final boolean fetchRetryEnabled;
    private final SecretKey shuffleSecretKey;
    protected HttpURLConnection connection;
    private volatile boolean stopped = false;
    private long retryStartTime = 0L;
    private static boolean sslShuffle;
    private static SSLFactory sslFactory;
    private static TaskAttemptID[] EMPTY_ATTEMPT_ID_ARRAY;

    public Fetcher(JobConf job, TaskAttemptID reduceId, ShuffleSchedulerImpl<K, V> scheduler, MergeManager<K, V> merger, Reporter reporter, ShuffleClientMetrics metrics, ExceptionReporter exceptionReporter, SecretKey shuffleKey) {
        this(job, reduceId, scheduler, merger, reporter, metrics, exceptionReporter, shuffleKey, NEXT_ID.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Fetcher(JobConf job, TaskAttemptID reduceId, ShuffleSchedulerImpl<K, V> scheduler, MergeManager<K, V> merger, Reporter reporter, ShuffleClientMetrics metrics, ExceptionReporter exceptionReporter, SecretKey shuffleKey, int id) {
        this.jobConf = job;
        this.reporter = reporter;
        this.scheduler = scheduler;
        this.merger = merger;
        this.metrics = metrics;
        this.exceptionReporter = exceptionReporter;
        this.id = id;
        this.reduce = reduceId.getTaskID().getId();
        this.shuffleSecretKey = shuffleKey;
        this.ioErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.IO_ERROR.toString());
        this.wrongLengthErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_LENGTH.toString());
        this.badIdErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.BAD_ID.toString());
        this.wrongMapErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_MAP.toString());
        this.connectionErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.CONNECTION.toString());
        this.wrongReduceErrs = reporter.getCounter(SHUFFLE_ERR_GRP_NAME, ShuffleErrors.WRONG_REDUCE.toString());
        this.connectionTimeout = job.getInt("mapreduce.reduce.shuffle.connect.timeout", 180000);
        this.readTimeout = job.getInt("mapreduce.reduce.shuffle.read.timeout", 180000);
        this.fetchRetryInterval = job.getInt("mapreduce.reduce.shuffle.fetch.retry.interval-ms", 1000);
        this.fetchRetryTimeout = job.getInt("mapreduce.reduce.shuffle.fetch.retry.timeout-ms", 180000);
        boolean shuffleFetchEnabledDefault = job.getBoolean("yarn.nodemanager.recovery.enabled", false);
        this.fetchRetryEnabled = job.getBoolean("mapreduce.reduce.shuffle.fetch.retry.enabled", shuffleFetchEnabledDefault);
        this.setName("fetcher#" + id);
        this.setDaemon(true);
        Class<Fetcher> clazz = Fetcher.class;
        synchronized (Fetcher.class) {
            sslShuffle = job.getBoolean("mapreduce.shuffle.ssl.enabled", false);
            if (sslShuffle && sslFactory == null) {
                sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, (Configuration)job);
                try {
                    sslFactory.init();
                }
                catch (Exception ex) {
                    sslFactory.destroy();
                    throw new RuntimeException(ex);
                }
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                MapHost host = null;
                try {
                    this.merger.waitForResource();
                    host = this.scheduler.getHost();
                    this.metrics.threadBusy();
                    this.copyFromHost(host);
                }
                finally {
                    if (host == null) continue;
                    this.scheduler.freeHost(host);
                    this.metrics.threadFree();
                }
            }
            return;
        }
        catch (InterruptedException ie) {
            return;
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
        }
    }

    @Override
    public void interrupt() {
        try {
            this.closeConnection();
        }
        finally {
            super.interrupt();
        }
    }

    public void shutDown() throws InterruptedException {
        this.stopped = true;
        this.interrupt();
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn("Got interrupt while joining " + this.getName(), (Throwable)ie);
        }
        if (sslFactory != null) {
            sslFactory.destroy();
        }
    }

    @VisibleForTesting
    protected synchronized void openConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (sslShuffle) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            try {
                httpsConn.setSSLSocketFactory(sslFactory.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            httpsConn.setHostnameVerifier(sslFactory.getHostnameVerifier());
        }
        this.connection = conn;
    }

    protected synchronized void closeConnection() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private void abortConnect(MapHost host, Set<TaskAttemptID> remaining) {
        for (TaskAttemptID left : remaining) {
            this.scheduler.putBackKnownMapOutput(host, left);
        }
        this.closeConnection();
    }

    private DataInputStream openShuffleUrl(MapHost host, Set<TaskAttemptID> remaining, URL url) {
        DataInputStream input = null;
        try {
            this.setupConnectionsWithRetry(url);
            if (this.stopped) {
                this.abortConnect(host, remaining);
            } else {
                input = new DataInputStream(this.connection.getInputStream());
            }
        }
        catch (TryAgainLaterException te) {
            LOG.warn("Connection rejected by the host " + te.host + ". Will retry later.");
            this.scheduler.penalize(host, te.backoff);
        }
        catch (IOException ie) {
            boolean connectExcpt = ie instanceof ConnectException;
            this.ioErrs.increment(1L);
            LOG.warn("Failed to connect to " + host + " with " + remaining.size() + " map outputs", (Throwable)ie);
            this.scheduler.hostFailed(host.getHostName());
            for (TaskAttemptID left : remaining) {
                this.scheduler.copyFailed(left, host, false, connectExcpt);
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected void copyFromHost(MapHost host) throws IOException {
        block23: {
            this.retryStartTime = 0L;
            maps = this.scheduler.getMapsForHost(host);
            if (maps.size() == 0) {
                return;
            }
            if (Fetcher.LOG.isDebugEnabled()) {
                Fetcher.LOG.debug("Fetcher " + this.id + " going to fetch from " + host + " for: " + maps);
            }
            remaining = new HashSet<TaskAttemptID>(maps);
            url = this.getMapOutputURL(host, maps);
            input = null;
            input = this.openShuffleUrl(host, remaining, url);
            if (input != null) ** GOTO lbl36
            if (input != null) {
            }
            ** GOTO lbl29
            {
                catch (Throwable var11_16) {
                    if (input != null) {
                        IOUtils.cleanupWithLogger((Logger)Fetcher.LOG, (Closeable[])new Closeable[]{input});
                        input = null;
                    }
                    var12_17 = remaining.iterator();
                    while (true) {
                        if (!var12_17.hasNext()) {
                            throw var11_16;
                        }
                        left = (TaskAttemptID)var12_17.next();
                        this.scheduler.putBackKnownMapOutput(host, left);
                    }
                }
                IOUtils.cleanupWithLogger((Logger)Fetcher.LOG, (Closeable[])new Closeable[]{input});
                input = null;
lbl29:
                // 2 sources

                var6_6 = remaining.iterator();
                while (true) {
                    if (!var6_6.hasNext()) {
                        return;
                    }
                    left = (TaskAttemptID)var6_6.next();
                    this.scheduler.putBackKnownMapOutput(host, left);
                }
lbl36:
                // 1 sources

                failedTasks = null;
                while (!remaining.isEmpty() && failedTasks == null) {
                    try {
                        failedTasks = this.copyMapOutput(host, input, remaining, this.fetchRetryEnabled);
                    }
                    catch (IOException e) {}
                    IOUtils.cleanupWithLogger((Logger)Fetcher.LOG, (Closeable[])new Closeable[]{input});
                    this.connection.disconnect();
                    url = this.getMapOutputURL(host, remaining);
                    input = this.openShuffleUrl(host, remaining, url);
                    if (input != null) continue;
                    if (input != null) {
                        IOUtils.cleanupWithLogger((Logger)Fetcher.LOG, (Closeable[])new Closeable[]{input});
                        input = null;
                    }
                    var8_11 = remaining.iterator();
                    while (true) {
                        if (!var8_11.hasNext()) {
                            return;
                        }
                        left = (TaskAttemptID)var8_11.next();
                        this.scheduler.putBackKnownMapOutput(host, left);
                    }
                }
            }
            {
                if (failedTasks != null && failedTasks.length > 0) {
                    Fetcher.LOG.warn("copyMapOutput failed for tasks " + Arrays.toString(failedTasks));
                    this.scheduler.hostFailed(host.getHostName());
                    for (Object left : failedTasks) {
                        this.scheduler.copyFailed((TaskAttemptID)left, host, true, false);
                    }
                }
                if (failedTasks == null && !remaining.isEmpty()) {
                    throw new IOException("server didn't return all expected map outputs: " + remaining.size() + " left.");
                }
                input.close();
                input = null;
                if (input == null) break block23;
            }
            IOUtils.cleanupWithLogger((Logger)Fetcher.LOG, (Closeable[])new Closeable[]{input});
            input = null;
        }
        var6_7 = remaining.iterator();
        while (true) {
            if (!var6_7.hasNext()) {
                return;
            }
            left = (TaskAttemptID)var6_7.next();
            this.scheduler.putBackKnownMapOutput(host, left);
        }
    }

    private void setupConnectionsWithRetry(URL url) throws IOException {
        this.openConnectionWithRetry(url);
        if (this.stopped) {
            return;
        }
        String msgToEncode = SecureShuffleUtils.buildMsgFrom(url);
        String encHash = SecureShuffleUtils.hashFromString(msgToEncode, this.shuffleSecretKey);
        this.setupShuffleConnection(encHash);
        this.connect(this.connection, this.connectionTimeout);
        if (this.stopped) {
            return;
        }
        this.verifyConnection(url, msgToEncode, encHash);
    }

    private void openConnectionWithRetry(URL url) throws IOException {
        long startTime = Time.monotonicNow();
        boolean shouldWait = true;
        while (shouldWait) {
            try {
                this.openConnection(url);
                shouldWait = false;
            }
            catch (IOException e) {
                if (!this.fetchRetryEnabled) {
                    throw e;
                }
                if (Time.monotonicNow() - startTime >= (long)this.fetchRetryTimeout) {
                    LOG.warn("Failed to connect to host: " + url + "after " + this.fetchRetryTimeout + " milliseconds.");
                    throw e;
                }
                try {
                    Thread.sleep(this.fetchRetryInterval);
                }
                catch (InterruptedException e1) {
                    if (!this.stopped) continue;
                    return;
                }
            }
        }
    }

    private void verifyConnection(URL url, String msgToEncode, String encHash) throws IOException {
        int rc = this.connection.getResponseCode();
        if (rc == 429) {
            long backoff = this.connection.getHeaderFieldLong(FETCH_RETRY_AFTER_HEADER, 1000L);
            if (backoff < 0L) {
                backoff = 1000L;
                LOG.warn("Get a negative backoff value from ShuffleHandler. Setting it to the default value 1000");
            }
            throw new TryAgainLaterException(backoff, url.getHost());
        }
        if (rc != 200) {
            throw new IOException("Got invalid response code " + rc + " from " + url + ": " + this.connection.getResponseMessage());
        }
        if (!"mapreduce".equals(this.connection.getHeaderField("name")) || !"1.0.0".equals(this.connection.getHeaderField("version"))) {
            throw new IOException("Incompatible shuffle response version");
        }
        String replyHash = this.connection.getHeaderField("ReplyHash");
        if (replyHash == null) {
            throw new IOException("security validation of TT Map output failed");
        }
        LOG.debug("url=" + msgToEncode + ";encHash=" + encHash + ";replyHash=" + replyHash);
        SecureShuffleUtils.verifyReply(replyHash, encHash, this.shuffleSecretKey);
        LOG.debug("for url=" + msgToEncode + " sent hash and received reply");
    }

    private void setupShuffleConnection(String encHash) {
        this.connection.addRequestProperty("UrlHash", encHash);
        this.connection.setReadTimeout(this.readTimeout);
        this.connection.addRequestProperty("name", "mapreduce");
        this.connection.addRequestProperty("version", "1.0.0");
    }

    private TaskAttemptID[] copyMapOutput(MapHost host, DataInputStream input, Set<TaskAttemptID> remaining, boolean canRetry) throws IOException {
        MapOutput<K, V> mapOutput = null;
        TaskAttemptID mapId = null;
        long decompressedLength = -1L;
        long compressedLength = -1L;
        try {
            long startTime = Time.monotonicNow();
            int forReduce = -1;
            try {
                ShuffleHeader header = new ShuffleHeader();
                header.readFields(input);
                mapId = TaskAttemptID.forName(header.mapId);
                compressedLength = header.compressedLength;
                decompressedLength = header.uncompressedLength;
                forReduce = header.forReduce;
            }
            catch (IllegalArgumentException e) {
                this.badIdErrs.increment(1L);
                LOG.warn("Invalid map id ", (Throwable)e);
                return remaining.toArray(new TaskAttemptID[remaining.size()]);
            }
            InputStream is = input;
            is = IntermediateEncryptedStream.wrapIfNecessary((Configuration)this.jobConf, is, compressedLength, null);
            if (!this.verifySanity(compressedLength -= (long)CryptoUtils.cryptoPadding(this.jobConf), decompressedLength -= (long)CryptoUtils.cryptoPadding(this.jobConf), forReduce, remaining, mapId)) {
                return new TaskAttemptID[]{mapId};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("header: " + mapId + ", len: " + compressedLength + ", decomp len: " + decompressedLength);
            }
            try {
                mapOutput = this.merger.reserve(mapId, decompressedLength, this.id);
            }
            catch (IOException ioe) {
                this.ioErrs.increment(1L);
                this.scheduler.reportLocalError(ioe);
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            if (mapOutput == null) {
                LOG.info("fetcher#" + this.id + " - MergeManager returned status WAIT ...");
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            try {
                LOG.info("fetcher#" + this.id + " about to shuffle output of map " + mapOutput.getMapId() + " decomp: " + decompressedLength + " len: " + compressedLength + " to " + mapOutput.getDescription());
                mapOutput.shuffle(host, is, compressedLength, decompressedLength, this.metrics, this.reporter);
            }
            catch (Exception | InternalError e) {
                LOG.warn("Failed to shuffle for fetcher#" + this.id, e);
                throw new IOException(e);
            }
            long endTime = Time.monotonicNow();
            this.retryStartTime = 0L;
            this.scheduler.copySucceeded(mapId, host, compressedLength, startTime, endTime, mapOutput);
            remaining.remove(mapId);
            this.metrics.successFetch();
            return null;
        }
        catch (IOException ioe) {
            if (mapOutput != null) {
                mapOutput.abort();
            }
            if (canRetry) {
                this.checkTimeoutOrRetry(host, ioe);
            }
            this.ioErrs.increment(1L);
            if (mapId == null || mapOutput == null) {
                LOG.warn("fetcher#" + this.id + " failed to read map header" + mapId + " decomp: " + decompressedLength + ", " + compressedLength, (Throwable)ioe);
                if (mapId == null) {
                    return remaining.toArray(new TaskAttemptID[remaining.size()]);
                }
                return new TaskAttemptID[]{mapId};
            }
            LOG.warn("Failed to shuffle output of " + mapId + " from " + host.getHostName(), (Throwable)ioe);
            this.metrics.failedFetch();
            return new TaskAttemptID[]{mapId};
        }
    }

    private void checkTimeoutOrRetry(MapHost host, IOException ioe) throws IOException {
        long currentTime = Time.monotonicNow();
        if (this.retryStartTime == 0L) {
            this.retryStartTime = currentTime;
        }
        if (currentTime - this.retryStartTime < (long)this.fetchRetryTimeout) {
            LOG.warn("Shuffle output from " + host.getHostName() + " failed, retry it.", (Throwable)ioe);
            throw ioe;
        }
        LOG.warn("Timeout for copying MapOutput with retry on host " + host + "after " + this.fetchRetryTimeout + " milliseconds.");
    }

    private boolean verifySanity(long compressedLength, long decompressedLength, int forReduce, Set<TaskAttemptID> remaining, TaskAttemptID mapId) {
        if (compressedLength < 0L || decompressedLength < 0L) {
            this.wrongLengthErrs.increment(1L);
            LOG.warn(this.getName() + " invalid lengths in map output header: id: " + mapId + " len: " + compressedLength + ", decomp len: " + decompressedLength);
            return false;
        }
        if (forReduce != this.reduce) {
            this.wrongReduceErrs.increment(1L);
            LOG.warn(this.getName() + " data for the wrong reduce map: " + mapId + " len: " + compressedLength + " decomp len: " + decompressedLength + " for reduce " + forReduce);
            return false;
        }
        if (!remaining.contains(mapId)) {
            this.wrongMapErrs.increment(1L);
            LOG.warn("Invalid map-output! Received output for " + mapId);
            return false;
        }
        return true;
    }

    private URL getMapOutputURL(MapHost host, Collection<TaskAttemptID> maps) throws MalformedURLException {
        StringBuffer url = new StringBuffer(host.getBaseUrl());
        boolean first = true;
        for (TaskAttemptID mapId : maps) {
            if (!first) {
                url.append(",");
            }
            url.append(mapId);
            first = false;
        }
        LOG.debug("MapOutput URL for " + host + " -> " + url.toString());
        return new URL(url.toString());
    }

    private void connect(URLConnection connection, int connectionTimeout) throws IOException {
        long startTime;
        int unit = 0;
        if (connectionTimeout < 0) {
            throw new IOException("Invalid timeout [timeout = " + connectionTimeout + " ms]");
        }
        if (connectionTimeout > 0) {
            unit = Math.min(60000, connectionTimeout);
        }
        long lastTime = startTime = Time.monotonicNow();
        int attempts = 0;
        connection.setConnectTimeout(unit);
        while (true) {
            try {
                ++attempts;
                connection.connect();
            }
            catch (IOException ioe) {
                block10: {
                    long currentTime = Time.monotonicNow();
                    long retryTime = currentTime - startTime;
                    long leftTime = (long)connectionTimeout - retryTime;
                    long timeSinceLastIteration = currentTime - lastTime;
                    if (leftTime <= 0L) {
                        int retryTimeInSeconds = (int)retryTime / 1000;
                        LOG.error("Connection retry failed with " + attempts + " attempts in " + retryTimeInSeconds + " seconds");
                        throw ioe;
                    }
                    if (leftTime < (long)unit) {
                        unit = (int)leftTime;
                        connection.setConnectTimeout(unit);
                    }
                    if (timeSinceLastIteration < (long)unit) {
                        try {
                            Fetcher.sleep((long)unit - timeSinceLastIteration);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Sleep in connection retry get interrupted.");
                            if (!this.stopped) break block10;
                            return;
                        }
                    }
                }
                lastTime = Time.monotonicNow();
                continue;
            }
            break;
        }
    }

    static {
        EMPTY_ATTEMPT_ID_ARRAY = new TaskAttemptID[0];
    }

    private static class TryAgainLaterException
    extends IOException {
        public final long backoff;
        public final String host;

        public TryAgainLaterException(long backoff, String host) {
            super("Too many requests to a map host");
            this.backoff = backoff;
            this.host = host;
        }
    }

    private static enum ShuffleErrors {
        IO_ERROR,
        WRONG_LENGTH,
        BAD_ID,
        WRONG_MAP,
        CONNECTION,
        WRONG_REDUCE;

    }
}

