/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemotePartitionDeleteMetadataRecord
implements ApiMessage {
    TopicIdPartitionEntry topicIdPartition;
    int brokerId;
    long eventTimestampMs;
    byte remotePartitionDeleteState;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id_partition", (Type)TopicIdPartitionEntry.SCHEMA_0, "Represents unique topic partition."), new Field("broker_id", (Type)Type.INT32, "Broker (controller or leader) id from which this event is created. DELETE_PARTITION_MARKED is sent by the controller. DELETE_PARTITION_STARTED and DELETE_PARTITION_FINISHED are sent by remote log metadata topic partition leader."), new Field("event_timestamp_ms", (Type)Type.INT64, "Epoch time in milli seconds at which this event is generated."), new Field("remote_partition_delete_state", (Type)Type.INT8, "Deletion state identifier of the remote partition, which is RemotePartitionDeleteState.id()."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public RemotePartitionDeleteMetadataRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RemotePartitionDeleteMetadataRecord() {
        this.topicIdPartition = new TopicIdPartitionEntry();
        this.brokerId = 0;
        this.eventTimestampMs = 0L;
        this.remotePartitionDeleteState = 0;
    }

    public short apiKey() {
        return 2;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        this.topicIdPartition = new TopicIdPartitionEntry(_readable, _version);
        this.brokerId = _readable.readInt();
        this.eventTimestampMs = _readable.readLong();
        this.remotePartitionDeleteState = _readable.readByte();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        this.topicIdPartition.write(_writable, _cache, _version);
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.eventTimestampMs);
        _writable.writeByte(this.remotePartitionDeleteState);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        this.topicIdPartition.addSize(_size, _cache, _version);
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemotePartitionDeleteMetadataRecord)) {
            return false;
        }
        RemotePartitionDeleteMetadataRecord other = (RemotePartitionDeleteMetadataRecord)obj;
        if (this.topicIdPartition == null ? other.topicIdPartition != null : !this.topicIdPartition.equals(other.topicIdPartition)) {
            return false;
        }
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.eventTimestampMs != other.eventTimestampMs) {
            return false;
        }
        if (this.remotePartitionDeleteState != other.remotePartitionDeleteState) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topicIdPartition == null ? 0 : this.topicIdPartition.hashCode());
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.eventTimestampMs >> 32) ^ (int)this.eventTimestampMs);
        hashCode = 31 * hashCode + this.remotePartitionDeleteState;
        return hashCode;
    }

    public RemotePartitionDeleteMetadataRecord duplicate() {
        RemotePartitionDeleteMetadataRecord _duplicate = new RemotePartitionDeleteMetadataRecord();
        _duplicate.topicIdPartition = this.topicIdPartition.duplicate();
        _duplicate.brokerId = this.brokerId;
        _duplicate.eventTimestampMs = this.eventTimestampMs;
        _duplicate.remotePartitionDeleteState = this.remotePartitionDeleteState;
        return _duplicate;
    }

    public String toString() {
        return "RemotePartitionDeleteMetadataRecord(topicIdPartition=" + this.topicIdPartition.toString() + ", brokerId=" + this.brokerId + ", eventTimestampMs=" + this.eventTimestampMs + ", remotePartitionDeleteState=" + this.remotePartitionDeleteState + ")";
    }

    public TopicIdPartitionEntry topicIdPartition() {
        return this.topicIdPartition;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long eventTimestampMs() {
        return this.eventTimestampMs;
    }

    public byte remotePartitionDeleteState() {
        return this.remotePartitionDeleteState;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemotePartitionDeleteMetadataRecord setTopicIdPartition(TopicIdPartitionEntry v) {
        this.topicIdPartition = v;
        return this;
    }

    public RemotePartitionDeleteMetadataRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public RemotePartitionDeleteMetadataRecord setEventTimestampMs(long v) {
        this.eventTimestampMs = v;
        return this;
    }

    public RemotePartitionDeleteMetadataRecord setRemotePartitionDeleteState(byte v) {
        this.remotePartitionDeleteState = v;
        return this;
    }

    public static class TopicIdPartitionEntry
    implements Message {
        String name;
        Uuid id;
        int partition;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "Topic name."), new Field("id", (Type)Type.UUID, "Unique identifier of the topic."), new Field("partition", (Type)Type.INT32, "Partition number."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicIdPartitionEntry(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicIdPartitionEntry() {
            this.name = "";
            this.id = Uuid.ZERO_UUID;
            this.partition = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicIdPartitionEntry");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.id = _readable.readUuid();
            this.partition = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUuid(this.id);
            _writable.writeInt(this.partition);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicIdPartitionEntry");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(16);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicIdPartitionEntry)) {
                return false;
            }
            TopicIdPartitionEntry other = (TopicIdPartitionEntry)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.id.equals((Object)other.id)) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.id.hashCode();
            hashCode = 31 * hashCode + this.partition;
            return hashCode;
        }

        public TopicIdPartitionEntry duplicate() {
            TopicIdPartitionEntry _duplicate = new TopicIdPartitionEntry();
            _duplicate.name = this.name;
            _duplicate.id = this.id;
            _duplicate.partition = this.partition;
            return _duplicate;
        }

        public String toString() {
            return "TopicIdPartitionEntry(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", id=" + this.id.toString() + ", partition=" + this.partition + ")";
        }

        public String name() {
            return this.name;
        }

        public Uuid id() {
            return this.id;
        }

        public int partition() {
            return this.partition;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicIdPartitionEntry setName(String v) {
            this.name = v;
            return this;
        }

        public TopicIdPartitionEntry setId(Uuid v) {
            this.id = v;
            return this;
        }

        public TopicIdPartitionEntry setPartition(int v) {
            this.partition = v;
            return this;
        }
    }
}

